/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.idp.profile.saml1;

import edu.internet2.middleware.shibboleth.common.attribute.AttributeRequestException;
import edu.internet2.middleware.shibboleth.common.attribute.BaseAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.encoding.AttributeEncodingException;
import edu.internet2.middleware.shibboleth.common.attribute.encoding.SAML1NameIdentifierEncoder;
import edu.internet2.middleware.shibboleth.common.attribute.provider.SAML1AttributeAuthority;
import edu.internet2.middleware.shibboleth.common.log.AuditLogEntry;
import edu.internet2.middleware.shibboleth.common.profile.ProfileException;
import edu.internet2.middleware.shibboleth.common.profile.provider.BaseSAMLProfileRequestContext;
import edu.internet2.middleware.shibboleth.common.relyingparty.provider.CryptoOperationRequirementLevel;
import edu.internet2.middleware.shibboleth.common.relyingparty.provider.saml1.AbstractSAML1ProfileConfiguration;
import edu.internet2.middleware.shibboleth.common.session.Session;
import edu.internet2.middleware.shibboleth.idp.profile.AbstractSAMLProfileHandler;
import edu.internet2.middleware.shibboleth.idp.profile.saml1.BaseSAML1ProfileRequestContext;
import edu.internet2.middleware.shibboleth.idp.session.ServiceInformation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.joda.time.DateTime;
import org.opensaml.Configuration;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.SAMLObjectBuilder;
import org.opensaml.common.SAMLVersion;
import org.opensaml.common.binding.encoding.SAMLMessageEncoder;
import org.opensaml.saml1.core.Assertion;
import org.opensaml.saml1.core.AttributeQuery;
import org.opensaml.saml1.core.AttributeStatement;
import org.opensaml.saml1.core.Audience;
import org.opensaml.saml1.core.AudienceRestrictionCondition;
import org.opensaml.saml1.core.Conditions;
import org.opensaml.saml1.core.ConfirmationMethod;
import org.opensaml.saml1.core.NameIdentifier;
import org.opensaml.saml1.core.RequestAbstractType;
import org.opensaml.saml1.core.Response;
import org.opensaml.saml1.core.ResponseAbstractType;
import org.opensaml.saml1.core.Statement;
import org.opensaml.saml1.core.Status;
import org.opensaml.saml1.core.StatusCode;
import org.opensaml.saml1.core.StatusMessage;
import org.opensaml.saml1.core.Subject;
import org.opensaml.saml1.core.SubjectConfirmation;
import org.opensaml.saml2.metadata.SPSSODescriptor;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.XMLObjectBuilder;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.SecurityHelper;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.SignatureException;
import org.opensaml.xml.signature.Signer;
import org.opensaml.xml.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSAML1ProfileHandler
extends AbstractSAMLProfileHandler {
    public static final SAMLVersion SAML_VERSION = SAMLVersion.VERSION_11;
    private static Logger log = LoggerFactory.getLogger(AbstractSAML1ProfileHandler.class);
    private SAMLObjectBuilder<Response> responseBuilder = (SAMLObjectBuilder)this.getBuilderFactory().getBuilder(Response.DEFAULT_ELEMENT_NAME);
    private SAMLObjectBuilder<Assertion> assertionBuilder = (SAMLObjectBuilder)this.getBuilderFactory().getBuilder(Assertion.DEFAULT_ELEMENT_NAME);
    private SAMLObjectBuilder<Conditions> conditionsBuilder = (SAMLObjectBuilder)this.getBuilderFactory().getBuilder(Conditions.DEFAULT_ELEMENT_NAME);
    private SAMLObjectBuilder<AudienceRestrictionCondition> audienceRestrictionConditionBuilder = (SAMLObjectBuilder)this.getBuilderFactory().getBuilder(AudienceRestrictionCondition.DEFAULT_ELEMENT_NAME);
    private SAMLObjectBuilder<Audience> audienceBuilder = (SAMLObjectBuilder)this.getBuilderFactory().getBuilder(Audience.DEFAULT_ELEMENT_NAME);
    private SAMLObjectBuilder<SubjectConfirmation> subjectConfirmationBuilder = (SAMLObjectBuilder)this.getBuilderFactory().getBuilder(SubjectConfirmation.DEFAULT_ELEMENT_NAME);
    private SAMLObjectBuilder<ConfirmationMethod> confirmationMethodBuilder = (SAMLObjectBuilder)this.getBuilderFactory().getBuilder(ConfirmationMethod.DEFAULT_ELEMENT_NAME);
    private SAMLObjectBuilder<Subject> subjectBuilder = (SAMLObjectBuilder)this.getBuilderFactory().getBuilder(Subject.DEFAULT_ELEMENT_NAME);
    private SAMLObjectBuilder<Status> statusBuilder = (SAMLObjectBuilder)this.getBuilderFactory().getBuilder(Status.DEFAULT_ELEMENT_NAME);
    private SAMLObjectBuilder<StatusCode> statusCodeBuilder = (SAMLObjectBuilder)this.getBuilderFactory().getBuilder(StatusCode.DEFAULT_ELEMENT_NAME);
    private SAMLObjectBuilder<StatusMessage> statusMessageBuilder = (SAMLObjectBuilder)this.getBuilderFactory().getBuilder(StatusMessage.DEFAULT_ELEMENT_NAME);
    private XMLObjectBuilder<Signature> signatureBuilder = this.getBuilderFactory().getBuilder(Signature.DEFAULT_ELEMENT_NAME);

    @Override
    protected void populateRequestContext(BaseSAMLProfileRequestContext requestContext) throws ProfileException {
        BaseSAML1ProfileRequestContext saml1Request = (BaseSAML1ProfileRequestContext)requestContext;
        try {
            super.populateRequestContext(requestContext);
        }
        catch (ProfileException e) {
            if (saml1Request.getFailureStatus() == null) {
                saml1Request.setFailureStatus(this.buildStatus(StatusCode.REQUESTER, null, e.getMessage()));
            }
            throw e;
        }
    }

    @Override
    protected void populateUserInformation(BaseSAMLProfileRequestContext requestContext) {
        NameIdentifier subject;
        edu.internet2.middleware.shibboleth.idp.session.Session userSession = this.getUserSession(requestContext.getInboundMessageTransport());
        if (userSession == null && (subject = (NameIdentifier)requestContext.getSubjectNameIdentifier()) != null && subject.getNameIdentifier() != null) {
            userSession = this.getUserSession(subject.getNameIdentifier());
        }
        if (userSession != null) {
            requestContext.setUserSession((Session)userSession);
            requestContext.setPrincipalName(userSession.getPrincipalName());
            ServiceInformation serviceInfo = userSession.getServicesInformation().get(requestContext.getInboundMessageIssuer());
            if (serviceInfo != null) {
                requestContext.setPrincipalAuthenticationMethod(serviceInfo.getAuthenticationMethod().getAuthenticationMethod());
            }
        }
    }

    protected void checkSamlVersion(BaseSAML1ProfileRequestContext<?, ?, ?> requestContext) throws ProfileException {
        SAMLObject samlObject = requestContext.getInboundSAMLMessage();
        if (samlObject instanceof RequestAbstractType) {
            RequestAbstractType request = (RequestAbstractType)samlObject;
            if (request.getMajorVersion() < 1) {
                requestContext.setFailureStatus(this.buildStatus(StatusCode.REQUESTER, StatusCode.REQUEST_VERSION_TOO_LOW, null));
                throw new ProfileException("SAML request major version too low");
            }
            if (request.getMajorVersion() > 1) {
                requestContext.setFailureStatus(this.buildStatus(StatusCode.REQUESTER, StatusCode.REQUEST_VERSION_TOO_HIGH, null));
                throw new ProfileException("SAML request major version too low");
            }
        }
    }

    protected Response buildResponse(BaseSAML1ProfileRequestContext<?, ?, ?> requestContext, List<Statement> statements) throws ProfileException {
        DateTime issueInstant = new DateTime();
        Response samlResponse = (Response)this.responseBuilder.buildObject();
        samlResponse.setIssueInstant(issueInstant);
        this.populateStatusResponse(requestContext, (ResponseAbstractType)samlResponse);
        Assertion assertion = null;
        if (statements != null && !statements.isEmpty()) {
            assertion = this.buildAssertion(requestContext, issueInstant);
            assertion.getStatements().addAll(statements);
            samlResponse.getAssertions().add(assertion);
            this.signAssertion(requestContext, assertion);
        }
        Status status = this.buildStatus(StatusCode.SUCCESS, null, null);
        samlResponse.setStatus(status);
        return samlResponse;
    }

    protected Assertion buildAssertion(BaseSAML1ProfileRequestContext<?, ?, ?> requestContext, DateTime issueInstant) {
        Assertion assertion = (Assertion)this.assertionBuilder.buildObject();
        assertion.setID(this.getIdGenerator().generateIdentifier());
        assertion.setIssueInstant(issueInstant);
        assertion.setVersion(SAMLVersion.VERSION_11);
        assertion.setIssuer(requestContext.getLocalEntityId());
        Conditions conditions = this.buildConditions(requestContext, issueInstant);
        assertion.setConditions(conditions);
        return assertion;
    }

    protected Conditions buildConditions(BaseSAML1ProfileRequestContext<?, ?, ?> requestContext, DateTime issueInstant) {
        AbstractSAML1ProfileConfiguration profileConfig = (AbstractSAML1ProfileConfiguration)requestContext.getProfileConfiguration();
        Conditions conditions = (Conditions)this.conditionsBuilder.buildObject();
        conditions.setNotBefore(issueInstant);
        conditions.setNotOnOrAfter(issueInstant.plus(profileConfig.getAssertionLifetime()));
        AudienceRestrictionCondition audienceRestriction = (AudienceRestrictionCondition)this.audienceRestrictionConditionBuilder.buildObject();
        conditions.getAudienceRestrictionConditions().add(audienceRestriction);
        Audience audience = (Audience)this.audienceBuilder.buildObject();
        audience.setUri(requestContext.getInboundMessageIssuer());
        audienceRestriction.getAudiences().add(audience);
        Collection audiences = profileConfig.getAssertionAudiences();
        if (audiences != null && audiences.size() > 0) {
            for (String audienceUri : audiences) {
                audience = (Audience)this.audienceBuilder.buildObject();
                audience.setUri(audienceUri);
                audienceRestriction.getAudiences().add(audience);
            }
        }
        return conditions;
    }

    protected Subject buildSubject(BaseSAML1ProfileRequestContext<?, ?, ?> requestContext, String confirmationMethod) throws ProfileException {
        ConfirmationMethod method = (ConfirmationMethod)this.confirmationMethodBuilder.buildObject();
        method.setConfirmationMethod(confirmationMethod);
        SubjectConfirmation subjectConfirmation = (SubjectConfirmation)this.subjectConfirmationBuilder.buildObject();
        subjectConfirmation.getConfirmationMethods().add(method);
        Subject subject = (Subject)this.subjectBuilder.buildObject();
        subject.setSubjectConfirmation(subjectConfirmation);
        NameIdentifier nameID = this.buildNameId(requestContext);
        if (nameID != null) {
            subject.setNameIdentifier(nameID);
            requestContext.setSubjectNameIdentifier((SAMLObject)nameID);
        }
        return subject;
    }

    protected NameIdentifier buildNameId(BaseSAML1ProfileRequestContext<?, ?, ?> requestContext) throws ProfileException {
        Pair<BaseAttribute, SAML1NameIdentifierEncoder> nameIdAttributeAndEncoder = null;
        try {
            nameIdAttributeAndEncoder = this.selectNameIDAttributeAndEncoder(SAML1NameIdentifierEncoder.class, requestContext);
        }
        catch (ProfileException e) {
            requestContext.setFailureStatus(this.buildStatus(StatusCode.RESPONDER, null, "Required NameIdentifier format not supported"));
            throw e;
        }
        if (nameIdAttributeAndEncoder == null) {
            return null;
        }
        BaseAttribute nameIdAttribute = (BaseAttribute)nameIdAttributeAndEncoder.getFirst();
        requestContext.setNameIdentifierAttribute(nameIdAttribute);
        SAML1NameIdentifierEncoder nameIdEncoder = (SAML1NameIdentifierEncoder)nameIdAttributeAndEncoder.getSecond();
        try {
            log.debug("Using attribute '{}' supporting name format '{}' to create the NameIdentifier for relying party '{}'", new Object[]{nameIdAttribute.getId(), nameIdEncoder.getNameFormat(), requestContext.getInboundMessageIssuer()});
            NameIdentifier nameId = (NameIdentifier)nameIdEncoder.encode(nameIdAttribute);
            if (nameId.getNameQualifier() == null) {
                nameId.setNameQualifier(requestContext.getRelyingPartyConfiguration().getProviderId());
            }
            return nameId;
        }
        catch (AttributeEncodingException e) {
            requestContext.setFailureStatus(this.buildStatus(StatusCode.RESPONDER, null, "Unable to encode NameIdentifier"));
            String msg = "Unable to encode NameIdentifier for relying party " + requestContext.getInboundMessageIssuer();
            log.error(msg, (Throwable)e);
            throw new ProfileException(msg, (Throwable)e);
        }
    }

    protected Response buildErrorResponse(BaseSAML1ProfileRequestContext<?, ?, ?> requestContext) {
        Response samlResponse = (Response)this.responseBuilder.buildObject();
        samlResponse.setIssueInstant(new DateTime());
        this.populateStatusResponse(requestContext, (ResponseAbstractType)samlResponse);
        samlResponse.setStatus(requestContext.getFailureStatus());
        return samlResponse;
    }

    protected void populateStatusResponse(BaseSAML1ProfileRequestContext<?, ?, ?> requestContext, ResponseAbstractType response) {
        response.setID(this.getIdGenerator().generateIdentifier());
        SAMLObject samlMessage = requestContext.getInboundSAMLMessage();
        if (samlMessage != null && samlMessage instanceof RequestAbstractType) {
            response.setInResponseTo(((RequestAbstractType)samlMessage).getID());
        }
        response.setVersion(SAMLVersion.VERSION_11);
    }

    protected Status buildStatus(QName topLevelCode, QName secondLevelCode, String failureMessage) {
        Status status = (Status)this.statusBuilder.buildObject();
        StatusCode statusCode = (StatusCode)this.statusCodeBuilder.buildObject();
        statusCode.setValue(topLevelCode);
        status.setStatusCode(statusCode);
        if (secondLevelCode != null) {
            StatusCode secondLevelStatusCode = (StatusCode)this.statusCodeBuilder.buildObject();
            secondLevelStatusCode.setValue(secondLevelCode);
            statusCode.setStatusCode(secondLevelStatusCode);
        }
        if (failureMessage != null) {
            StatusMessage msg = (StatusMessage)this.statusMessageBuilder.buildObject();
            msg.setMessage(failureMessage);
            status.setStatusMessage(msg);
        }
        return status;
    }

    protected void resolveAttributes(BaseSAML1ProfileRequestContext<?, ?, ?> requestContext) throws ProfileException {
        AbstractSAML1ProfileConfiguration profileConfiguration = (AbstractSAML1ProfileConfiguration)requestContext.getProfileConfiguration();
        SAML1AttributeAuthority attributeAuthority = profileConfiguration.getAttributeAuthority();
        try {
            log.debug("Resolving attributes for principal '{}' for SAML request from relying party '{}'", (Object)requestContext.getPrincipalName(), (Object)requestContext.getInboundMessageIssuer());
            Map principalAttributes = attributeAuthority.getAttributes(requestContext);
            requestContext.setAttributes(principalAttributes);
        }
        catch (AttributeRequestException e) {
            log.warn("Error resolving attributes for principal '{}'.  No name identifier or attribute statement will be included in response", (Object)requestContext.getPrincipalName());
        }
    }

    protected AttributeStatement buildAttributeStatement(BaseSAML1ProfileRequestContext<?, ?, ?> requestContext, String subjectConfMethod) throws ProfileException {
        if (requestContext.getAttributes() == null) {
            return null;
        }
        log.debug("Creating attribute statement about principal '{}'in response to SAML request from relying party '{}'", (Object)requestContext.getPrincipalName(), (Object)requestContext.getInboundMessageIssuer());
        AbstractSAML1ProfileConfiguration profileConfiguration = (AbstractSAML1ProfileConfiguration)requestContext.getProfileConfiguration();
        SAML1AttributeAuthority attributeAuthority = profileConfiguration.getAttributeAuthority();
        try {
            AttributeStatement statment = requestContext.getInboundSAMLMessage() instanceof AttributeQuery ? attributeAuthority.buildAttributeStatement((AttributeQuery)requestContext.getInboundSAMLMessage(), requestContext.getAttributes().values()) : attributeAuthority.buildAttributeStatement(null, requestContext.getAttributes().values());
            if (statment != null) {
                Subject statementSubject = this.buildSubject(requestContext, subjectConfMethod);
                statment.setSubject(statementSubject);
            }
            return statment;
        }
        catch (AttributeRequestException e) {
            requestContext.setFailureStatus(this.buildStatus(StatusCode.RESPONDER, null, "Error resolving attributes"));
            String msg = "Error encoding attributes for principal " + requestContext.getPrincipalName();
            log.error(msg, (Throwable)e);
            throw new ProfileException(msg, (Throwable)e);
        }
    }

    protected void resolvePrincipal(BaseSAML1ProfileRequestContext<?, ?, ?> requestContext) throws ProfileException {
        AbstractSAML1ProfileConfiguration profileConfiguration = (AbstractSAML1ProfileConfiguration)requestContext.getProfileConfiguration();
        SAML1AttributeAuthority attributeAuthority = profileConfiguration.getAttributeAuthority();
        log.debug("Resolving principal name for subject of SAML request from relying party '{}'", (Object)requestContext.getInboundMessageIssuer());
        try {
            String principal = attributeAuthority.getPrincipal(requestContext);
            requestContext.setPrincipalName(principal);
        }
        catch (AttributeRequestException e) {
            requestContext.setFailureStatus(this.buildStatus(StatusCode.RESPONDER, StatusCode.REQUEST_DENIED, "Error resolving principal"));
            String msg = "Error resolving principal name for SAML request from relying party '" + requestContext.getInboundMessageIssuer() + "'. Cause: " + e.getMessage();
            log.warn(msg);
            throw new ProfileException(msg, (Throwable)e);
        }
    }

    protected void signAssertion(BaseSAML1ProfileRequestContext<?, ?, ?> requestContext, Assertion assertion) throws ProfileException {
        log.debug("Determining if SAML assertion to relying party '{}' should be signed", (Object)requestContext.getInboundMessageIssuer());
        boolean signAssertion = this.isSignAssertion(requestContext);
        if (!signAssertion) {
            return;
        }
        AbstractSAML1ProfileConfiguration profileConfig = (AbstractSAML1ProfileConfiguration)requestContext.getProfileConfiguration();
        log.debug("Determining credential to use to sign assertion to relying party '{}'", (Object)requestContext.getInboundMessageIssuer());
        Credential signatureCredential = profileConfig.getSigningCredential();
        if (signatureCredential == null) {
            signatureCredential = requestContext.getRelyingPartyConfiguration().getDefaultSigningCredential();
        }
        if (signatureCredential == null) {
            String msg = "No signing credential is specified for relying party configuration " + requestContext.getRelyingPartyConfiguration().getProviderId();
            log.warn(msg);
            throw new ProfileException(msg);
        }
        log.debug("Signing assertion to relying party '{}'", (Object)requestContext.getInboundMessageIssuer());
        Signature signature = (Signature)this.signatureBuilder.buildObject(Signature.DEFAULT_ELEMENT_NAME);
        signature.setSigningCredential(signatureCredential);
        try {
            SecurityHelper.prepareSignatureParams((Signature)signature, (Credential)signatureCredential, null, null);
        }
        catch (SecurityException e) {
            String msg = "Error preparing signature for signing";
            log.error(msg);
            throw new ProfileException(msg, (Throwable)e);
        }
        assertion.setSignature(signature);
        Marshaller assertionMarshaller = Configuration.getMarshallerFactory().getMarshaller((XMLObject)assertion);
        try {
            assertionMarshaller.marshall((XMLObject)assertion);
            Signer.signObject((Signature)signature);
        }
        catch (MarshallingException e) {
            String errMsg = "Unable to marshall assertion for signing";
            log.error(errMsg, (Throwable)e);
            throw new ProfileException(errMsg, (Throwable)e);
        }
        catch (SignatureException e) {
            String msg = "Unable to sign assertion";
            log.error(msg, (Throwable)e);
            throw new ProfileException(msg, (Throwable)e);
        }
    }

    protected boolean isSignAssertion(BaseSAML1ProfileRequestContext<?, ?, ?> requestContext) throws ProfileException {
        SAMLMessageEncoder encoder = this.getOutboundMessageEncoder(requestContext);
        AbstractSAML1ProfileConfiguration profileConfig = (AbstractSAML1ProfileConfiguration)requestContext.getProfileConfiguration();
        try {
            SPSSODescriptor ssoDescriptor;
            boolean signAssertion = profileConfig.getSignAssertions() == CryptoOperationRequirementLevel.always || profileConfig.getSignAssertions() == CryptoOperationRequirementLevel.conditional && !encoder.providesMessageIntegrity(requestContext);
            log.debug("IdP relying party configuration '{}' indicates to sign assertions: {}", (Object)requestContext.getRelyingPartyConfiguration().getRelyingPartyId(), (Object)signAssertion);
            if (!signAssertion && requestContext.getPeerEntityRoleMetadata() instanceof SPSSODescriptor && (ssoDescriptor = (SPSSODescriptor)requestContext.getPeerEntityRoleMetadata()).getWantAssertionsSigned() != null) {
                signAssertion = ssoDescriptor.getWantAssertionsSigned();
                log.debug("Entity metadata for relying party '{} 'indicates to sign assertions: {}", (Object)requestContext.getInboundMessageIssuer(), (Object)signAssertion);
            }
            return signAssertion;
        }
        catch (MessageEncodingException e) {
            log.error("Unable to determine if outbound encoding '{}' provides message integrity protection", (Object)encoder.getBindingURI());
            throw new ProfileException("Unable to determine if outbound assertion should be signed");
        }
    }

    @Override
    protected void writeAuditLogEntry(BaseSAMLProfileRequestContext context) {
        Object idValue;
        SAML1AuditLogEntry auditLogEntry = new SAML1AuditLogEntry();
        auditLogEntry.setSAMLResponse((Response)context.getOutboundSAMLMessage());
        auditLogEntry.setMessageProfile(this.getProfileId());
        auditLogEntry.setPrincipalAuthenticationMethod(context.getPrincipalAuthenticationMethod());
        auditLogEntry.setPrincipalName(context.getPrincipalName());
        auditLogEntry.setAssertingPartyId(context.getLocalEntityId());
        auditLogEntry.setRelyingPartyId(context.getInboundMessageIssuer());
        auditLogEntry.setRequestBinding(context.getMessageDecoder().getBindingURI());
        auditLogEntry.setRequestId(context.getInboundSAMLMessageId());
        auditLogEntry.setResponseBinding(context.getMessageEncoder().getBindingURI());
        auditLogEntry.setResponseId(context.getOutboundSAMLMessageId());
        if (context.getReleasedAttributes() != null) {
            auditLogEntry.getReleasedAttributes().addAll(context.getReleasedAttributes());
        }
        if (context.getNameIdentifierAttribute() != null && (idValue = context.getNameIdentifierAttribute().getValues().iterator().next()) != null) {
            auditLogEntry.setNameIdValue(idValue.toString());
        }
        this.getAduitLog().info(auditLogEntry.toString());
    }

    protected class SAML1AuditLogEntry
    extends AuditLogEntry {
        private Response samlResponse;

        protected SAML1AuditLogEntry() {
        }

        public Response getSAMLResponse() {
            return this.samlResponse;
        }

        public void setSAMLResponse(Response response) {
            this.samlResponse = response;
        }

        public String toString() {
            StringBuilder entryString = new StringBuilder(super.toString());
            StringBuilder assertionIds = new StringBuilder();
            List assertions = this.samlResponse.getAssertions();
            if (assertions != null && !assertions.isEmpty()) {
                for (Assertion assertion : assertions) {
                    assertionIds.append(assertion.getID());
                    assertionIds.append(",");
                }
            }
            if (this.getNameIdValue() != null) {
                entryString.append(this.getNameIdValue());
            }
            entryString.append("|");
            entryString.append(assertionIds.toString());
            entryString.append("|");
            return entryString.toString();
        }
    }
}

