/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.metadata.validator;

import org.opensaml.saml2.metadata.KeyDescriptor;
import org.opensaml.xml.security.credential.UsageType;
import org.opensaml.xml.validation.ValidationException;
import org.opensaml.xml.validation.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyDescriptorSchemaValidator
implements Validator<KeyDescriptor> {
    public void validate(KeyDescriptor keyDescriptor) throws ValidationException {
        this.validateKeyInfo(keyDescriptor);
        this.validateUse(keyDescriptor);
    }

    protected void validateKeyInfo(KeyDescriptor keyDescriptor) throws ValidationException {
        if (keyDescriptor.getKeyInfo() == null) {
            throw new ValidationException("KeyInfo required");
        }
    }

    protected void validateUse(KeyDescriptor keyDescriptor) throws ValidationException {
        UsageType use = keyDescriptor.getUse();
        if (use == null) {
            return;
        }
        if (!(use.equals((Object)UsageType.SIGNING) || use.equals((Object)UsageType.ENCRYPTION) || use.equals((Object)UsageType.UNSPECIFIED))) {
            throw new ValidationException("Invalid value for use attribute: " + use.toString());
        }
    }
}

