/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.ssl;

import edu.vt.middleware.ldap.ssl.CredentialReader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCredentialReader<T>
implements CredentialReader<T> {
    public static final String CLASSPATH_PREFIX = "classpath:";
    public static final String FILE_PREFIX = "file:";
    private static final int CLASSPATH_START_INDEX = "classpath:".length();
    private static final int FILE_START_INDEX = "file:".length();
    protected final Log logger = LogFactory.getLog(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T read(String path, String ... params) throws IOException, GeneralSecurityException {
        InputStream is = null;
        if (path.startsWith(CLASSPATH_PREFIX)) {
            is = this.getClass().getResourceAsStream(path.substring(CLASSPATH_START_INDEX));
        } else if (path.startsWith(FILE_PREFIX)) {
            is = new FileInputStream(new File(path.substring(FILE_START_INDEX)));
        } else {
            throw new IllegalArgumentException("path must start with either classpath: or file:");
        }
        if (is != null) {
            try {
                T t = this.read(is, params);
                return t;
            }
            finally {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Successfully loaded " + path));
                }
                is.close();
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Failed to load " + path));
        }
        return null;
    }

    @Override
    public abstract T read(InputStream var1, String ... var2) throws IOException, GeneralSecurityException;

    protected InputStream getBufferedInputStream(InputStream is) {
        if (is.markSupported()) {
            return is;
        }
        return new BufferedInputStream(is);
    }
}

