/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.bean;

import edu.vt.middleware.ldap.bean.LdapBeanFactory;
import edu.vt.middleware.ldap.bean.UnorderedLdapBeanFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class LdapBeanProvider {
    public static final String BEAN_FACTORY = "edu.vt.middleware.ldap.beanFactory";
    private static final Log LOG = LogFactory.getLog(LdapBeanProvider.class);
    private static final LdapBeanProvider INSTANCE = new LdapBeanProvider();
    private static LdapBeanFactory beanFactory;

    private LdapBeanProvider() {
        block9: {
            String beanFactoryClass = System.getProperty(BEAN_FACTORY);
            if (beanFactoryClass != null) {
                try {
                    beanFactory = (LdapBeanFactory)Class.forName(beanFactoryClass).newInstance();
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("Set provider bean factory to " + beanFactoryClass));
                    }
                    break block9;
                }
                catch (ClassNotFoundException e) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)("Error instantiating " + beanFactoryClass), (Throwable)e);
                    }
                    break block9;
                }
                catch (InstantiationException e) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)("Error instantiating " + beanFactoryClass), (Throwable)e);
                    }
                    break block9;
                }
                catch (IllegalAccessException e) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)("Error instantiating " + beanFactoryClass), (Throwable)e);
                    }
                    break block9;
                }
            }
            beanFactory = new UnorderedLdapBeanFactory();
        }
    }

    public static LdapBeanProvider getInstance() {
        return INSTANCE;
    }

    public static LdapBeanFactory getLdapBeanFactory() {
        return beanFactory;
    }

    public static void setLdapBeanFactory(LdapBeanFactory lbf) {
        if (lbf != null) {
            beanFactory = lbf;
        }
    }
}

