/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.reference;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Encoder;
import org.owasp.esapi.ValidationErrorList;
import org.owasp.esapi.ValidationRule;
import org.owasp.esapi.Validator;
import org.owasp.esapi.errors.IntrusionException;
import org.owasp.esapi.errors.ValidationAvailabilityException;
import org.owasp.esapi.errors.ValidationException;
import org.owasp.esapi.reference.DefaultEncoder;
import org.owasp.esapi.reference.validation.CreditCardValidationRule;
import org.owasp.esapi.reference.validation.DateValidationRule;
import org.owasp.esapi.reference.validation.HTMLValidationRule;
import org.owasp.esapi.reference.validation.IntegerValidationRule;
import org.owasp.esapi.reference.validation.NumberValidationRule;
import org.owasp.esapi.reference.validation.StringValidationRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultValidator
implements Validator {
    private static volatile Validator instance = null;
    private Map<String, ValidationRule> rules = new HashMap<String, ValidationRule>();
    private Encoder encoder = null;
    private static Validator fileValidator = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Validator getInstance() {
        if (instance != null) return instance;
        Class<Validator> clazz = Validator.class;
        synchronized (Validator.class) {
            if (instance != null) return instance;
            instance = new DefaultValidator();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public DefaultValidator() {
        this.encoder = ESAPI.encoder();
    }

    public DefaultValidator(Encoder encoder) {
        this.encoder = encoder;
    }

    @Override
    public void addRule(ValidationRule rule) {
        this.rules.put(rule.getTypeName(), rule);
    }

    @Override
    public ValidationRule getRule(String name) {
        return this.rules.get(name);
    }

    @Override
    public boolean isValidInput(String context, String input, String type, int maxLength, boolean allowNull) throws IntrusionException {
        return this.isValidInput(context, input, type, maxLength, allowNull, true);
    }

    @Override
    public boolean isValidInput(String context, String input, String type, int maxLength, boolean allowNull, boolean canonicalize) throws IntrusionException {
        try {
            this.getValidInput(context, input, type, maxLength, allowNull, canonicalize);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String getValidInput(String context, String input, String type, int maxLength, boolean allowNull) throws ValidationException {
        return this.getValidInput(context, input, type, maxLength, allowNull, true);
    }

    @Override
    public String getValidInput(String context, String input, String type, int maxLength, boolean allowNull, boolean canonicalize) throws ValidationException {
        StringValidationRule rvr = new StringValidationRule(type, this.encoder);
        Pattern p = ESAPI.securityConfiguration().getValidationPattern(type);
        if (p != null) {
            rvr.addWhitelistPattern(p);
        } else {
            rvr.addWhitelistPattern(type);
        }
        rvr.setMaximumLength(maxLength);
        rvr.setAllowNull(allowNull);
        rvr.setValidateInputAndCanonical(canonicalize);
        return rvr.getValid(context, input);
    }

    @Override
    public String getValidInput(String context, String input, String type, int maxLength, boolean allowNull, ValidationErrorList errors) throws IntrusionException {
        return this.getValidInput(context, input, type, maxLength, allowNull, true, errors);
    }

    @Override
    public String getValidInput(String context, String input, String type, int maxLength, boolean allowNull, boolean canonicalize, ValidationErrorList errors) throws IntrusionException {
        try {
            return this.getValidInput(context, input, type, maxLength, allowNull, canonicalize);
        }
        catch (ValidationException e) {
            errors.addError(context, e);
            return "";
        }
    }

    @Override
    public boolean isValidDate(String context, String input, DateFormat format, boolean allowNull) throws IntrusionException {
        try {
            this.getValidDate(context, input, format, allowNull);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Date getValidDate(String context, String input, DateFormat format, boolean allowNull) throws ValidationException, IntrusionException {
        DateValidationRule dvr = new DateValidationRule("SimpleDate", this.encoder, format);
        dvr.setAllowNull(allowNull);
        return dvr.getValid(context, input);
    }

    @Override
    public Date getValidDate(String context, String input, DateFormat format, boolean allowNull, ValidationErrorList errors) throws IntrusionException {
        try {
            return this.getValidDate(context, input, format, allowNull);
        }
        catch (ValidationException e) {
            errors.addError(context, e);
            return null;
        }
    }

    @Override
    public boolean isValidSafeHTML(String context, String input, int maxLength, boolean allowNull) throws IntrusionException {
        try {
            this.getValidSafeHTML(context, input, maxLength, allowNull);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String getValidSafeHTML(String context, String input, int maxLength, boolean allowNull) throws ValidationException, IntrusionException {
        HTMLValidationRule hvr = new HTMLValidationRule("safehtml", this.encoder);
        hvr.setMaximumLength(maxLength);
        hvr.setAllowNull(allowNull);
        hvr.setValidateInputAndCanonical(false);
        return hvr.getValid(context, input);
    }

    @Override
    public String getValidSafeHTML(String context, String input, int maxLength, boolean allowNull, ValidationErrorList errors) throws IntrusionException {
        try {
            return this.getValidSafeHTML(context, input, maxLength, allowNull);
        }
        catch (ValidationException e) {
            errors.addError(context, e);
            return "";
        }
    }

    @Override
    public boolean isValidCreditCard(String context, String input, boolean allowNull) throws IntrusionException {
        try {
            this.getValidCreditCard(context, input, allowNull);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String getValidCreditCard(String context, String input, boolean allowNull) throws ValidationException, IntrusionException {
        CreditCardValidationRule ccvr = new CreditCardValidationRule("creditcard", this.encoder);
        ccvr.setAllowNull(allowNull);
        return ccvr.getValid(context, input);
    }

    @Override
    public String getValidCreditCard(String context, String input, boolean allowNull, ValidationErrorList errors) throws IntrusionException {
        try {
            return this.getValidCreditCard(context, input, allowNull);
        }
        catch (ValidationException e) {
            errors.addError(context, e);
            return "";
        }
    }

    @Override
    public boolean isValidDirectoryPath(String context, String input, File parent, boolean allowNull) throws IntrusionException {
        try {
            this.getValidDirectoryPath(context, input, parent, allowNull);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String getValidDirectoryPath(String context, String input, File parent, boolean allowNull) throws ValidationException, IntrusionException {
        try {
            if (this.isEmpty(input)) {
                if (allowNull) {
                    return null;
                }
                throw new ValidationException(context + ": Input directory path required", "Input directory path required: context=" + context + ", input=" + input, context);
            }
            File dir = new File(input);
            if (!dir.exists()) {
                throw new ValidationException(context + ": Invalid directory name", "Invalid directory, does not exist: context=" + context + ", input=" + input);
            }
            if (!dir.isDirectory()) {
                throw new ValidationException(context + ": Invalid directory name", "Invalid directory, not a directory: context=" + context + ", input=" + input);
            }
            if (!parent.exists()) {
                throw new ValidationException(context + ": Invalid directory name", "Invalid directory, specified parent does not exist: context=" + context + ", input=" + input + ", parent=" + parent);
            }
            if (!parent.isDirectory()) {
                throw new ValidationException(context + ": Invalid directory name", "Invalid directory, specified parent is not a directory: context=" + context + ", input=" + input + ", parent=" + parent);
            }
            if (!dir.getCanonicalPath().startsWith(parent.getCanonicalPath())) {
                throw new ValidationException(context + ": Invalid directory name", "Invalid directory, not inside specified parent: context=" + context + ", input=" + input + ", parent=" + parent);
            }
            String canonicalPath = dir.getCanonicalPath();
            String canonical = fileValidator.getValidInput(context, canonicalPath, "DirectoryName", 255, false);
            if (!canonical.equals(input)) {
                throw new ValidationException(context + ": Invalid directory name", "Invalid directory name does not match the canonical path: context=" + context + ", input=" + input + ", canonical=" + canonical, context);
            }
            return canonical;
        }
        catch (Exception e) {
            throw new ValidationException(context + ": Invalid directory name", "Failure to validate directory path: context=" + context + ", input=" + input, e, context);
        }
    }

    @Override
    public String getValidDirectoryPath(String context, String input, File parent, boolean allowNull, ValidationErrorList errors) throws IntrusionException {
        try {
            return this.getValidDirectoryPath(context, input, parent, allowNull);
        }
        catch (ValidationException e) {
            errors.addError(context, e);
            return "";
        }
    }

    @Override
    public boolean isValidFileName(String context, String input, boolean allowNull) throws IntrusionException {
        return this.isValidFileName(context, input, ESAPI.securityConfiguration().getAllowedFileExtensions(), allowNull);
    }

    @Override
    public boolean isValidFileName(String context, String input, List<String> allowedExtensions, boolean allowNull) throws IntrusionException {
        try {
            this.getValidFileName(context, input, allowedExtensions, allowNull);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String getValidFileName(String context, String input, List<String> allowedExtensions, boolean allowNull) throws ValidationException, IntrusionException {
        if (allowedExtensions == null || allowedExtensions.isEmpty()) {
            throw new ValidationException("Internal Error", "getValidFileName called with an empty or null list of allowed Extensions, therefore no files can be uploaded");
        }
        String canonical = "";
        try {
            if (this.isEmpty(input)) {
                if (allowNull) {
                    return null;
                }
                throw new ValidationException(context + ": Input file name required", "Input required: context=" + context + ", input=" + input, context);
            }
            canonical = new File(input).getCanonicalFile().getName();
            this.getValidInput(context, input, "FileName", 255, true);
            File f = new File(canonical);
            String c = f.getCanonicalPath();
            String cpath = c.substring(c.lastIndexOf(File.separator) + 1);
            if (!input.equals(cpath)) {
                throw new ValidationException(context + ": Invalid file name", "Invalid directory name does not match the canonical path: context=" + context + ", input=" + input + ", canonical=" + canonical, context);
            }
        }
        catch (IOException e) {
            throw new ValidationException(context + ": Invalid file name", "Invalid file name does not exist: context=" + context + ", canonical=" + canonical, e, context);
        }
        for (String ext : allowedExtensions) {
            if (!input.toLowerCase().endsWith(ext.toLowerCase())) continue;
            return canonical;
        }
        throw new ValidationException(context + ": Invalid file name does not have valid extension ( " + allowedExtensions + ")", "Invalid file name does not have valid extension ( " + allowedExtensions + "): context=" + context + ", input=" + input, context);
    }

    @Override
    public String getValidFileName(String context, String input, List<String> allowedParameters, boolean allowNull, ValidationErrorList errors) throws IntrusionException {
        try {
            return this.getValidFileName(context, input, allowedParameters, allowNull);
        }
        catch (ValidationException e) {
            errors.addError(context, e);
            return "";
        }
    }

    @Override
    public boolean isValidNumber(String context, String input, long minValue, long maxValue, boolean allowNull) throws IntrusionException {
        try {
            this.getValidNumber(context, input, minValue, maxValue, allowNull);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Double getValidNumber(String context, String input, long minValue, long maxValue, boolean allowNull) throws ValidationException, IntrusionException {
        Double minDoubleValue = new Double(minValue);
        Double maxDoubleValue = new Double(maxValue);
        return this.getValidDouble(context, input, minDoubleValue, maxDoubleValue, allowNull);
    }

    @Override
    public Double getValidNumber(String context, String input, long minValue, long maxValue, boolean allowNull, ValidationErrorList errors) throws IntrusionException {
        try {
            return this.getValidNumber(context, input, minValue, maxValue, allowNull);
        }
        catch (ValidationException e) {
            errors.addError(context, e);
            return null;
        }
    }

    @Override
    public boolean isValidDouble(String context, String input, double minValue, double maxValue, boolean allowNull) throws IntrusionException {
        try {
            this.getValidDouble(context, input, minValue, maxValue, allowNull);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Double getValidDouble(String context, String input, double minValue, double maxValue, boolean allowNull) throws ValidationException, IntrusionException {
        NumberValidationRule nvr = new NumberValidationRule("number", this.encoder, minValue, maxValue);
        nvr.setAllowNull(allowNull);
        return nvr.getValid(context, input);
    }

    @Override
    public Double getValidDouble(String context, String input, double minValue, double maxValue, boolean allowNull, ValidationErrorList errors) throws IntrusionException {
        try {
            return this.getValidDouble(context, input, minValue, maxValue, allowNull);
        }
        catch (ValidationException e) {
            errors.addError(context, e);
            return new Double(Double.NaN);
        }
    }

    @Override
    public boolean isValidInteger(String context, String input, int minValue, int maxValue, boolean allowNull) throws IntrusionException {
        try {
            this.getValidInteger(context, input, minValue, maxValue, allowNull);
            return true;
        }
        catch (ValidationException e) {
            return false;
        }
    }

    @Override
    public Integer getValidInteger(String context, String input, int minValue, int maxValue, boolean allowNull) throws ValidationException, IntrusionException {
        IntegerValidationRule ivr = new IntegerValidationRule("number", this.encoder, minValue, maxValue);
        ivr.setAllowNull(allowNull);
        return ivr.getValid(context, input);
    }

    @Override
    public Integer getValidInteger(String context, String input, int minValue, int maxValue, boolean allowNull, ValidationErrorList errors) throws IntrusionException {
        try {
            return this.getValidInteger(context, input, minValue, maxValue, allowNull);
        }
        catch (ValidationException e) {
            errors.addError(context, e);
            return null;
        }
    }

    @Override
    public boolean isValidFileContent(String context, byte[] input, int maxBytes, boolean allowNull) throws IntrusionException {
        try {
            this.getValidFileContent(context, input, maxBytes, allowNull);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public byte[] getValidFileContent(String context, byte[] input, int maxBytes, boolean allowNull) throws ValidationException, IntrusionException {
        if (this.isEmpty(input)) {
            if (allowNull) {
                return null;
            }
            throw new ValidationException(context + ": Input required", "Input required: context=" + context + ", input=" + input, context);
        }
        long esapiMaxBytes = ESAPI.securityConfiguration().getAllowedFileUploadSize();
        if ((long)input.length > esapiMaxBytes) {
            throw new ValidationException(context + ": Invalid file content can not exceed " + esapiMaxBytes + " bytes", "Exceeded ESAPI max length", context);
        }
        if (input.length > maxBytes) {
            throw new ValidationException(context + ": Invalid file content can not exceed " + maxBytes + " bytes", "Exceeded maxBytes ( " + input.length + ")", context);
        }
        return input;
    }

    @Override
    public byte[] getValidFileContent(String context, byte[] input, int maxBytes, boolean allowNull, ValidationErrorList errors) throws IntrusionException {
        try {
            return this.getValidFileContent(context, input, maxBytes, allowNull);
        }
        catch (ValidationException e) {
            errors.addError(context, e);
            return new byte[0];
        }
    }

    @Override
    public boolean isValidFileUpload(String context, String directorypath, String filename, File parent, byte[] content, int maxBytes, boolean allowNull) throws IntrusionException {
        return this.isValidFileName(context, filename, allowNull) && this.isValidDirectoryPath(context, directorypath, parent, allowNull) && this.isValidFileContent(context, content, maxBytes, allowNull);
    }

    @Override
    public void assertValidFileUpload(String context, String directorypath, String filename, File parent, byte[] content, int maxBytes, List<String> allowedExtensions, boolean allowNull) throws ValidationException, IntrusionException {
        this.getValidFileName(context, filename, allowedExtensions, allowNull);
        this.getValidDirectoryPath(context, directorypath, parent, allowNull);
        this.getValidFileContent(context, content, maxBytes, allowNull);
    }

    @Override
    public void assertValidFileUpload(String context, String filepath, String filename, File parent, byte[] content, int maxBytes, List<String> allowedExtensions, boolean allowNull, ValidationErrorList errors) throws IntrusionException {
        try {
            this.assertValidFileUpload(context, filepath, filename, parent, content, maxBytes, allowedExtensions, allowNull);
        }
        catch (ValidationException e) {
            errors.addError(context, e);
        }
    }

    @Override
    public boolean isValidListItem(String context, String input, List<String> list) {
        try {
            this.getValidListItem(context, input, list);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String getValidListItem(String context, String input, List<String> list) throws ValidationException, IntrusionException {
        if (list.contains(input)) {
            return input;
        }
        throw new ValidationException(context + ": Invalid list item", "Invalid list item: context=" + context + ", input=" + input, context);
    }

    @Override
    public String getValidListItem(String context, String input, List<String> list, ValidationErrorList errors) throws IntrusionException {
        try {
            return this.getValidListItem(context, input, list);
        }
        catch (ValidationException e) {
            errors.addError(context, e);
            return input;
        }
    }

    @Override
    public boolean isValidHTTPRequestParameterSet(String context, HttpServletRequest request, Set<String> requiredNames, Set<String> optionalNames) {
        try {
            this.assertValidHTTPRequestParameterSet(context, request, requiredNames, optionalNames);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void assertValidHTTPRequestParameterSet(String context, HttpServletRequest request, Set<String> required, Set<String> optional) throws ValidationException, IntrusionException {
        Set actualNames = request.getParameterMap().keySet();
        HashSet<String> missing = new HashSet<String>(required);
        missing.removeAll(actualNames);
        if (missing.size() > 0) {
            throw new ValidationException(context + ": Invalid HTTP request missing parameters", "Invalid HTTP request missing parameters " + missing + ": context=" + context, context);
        }
        HashSet extra = new HashSet(actualNames);
        extra.removeAll(required);
        extra.removeAll(optional);
        if (extra.size() > 0) {
            throw new ValidationException(context + ": Invalid HTTP request extra parameters " + extra, "Invalid HTTP request extra parameters " + extra + ": context=" + context, context);
        }
    }

    @Override
    public void assertValidHTTPRequestParameterSet(String context, HttpServletRequest request, Set<String> required, Set<String> optional, ValidationErrorList errors) throws IntrusionException {
        try {
            this.assertValidHTTPRequestParameterSet(context, request, required, optional);
        }
        catch (ValidationException e) {
            errors.addError(context, e);
        }
    }

    @Override
    public boolean isValidPrintable(String context, char[] input, int maxLength, boolean allowNull) throws IntrusionException {
        try {
            this.getValidPrintable(context, input, maxLength, allowNull);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public char[] getValidPrintable(String context, char[] input, int maxLength, boolean allowNull) throws ValidationException, IntrusionException {
        if (this.isEmpty(input)) {
            if (allowNull) {
                return null;
            }
            throw new ValidationException(context + ": Input bytes required", "Input bytes required: HTTP request is null", context);
        }
        if (input.length > maxLength) {
            throw new ValidationException(context + ": Input bytes can not exceed " + maxLength + " bytes", "Input exceeds maximum allowed length of " + maxLength + " by " + (input.length - maxLength) + " bytes: context=" + context + ", input=" + new String(input), context);
        }
        for (int i = 0; i < input.length; ++i) {
            if (input[i] > ' ' && input[i] < '~') continue;
            throw new ValidationException(context + ": Invalid input bytes: context=" + context, "Invalid non-ASCII input bytes, context=" + context + ", input=" + new String(input), context);
        }
        return input;
    }

    @Override
    public char[] getValidPrintable(String context, char[] input, int maxLength, boolean allowNull, ValidationErrorList errors) throws IntrusionException {
        try {
            return this.getValidPrintable(context, input, maxLength, allowNull);
        }
        catch (ValidationException e) {
            errors.addError(context, e);
            return input;
        }
    }

    @Override
    public boolean isValidPrintable(String context, String input, int maxLength, boolean allowNull) throws IntrusionException {
        try {
            this.getValidPrintable(context, input, maxLength, allowNull);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String getValidPrintable(String context, String input, int maxLength, boolean allowNull) throws ValidationException, IntrusionException {
        try {
            String canonical = this.encoder.canonicalize(input);
            return new String(this.getValidPrintable(context, canonical.toCharArray(), maxLength, allowNull));
        }
        catch (Exception e) {
            throw new ValidationException(context + ": Invalid printable input", "Invalid encoding of printable input, context=" + context + ", input=" + input, e, context);
        }
    }

    @Override
    public String getValidPrintable(String context, String input, int maxLength, boolean allowNull, ValidationErrorList errors) throws IntrusionException {
        try {
            return this.getValidPrintable(context, input, maxLength, allowNull);
        }
        catch (ValidationException e) {
            errors.addError(context, e);
            return input;
        }
    }

    @Override
    public boolean isValidRedirectLocation(String context, String input, boolean allowNull) throws IntrusionException {
        return ESAPI.validator().isValidInput(context, input, "Redirect", 512, allowNull);
    }

    @Override
    public String getValidRedirectLocation(String context, String input, boolean allowNull) throws ValidationException, IntrusionException {
        return ESAPI.validator().getValidInput(context, input, "Redirect", 512, allowNull);
    }

    @Override
    public String getValidRedirectLocation(String context, String input, boolean allowNull, ValidationErrorList errors) throws IntrusionException {
        try {
            return this.getValidRedirectLocation(context, input, allowNull);
        }
        catch (ValidationException e) {
            errors.addError(context, e);
            return input;
        }
    }

    @Override
    public String safeReadLine(InputStream in, int max) throws ValidationException {
        if (max <= 0) {
            throw new ValidationAvailabilityException("Invalid input", "Invalid readline. Must read a positive number of bytes from the stream");
        }
        StringBuilder sb = new StringBuilder();
        int count = 0;
        try {
            while (true) {
                int c;
                if ((c = in.read()) == -1) {
                    if (sb.length() != 0) break;
                    return null;
                }
                if (c == 10 || c == 13) break;
                if (++count > max) {
                    throw new ValidationAvailabilityException("Invalid input", "Invalid readLine. Read more than maximum characters allowed (" + max + ")");
                }
                sb.append((char)c);
            }
            return sb.toString();
        }
        catch (IOException e) {
            throw new ValidationAvailabilityException("Invalid input", "Invalid readLine. Problem reading from input stream", e);
        }
    }

    private final boolean isEmpty(String input) {
        return input == null || input.trim().length() == 0;
    }

    private final boolean isEmpty(byte[] input) {
        return input == null || input.length == 0;
    }

    private final boolean isEmpty(char[] input) {
        return input == null || input.length == 0;
    }

    static {
        ArrayList<String> list = new ArrayList<String>();
        list.add("HTMLEntityCodec");
        list.add("PercentCodec");
        DefaultEncoder fileEncoder = new DefaultEncoder(list);
        fileValidator = new DefaultValidator(fileEncoder);
    }
}

