/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.reference;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Encoder;
import org.owasp.esapi.Logger;
import org.owasp.esapi.codecs.Base64;
import org.owasp.esapi.codecs.CSSCodec;
import org.owasp.esapi.codecs.Codec;
import org.owasp.esapi.codecs.HTMLEntityCodec;
import org.owasp.esapi.codecs.JavaScriptCodec;
import org.owasp.esapi.codecs.PercentCodec;
import org.owasp.esapi.codecs.VBScriptCodec;
import org.owasp.esapi.codecs.XMLEntityCodec;
import org.owasp.esapi.errors.EncodingException;
import org.owasp.esapi.errors.IntrusionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultEncoder
implements Encoder {
    private static volatile Encoder singletonInstance;
    private List codecs = new ArrayList();
    private HTMLEntityCodec htmlCodec = new HTMLEntityCodec();
    private XMLEntityCodec xmlCodec = new XMLEntityCodec();
    private PercentCodec percentCodec = new PercentCodec();
    private JavaScriptCodec javaScriptCodec = new JavaScriptCodec();
    private VBScriptCodec vbScriptCodec = new VBScriptCodec();
    private CSSCodec cssCodec = new CSSCodec();
    private final Logger logger = ESAPI.getLogger("Encoder");
    private static final char[] IMMUNE_HTML;
    private static final char[] IMMUNE_HTMLATTR;
    private static final char[] IMMUNE_CSS;
    private static final char[] IMMUNE_JAVASCRIPT;
    private static final char[] IMMUNE_VBSCRIPT;
    private static final char[] IMMUNE_XML;
    private static final char[] IMMUNE_SQL;
    private static final char[] IMMUNE_OS;
    private static final char[] IMMUNE_XMLATTR;
    private static final char[] IMMUNE_XPATH;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Encoder getInstance() {
        if (singletonInstance != null) return singletonInstance;
        Class<DefaultEncoder> clazz = DefaultEncoder.class;
        synchronized (DefaultEncoder.class) {
            if (singletonInstance != null) return singletonInstance;
            singletonInstance = new DefaultEncoder();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singletonInstance;
        }
    }

    private DefaultEncoder() {
        this.codecs.add(this.htmlCodec);
        this.codecs.add(this.percentCodec);
        this.codecs.add(this.javaScriptCodec);
    }

    public DefaultEncoder(List<String> codecNames) {
        for (String clazz : codecNames) {
            try {
                if (clazz.indexOf(46) == -1) {
                    clazz = "org.owasp.esapi.codecs." + clazz;
                }
                this.codecs.add(Class.forName(clazz).newInstance());
            }
            catch (Exception e) {
                this.logger.warning(Logger.EVENT_FAILURE, "Codec " + clazz + " listed in ESAPI.properties not on classpath");
            }
        }
    }

    @Override
    public String canonicalize(String input) {
        if (input == null) {
            return null;
        }
        return this.canonicalize(input, !ESAPI.securityConfiguration().getDisableIntrusionDetection());
    }

    @Override
    public String canonicalize(String input, boolean strict) {
        if (input == null) {
            return null;
        }
        String working = input;
        Codec codecFound = null;
        int mixedCount = 1;
        int foundCount = 0;
        boolean clean = false;
        while (!clean) {
            clean = true;
            Iterator i = this.codecs.iterator();
            while (i.hasNext()) {
                String old = working;
                Codec codec = (Codec)i.next();
                if (old.equals(working = codec.decode(working))) continue;
                if (codecFound != null && codecFound != codec) {
                    ++mixedCount;
                }
                codecFound = codec;
                if (clean) {
                    ++foundCount;
                }
                clean = false;
            }
        }
        if (foundCount >= 2 && mixedCount > 1) {
            if (strict) {
                throw new IntrusionException("Input validation failure", "Multiple (" + foundCount + "x) and mixed encoding (" + mixedCount + "x) detected in " + input);
            }
            this.logger.warning(Logger.SECURITY_FAILURE, "Multiple (" + foundCount + "x) and mixed encoding (" + mixedCount + "x) detected in " + input);
        } else if (foundCount >= 2) {
            if (strict) {
                throw new IntrusionException("Input validation failure", "Multiple (" + foundCount + "x) encoding detected in " + input);
            }
            this.logger.warning(Logger.SECURITY_FAILURE, "Multiple (" + foundCount + "x) encoding detected in " + input);
        } else if (mixedCount > 1) {
            if (strict) {
                throw new IntrusionException("Input validation failure", "Mixed encoding (" + mixedCount + "x) detected in " + input);
            }
            this.logger.warning(Logger.SECURITY_FAILURE, "Mixed encoding (" + mixedCount + "x) detected in " + input);
        }
        return working;
    }

    @Override
    public String encodeForHTML(String input) {
        if (input == null) {
            return null;
        }
        return this.htmlCodec.encode(IMMUNE_HTML, input);
    }

    @Override
    public String decodeForHTML(String input) {
        if (input == null) {
            return null;
        }
        return this.htmlCodec.decode(input);
    }

    @Override
    public String encodeForHTMLAttribute(String input) {
        if (input == null) {
            return null;
        }
        return this.htmlCodec.encode(IMMUNE_HTMLATTR, input);
    }

    @Override
    public String encodeForCSS(String input) {
        if (input == null) {
            return null;
        }
        return this.cssCodec.encode(IMMUNE_CSS, input);
    }

    @Override
    public String encodeForJavaScript(String input) {
        if (input == null) {
            return null;
        }
        return this.javaScriptCodec.encode(IMMUNE_JAVASCRIPT, input);
    }

    @Override
    public String encodeForVBScript(String input) {
        if (input == null) {
            return null;
        }
        return this.vbScriptCodec.encode(IMMUNE_VBSCRIPT, input);
    }

    @Override
    public String encodeForSQL(Codec codec, String input) {
        if (input == null) {
            return null;
        }
        return codec.encode(IMMUNE_SQL, input);
    }

    @Override
    public String encodeForOS(Codec codec, String input) {
        if (input == null) {
            return null;
        }
        return codec.encode(IMMUNE_OS, input);
    }

    @Override
    public String encodeForLDAP(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        block7: for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            switch (c) {
                case '\\': {
                    sb.append("\\5c");
                    continue block7;
                }
                case '*': {
                    sb.append("\\2a");
                    continue block7;
                }
                case '(': {
                    sb.append("\\28");
                    continue block7;
                }
                case ')': {
                    sb.append("\\29");
                    continue block7;
                }
                case '\u0000': {
                    sb.append("\\00");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    @Override
    public String encodeForDN(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (input.length() > 0 && (input.charAt(0) == ' ' || input.charAt(0) == '#')) {
            sb.append('\\');
        }
        block9: for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            switch (c) {
                case '\\': {
                    sb.append("\\\\");
                    continue block9;
                }
                case ',': {
                    sb.append("\\,");
                    continue block9;
                }
                case '+': {
                    sb.append("\\+");
                    continue block9;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block9;
                }
                case '<': {
                    sb.append("\\<");
                    continue block9;
                }
                case '>': {
                    sb.append("\\>");
                    continue block9;
                }
                case ';': {
                    sb.append("\\;");
                    continue block9;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        if (input.length() > 1 && input.charAt(input.length() - 1) == ' ') {
            sb.insert(sb.length() - 1, '\\');
        }
        return sb.toString();
    }

    @Override
    public String encodeForXPath(String input) {
        if (input == null) {
            return null;
        }
        return this.htmlCodec.encode(IMMUNE_XPATH, input);
    }

    @Override
    public String encodeForXML(String input) {
        if (input == null) {
            return null;
        }
        return this.xmlCodec.encode(IMMUNE_XML, input);
    }

    @Override
    public String encodeForXMLAttribute(String input) {
        if (input == null) {
            return null;
        }
        return this.xmlCodec.encode(IMMUNE_XMLATTR, input);
    }

    @Override
    public String encodeForURL(String input) throws EncodingException {
        if (input == null) {
            return null;
        }
        try {
            return URLEncoder.encode(input, ESAPI.securityConfiguration().getCharacterEncoding());
        }
        catch (UnsupportedEncodingException ex) {
            throw new EncodingException("Encoding failure", "Character encoding not supported", ex);
        }
        catch (Exception e) {
            throw new EncodingException("Encoding failure", "Problem URL encoding input", e);
        }
    }

    @Override
    public String decodeFromURL(String input) throws EncodingException {
        if (input == null) {
            return null;
        }
        String canonical = this.canonicalize(input);
        try {
            return URLDecoder.decode(canonical, ESAPI.securityConfiguration().getCharacterEncoding());
        }
        catch (UnsupportedEncodingException ex) {
            throw new EncodingException("Decoding failed", "Character encoding not supported", ex);
        }
        catch (Exception e) {
            throw new EncodingException("Decoding failed", "Problem URL decoding input", e);
        }
    }

    @Override
    public String encodeForBase64(byte[] input, boolean wrap) {
        if (input == null) {
            return null;
        }
        int options = 0;
        if (!wrap) {
            options |= 8;
        }
        return Base64.encodeBytes(input, options);
    }

    @Override
    public byte[] decodeFromBase64(String input) throws IOException {
        if (input == null) {
            return null;
        }
        return Base64.decode(input);
    }

    static {
        IMMUNE_HTML = new char[]{',', '.', '-', '_', ' '};
        IMMUNE_HTMLATTR = new char[]{',', '.', '-', '_'};
        IMMUNE_CSS = new char[0];
        IMMUNE_JAVASCRIPT = new char[]{',', '.', '_'};
        IMMUNE_VBSCRIPT = new char[]{',', '.', '_'};
        IMMUNE_XML = new char[]{',', '.', '-', '_', ' '};
        IMMUNE_SQL = new char[]{' '};
        IMMUNE_OS = new char[]{'-'};
        IMMUNE_XMLATTR = new char[]{',', '.', '-', '_'};
        IMMUNE_XPATH = new char[]{',', '.', '-', '_', ' '};
    }
}

