/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.crypto;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;
import org.owasp.esapi.crypto.CipherSpec;
import org.owasp.esapi.crypto.CipherText;
import org.owasp.esapi.crypto.CryptoHelper;
import org.owasp.esapi.errors.EncryptionException;
import org.owasp.esapi.util.ByteConversionUtil;

public class CipherTextSerializer {
    private static final long serialVersionUID = 20100122L;
    private static final Logger logger = ESAPI.getLogger("CipherTextSerializer");
    private CipherText cipherText_ = null;

    public CipherTextSerializer(CipherText cipherTextObj) {
        assert (cipherTextObj != null) : "CipherText object must not be null.";
        assert (20100122L == CipherText.getSerialVersionUID()) : "Version of CipherText and CipherTextSerializer not compatible.";
        this.cipherText_ = cipherTextObj;
    }

    public CipherTextSerializer(byte[] cipherTextSerializedBytes) throws EncryptionException {
        assert (20100122L == CipherText.getSerialVersionUID()) : "Version of CipherText and CipherTextSerializer not compatible.";
        this.cipherText_ = this.convertToCipherText(cipherTextSerializedBytes);
    }

    public byte[] asSerializedByteArray() {
        CipherTextSerializer cipherTextSerializer = this;
        long vers = cipherTextSerializer.cipherText_.getSerialVersionUID();
        long timestamp = this.cipherText_.getEncryptionTimestamp();
        String cipherXform = this.cipherText_.getCipherTransformation();
        assert (this.cipherText_.getKeySize() < Short.MAX_VALUE) : "Key size too large. Max is 32767";
        short keySize = (short)this.cipherText_.getKeySize();
        assert (this.cipherText_.getBlockSize() < Short.MAX_VALUE) : "Block size too large. Max is 32767";
        short blockSize = (short)this.cipherText_.getBlockSize();
        byte[] iv = this.cipherText_.getIV();
        assert (iv.length < Short.MAX_VALUE) : "IV size too large. Max is 32767";
        short ivLen = (short)iv.length;
        byte[] rawCiphertext = this.cipherText_.getRawCipherText();
        int ciphertextLen = rawCiphertext.length;
        assert (ciphertextLen >= 1) : "Raw ciphertext length must be >= 1 byte.";
        byte[] mac = this.cipherText_.getSeparateMAC();
        assert (mac.length < Short.MAX_VALUE) : "MAC length too large. Max is 32767";
        short macLen = (short)mac.length;
        byte[] serializedObj = this.computeSerialization(vers, timestamp, cipherXform, keySize, blockSize, ivLen, iv, ciphertextLen, rawCiphertext, macLen, mac);
        return serializedObj;
    }

    public CipherText asCipherText() {
        return this.cipherText_;
    }

    private byte[] computeSerialization(long vers, long timestamp, String cipherXform, short keySize, short blockSize, short ivLen, byte[] iv, int ciphertextLen, byte[] rawCiphertext, short macLen, byte[] mac) {
        this.debug("computeSerialization: vers = " + vers);
        this.debug("computeSerialization: timestamp = " + new Date(timestamp));
        this.debug("computeSerialization: cipherXform = " + cipherXform);
        this.debug("computeSerialization: keySize = " + keySize);
        this.debug("computeSerialization: blockSize = " + blockSize);
        this.debug("computeSerialization: ivLen = " + ivLen);
        this.debug("computeSerialization: ciphertextLen = " + ciphertextLen);
        this.debug("computeSerialization: macLen = " + macLen);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.writeLong(baos, vers);
        this.writeLong(baos, timestamp);
        String[] parts = cipherXform.split("/");
        assert (parts.length == 3) : "Malformed cipher transformation";
        this.writeString(baos, cipherXform);
        this.writeShort(baos, keySize);
        this.writeShort(baos, blockSize);
        this.writeShort(baos, ivLen);
        if (ivLen > 0) {
            baos.write(iv, 0, iv.length);
        }
        this.writeInt(baos, ciphertextLen);
        baos.write(rawCiphertext, 0, rawCiphertext.length);
        this.writeShort(baos, macLen);
        if (macLen > 0) {
            baos.write(mac, 0, mac.length);
        }
        return baos.toByteArray();
    }

    private void writeString(ByteArrayOutputStream baos, String str) {
        try {
            assert (str != null && str.length() > 0);
            byte[] bytes = str.getBytes("UTF8");
            assert (bytes.length < Short.MAX_VALUE) : "writeString: String exceeds max length";
            this.writeShort(baos, (short)bytes.length);
            baos.write(bytes, 0, bytes.length);
        }
        catch (UnsupportedEncodingException e) {
            logger.error(Logger.EVENT_FAILURE, "Ignoring caught UnsupportedEncodingException converting string to UTF8 encoding. Results suspect. Corrupt rt.jar????");
        }
    }

    private String readString(ByteArrayInputStream bais, short sz) throws NullPointerException, IOException {
        byte[] bytes = new byte[sz];
        int ret = bais.read(bytes, 0, sz);
        assert (ret == sz) : "readString: Failed to read " + sz + " bytes.";
        return new String(bytes, "UTF8");
    }

    private void writeShort(ByteArrayOutputStream baos, short s) {
        byte[] shortAsByteArray = ByteConversionUtil.fromShort(s);
        assert (shortAsByteArray.length == 2);
        baos.write(shortAsByteArray, 0, 2);
    }

    private short readShort(ByteArrayInputStream bais) throws NullPointerException, IndexOutOfBoundsException {
        byte[] shortAsByteArray = new byte[2];
        int ret = bais.read(shortAsByteArray, 0, 2);
        assert (ret == 2) : "readShort: Failed to read 2 bytes.";
        return ByteConversionUtil.toShort(shortAsByteArray);
    }

    private void writeInt(ByteArrayOutputStream baos, int i) {
        byte[] intAsByteArray = ByteConversionUtil.fromInt(i);
        baos.write(intAsByteArray, 0, 4);
    }

    private int readInt(ByteArrayInputStream bais) throws NullPointerException, IndexOutOfBoundsException {
        byte[] intAsByteArray = new byte[4];
        int ret = bais.read(intAsByteArray, 0, 4);
        assert (ret == 4) : "readInt: Failed to read 4 bytes.";
        return ByteConversionUtil.toInt(intAsByteArray);
    }

    private void writeLong(ByteArrayOutputStream baos, long l) {
        byte[] longAsByteArray = ByteConversionUtil.fromLong(l);
        assert (longAsByteArray.length == 8);
        baos.write(longAsByteArray, 0, 8);
    }

    private long readLong(ByteArrayInputStream bais) throws NullPointerException, IndexOutOfBoundsException {
        byte[] longAsByteArray = new byte[8];
        int ret = bais.read(longAsByteArray, 0, 8);
        assert (ret == 8) : "readLong: Failed to read 8 bytes.";
        return ByteConversionUtil.toLong(longAsByteArray);
    }

    private CipherText convertToCipherText(byte[] cipherTextSerializedBytes) throws EncryptionException {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(cipherTextSerializedBytes);
            long vers = this.readLong(bais);
            this.debug("convertToCipherText: vers = " + vers);
            if (vers != CipherText.getSerialVersionUID()) {
                throw new InvalidClassException("This serialized byte stream not compatible with loaded CipherText class. Version read = " + vers + "; version from loaded CipherText class = " + CipherText.getSerialVersionUID());
            }
            long timestamp = this.readLong(bais);
            this.debug("convertToCipherText: timestamp = " + new Date(timestamp));
            short strSize = this.readShort(bais);
            this.debug("convertToCipherText: length of cipherXform = " + strSize);
            String cipherXform = this.readString(bais, strSize);
            this.debug("convertToCipherText: cipherXform = " + cipherXform);
            String[] parts = cipherXform.split("/");
            assert (parts.length == 3) : "Malformed cipher transformation";
            String cipherMode = parts[1];
            if (!CryptoHelper.isAllowedCipherMode(cipherMode)) {
                String msg = "Cipher mode " + cipherMode + " is not an allowed cipher mode";
                throw new EncryptionException(msg, msg);
            }
            short keySize = this.readShort(bais);
            this.debug("convertToCipherText: keySize = " + keySize);
            short blockSize = this.readShort(bais);
            this.debug("convertToCipherText: blockSize = " + blockSize);
            short ivLen = this.readShort(bais);
            this.debug("convertToCipherText: ivLen = " + ivLen);
            byte[] iv = null;
            if (ivLen > 0) {
                iv = new byte[ivLen];
                bais.read(iv, 0, iv.length);
            }
            int ciphertextLen = this.readInt(bais);
            this.debug("convertToCipherText: ciphertextLen = " + ciphertextLen);
            assert (ciphertextLen > 0) : "convertToCipherText: Invalid cipher text length";
            byte[] rawCiphertext = new byte[ciphertextLen];
            bais.read(rawCiphertext, 0, rawCiphertext.length);
            short macLen = this.readShort(bais);
            this.debug("convertToCipherText: macLen = " + macLen);
            byte[] mac = null;
            if (macLen > 0) {
                mac = new byte[macLen];
                bais.read(mac, 0, mac.length);
            }
            CipherSpec cipherSpec = new CipherSpec(cipherXform, (int)keySize);
            cipherSpec.setBlockSize(blockSize);
            cipherSpec.setIV(iv);
            this.debug("convertToCipherText: CipherSpec: " + cipherSpec);
            CipherText ct = new CipherText(cipherSpec);
            assert (ivLen > 0 && ct.requiresIV()) : "convertToCipherText: Mismatch between IV length and cipher mode.";
            ct.setCiphertext(rawCiphertext);
            ct.setEncryptionTimestamp(timestamp);
            if (macLen > 0) {
                ct.storeSeparateMAC(mac);
            }
            return ct;
        }
        catch (EncryptionException ex) {
            throw new EncryptionException("Cannot deserialize byte array into CipherText object", "Cannot deserialize byte array into CipherText object", ex);
        }
        catch (IOException e) {
            throw new EncryptionException("Cannot deserialize byte array into CipherText object", "Cannot deserialize byte array into CipherText object", e);
        }
    }

    private void debug(String msg) {
        if (logger.isDebugEnabled()) {
            logger.debug(Logger.EVENT_SUCCESS, msg);
        }
    }
}

