/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.metadata.provider;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Timer;
import java.util.TimerTask;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.ISOChronology;
import org.opensaml.saml2.common.SAML2Helper;
import org.opensaml.saml2.metadata.provider.AbstractObservableMetadataProvider;
import org.opensaml.saml2.metadata.provider.FilterException;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.UnmarshallingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public abstract class AbstractReloadingMetadataProvider
extends AbstractObservableMetadataProvider {
    private final Logger log = LoggerFactory.getLogger(AbstractReloadingMetadataProvider.class);
    private Timer taskTimer;
    private float refreshDelayFactor = 0.75f;
    private long maxRefreshDelay = 14400000L;
    private int minRefreshDelay = 300000;
    private DateTime expirationTime;
    private DateTime lastUpdate;
    private DateTime lastRefresh;
    private DateTime nextRefresh;
    private XMLObject cachedMetadata;

    protected AbstractReloadingMetadataProvider() {
        this.taskTimer = new Timer(true);
    }

    protected AbstractReloadingMetadataProvider(Timer backgroundTaskTimer) {
        if (backgroundTaskTimer == null) {
            throw new IllegalArgumentException("Task timer may not be null");
        }
        this.taskTimer = backgroundTaskTimer;
    }

    public DateTime getExpirationTime() {
        return this.expirationTime;
    }

    public DateTime getLastUpdate() {
        return this.lastUpdate;
    }

    public DateTime getLastRefresh() {
        return this.lastRefresh;
    }

    public DateTime getNextRefresh() {
        return this.nextRefresh;
    }

    public long getMaxRefreshDelay() {
        return this.maxRefreshDelay;
    }

    public void setMaxRefreshDelay(long delay) {
        if (delay < 0L) {
            throw new IllegalArgumentException("Maximum refresh delay must be greater than 0");
        }
        if (delay < (long)this.minRefreshDelay) {
            throw new IllegalArgumentException("Maximum refresh delay must be greater than or equal to minimum refresh delay");
        }
        this.maxRefreshDelay = delay;
    }

    public float getRefreshDelayFactor() {
        return this.refreshDelayFactor;
    }

    public void setRefreshDelayFactor(float factor) {
        if (factor <= 0.0f || factor >= 1.0f) {
            throw new IllegalArgumentException("Refresh delay factor must be a number between 0.0 and 1.0, exclusive");
        }
        this.refreshDelayFactor = factor;
    }

    public int getMinRefreshDelay() {
        return this.minRefreshDelay;
    }

    public void setMinRefreshDelay(int delay) {
        if (delay < 0) {
            throw new IllegalArgumentException("Minimum refresh delay must be greater than 0");
        }
        if ((long)delay > this.maxRefreshDelay) {
            throw new IllegalArgumentException("Minimum refresh delay must be less than or equal to maximum refresh delay");
        }
        this.minRefreshDelay = delay;
    }

    protected XMLObject doGetMetadata() throws MetadataProviderException {
        return this.cachedMetadata;
    }

    protected void doInitialization() throws MetadataProviderException {
        this.refresh();
    }

    public void refresh() throws MetadataProviderException {
        DateTime now = new DateTime((Chronology)ISOChronology.getInstanceUTC());
        String mdId = this.getMetadataIdentifier();
        this.log.debug("Beginning refresh of metadata from '{}'", (Object)mdId);
        try {
            try {
                byte[] mdBytes = this.fetchMetadata();
                if (mdBytes == null) {
                    this.log.debug("Metadata from '{}' has not changed since last refresh", (Object)mdId);
                    this.processCachedMetadata(mdId, now);
                    this.log.info("Metadata from '{}' unchanged since last refresh, next refresh will occur at approximately {}", (Object)this.getMetadataIdentifier(), (Object)this.nextRefresh);
                } else {
                    this.log.debug("Processing new metadata from '{}'", (Object)mdId);
                    this.processNewMetadata(mdId, now, mdBytes);
                }
            }
            catch (Exception e) {
                this.log.debug("Error occurred while attempting to refresh metadata from '{}', next refresh for metadata from '{}' will occur in approximately {}ms", (Object)mdId, (Object)this.minRefreshDelay);
                this.taskTimer.schedule((TimerTask)new RefreshMetadataTask(), this.minRefreshDelay);
                throw new MetadataProviderException(e);
            }
        }
        finally {
            this.lastRefresh = now;
        }
    }

    protected abstract String getMetadataIdentifier();

    protected abstract byte[] fetchMetadata() throws MetadataProviderException;

    protected XMLObject unmarshallMetadata(byte[] metadataBytes) throws MetadataProviderException {
        try {
            return this.unmarshallMetadata(new ByteArrayInputStream(metadataBytes));
        }
        catch (UnmarshallingException e) {
            String errorMsg = "Unable to unmarshall metadata";
            this.log.error(errorMsg, (Throwable)e);
            throw new MetadataProviderException(errorMsg, (Exception)((Object)e));
        }
    }

    protected void processCachedMetadata(String metadataIdentifier, DateTime refreshStart) throws MetadataProviderException {
        this.log.debug("Computing new expiration time for cached metadata from '{}", (Object)metadataIdentifier);
        DateTime metadataExpirationTime = SAML2Helper.getEarliestExpiration(this.cachedMetadata, refreshStart.plus(this.getMaxRefreshDelay()), refreshStart);
        this.log.debug("Expiration of cached metadata from '{}' will occur at {}", (Object)metadataIdentifier, (Object)metadataExpirationTime.toString());
        this.expirationTime = metadataExpirationTime;
        long nextRefreshDelay = this.computeNextRefreshDelay(this.expirationTime);
        this.nextRefresh = new DateTime((Chronology)ISOChronology.getInstanceUTC()).plus(nextRefreshDelay);
        this.taskTimer.schedule((TimerTask)new RefreshMetadataTask(), nextRefreshDelay);
    }

    protected void processNewMetadata(String metadataIdentifier, DateTime refreshStart, byte[] metadataBytes) throws MetadataProviderException {
        this.log.debug("Unmarshalling metadata from '{}'", (Object)metadataIdentifier);
        XMLObject metadata = this.unmarshallMetadata(metadataBytes);
        if (!this.isValid(metadata)) {
            this.processPreExpiredMetadata(metadataIdentifier, refreshStart, metadataBytes, metadata);
        } else {
            this.processNonExpiredMetadata(metadataIdentifier, refreshStart, metadataBytes, metadata);
        }
    }

    protected void processPreExpiredMetadata(String metadataIdentifier, DateTime refreshStart, byte[] metadataBytes, XMLObject metadata) {
        this.log.warn("Entire metadata document from '{}' was expired at time of loading", (Object)metadataIdentifier);
        this.lastUpdate = refreshStart;
        this.taskTimer.schedule((TimerTask)new RefreshMetadataTask(), this.getMinRefreshDelay());
        this.nextRefresh = new DateTime((Chronology)ISOChronology.getInstanceUTC()).plus((long)this.getMinRefreshDelay());
        this.log.info("Existing metadata retained, next refresh from '{}' will occur at approximately {}", (Object)this.getMetadataIdentifier(), (Object)this.nextRefresh);
    }

    protected void processNonExpiredMetadata(String metadataIdentifier, DateTime refreshStart, byte[] metadataBytes, XMLObject metadata) throws MetadataProviderException {
        long nextRefreshDelay;
        Document metadataDom = metadata.getDOM().getOwnerDocument();
        this.log.debug("Filtering metadata from '{}'", (Object)metadataIdentifier);
        try {
            this.filterMetadata(metadata);
        }
        catch (FilterException e) {
            String errMsg = "Error filtering metadata from " + metadataIdentifier;
            this.log.error(errMsg, (Throwable)e);
            throw new MetadataProviderException(errMsg, e);
        }
        this.log.debug("Releasing cached DOM for metadata from '{}'", (Object)metadataIdentifier);
        this.releaseMetadataDOM(metadata);
        this.log.debug("Post-processing metadata from '{}'", (Object)metadataIdentifier);
        this.postProcessMetadata(metadataBytes, metadataDom, metadata);
        this.log.debug("Computing expiration time for metadata from '{}'", (Object)metadataIdentifier);
        DateTime metadataExpirationTime = SAML2Helper.getEarliestExpiration(metadata, refreshStart.plus(this.getMaxRefreshDelay()), refreshStart);
        this.log.debug("Expiration of metadata from '{}' will occur at {}", (Object)metadataIdentifier, (Object)metadataExpirationTime.toString());
        this.cachedMetadata = metadata;
        this.lastUpdate = refreshStart;
        if (metadataExpirationTime.isBeforeNow()) {
            this.expirationTime = new DateTime((Chronology)ISOChronology.getInstanceUTC()).plus((long)this.getMinRefreshDelay());
            nextRefreshDelay = this.getMaxRefreshDelay();
        } else {
            this.expirationTime = metadataExpirationTime;
            nextRefreshDelay = this.computeNextRefreshDelay(this.expirationTime);
        }
        this.taskTimer.schedule((TimerTask)new RefreshMetadataTask(), nextRefreshDelay);
        this.nextRefresh = new DateTime((Chronology)ISOChronology.getInstanceUTC()).plus(nextRefreshDelay);
        this.emitChangeEvent();
        this.log.info("New metadata loaded from '{}', next refresh will occur at approximately {}", (Object)this.getMetadataIdentifier(), (Object)this.nextRefresh.toDateTime(DateTimeZone.getDefault()));
    }

    protected void postProcessMetadata(byte[] metadataBytes, Document metadataDom, XMLObject metadata) throws MetadataProviderException {
    }

    protected long computeNextRefreshDelay(DateTime expectedExpiration) {
        long refreshDelay;
        long now = new DateTime((Chronology)ISOChronology.getInstanceUTC()).getMillis();
        long expireInstant = 0L;
        if (expectedExpiration != null) {
            expireInstant = expectedExpiration.toDateTime((Chronology)ISOChronology.getInstanceUTC()).getMillis();
        }
        if ((refreshDelay = (long)((float)(expireInstant - now) * this.getRefreshDelayFactor())) < (long)this.getMinRefreshDelay()) {
            refreshDelay = this.getMinRefreshDelay();
        }
        return refreshDelay;
    }

    protected byte[] inputstreamToByteArray(InputStream ins) throws MetadataProviderException {
        try {
            byte[] buffer = new byte[0x100000];
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            long count = 0L;
            int n = 0;
            while (-1 != (n = ins.read(buffer))) {
                output.write(buffer, 0, n);
                count += (long)n;
            }
            ins.close();
            return output.toByteArray();
        }
        catch (IOException e) {
            throw new MetadataProviderException(e);
        }
    }

    private class RefreshMetadataTask
    extends TimerTask {
        private RefreshMetadataTask() {
        }

        public void run() {
            try {
                AbstractReloadingMetadataProvider.this.refresh();
            }
            catch (MetadataProviderException e) {
                return;
            }
        }
    }
}

