/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml1.binding.artifact;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.opensaml.common.binding.BasicEndpointSelector;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.saml1.binding.artifact.SAML1ArtifactBuilder;
import org.opensaml.saml1.binding.artifact.SAML1ArtifactType0002;
import org.opensaml.saml1.core.Assertion;
import org.opensaml.saml1.core.NameIdentifier;
import org.opensaml.saml1.core.RequestAbstractType;
import org.opensaml.saml1.core.Response;
import org.opensaml.saml2.metadata.ArtifactResolutionService;
import org.opensaml.saml2.metadata.Endpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAML1ArtifactType0002Builder
implements SAML1ArtifactBuilder<SAML1ArtifactType0002> {
    private final Logger log = LoggerFactory.getLogger(SAML1ArtifactType0002Builder.class);

    @Override
    public SAML1ArtifactType0002 buildArtifact(byte[] artifact) {
        return SAML1ArtifactType0002.parseArtifact(artifact);
    }

    @Override
    public SAML1ArtifactType0002 buildArtifact(SAMLMessageContext<RequestAbstractType, Response, NameIdentifier> requestContext, Assertion assertion) {
        String sourceLocation;
        block3: {
            try {
                sourceLocation = this.getSourceLocation(requestContext);
                if (sourceLocation != null) break block3;
                return null;
            }
            catch (NoSuchAlgorithmException e) {
                this.log.error("JVM does not support required cryptography algorithms: SHA1PRNG.", (Throwable)e);
                throw new InternalError("JVM does not support required cryptography algorithms: SHA1PRNG.");
            }
        }
        SecureRandom handleGenerator = SecureRandom.getInstance("SHA1PRNG");
        byte[] assertionHandle = new byte[20];
        handleGenerator.nextBytes(assertionHandle);
        return new SAML1ArtifactType0002(assertionHandle, sourceLocation);
    }

    protected String getSourceLocation(SAMLMessageContext<RequestAbstractType, Response, NameIdentifier> requestContext) {
        BasicEndpointSelector selector = new BasicEndpointSelector();
        selector.setEndpointType(ArtifactResolutionService.DEFAULT_ELEMENT_NAME);
        selector.getSupportedIssuerBindings().add("urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding");
        selector.setMetadataProvider(requestContext.getMetadataProvider());
        selector.setEntityMetadata(requestContext.getLocalEntityMetadata());
        selector.setEntityRoleMetadata(requestContext.getLocalEntityRoleMetadata());
        Endpoint acsEndpoint = selector.selectEndpoint();
        if (acsEndpoint == null) {
            this.log.error("Unable to select source location for artifact.  No artifact resolution service defined for issuer.");
            return null;
        }
        return acsEndpoint.getLocation();
    }
}

