/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import org.apache.velocity.app.Velocity;
import org.apache.xml.security.Init;
import org.opensaml.Configuration;
import org.opensaml.saml1.binding.artifact.SAML1ArtifactBuilderFactory;
import org.opensaml.saml2.binding.artifact.SAML2ArtifactBuilderFactory;
import org.opensaml.xml.ConfigurationException;
import org.opensaml.xml.XMLConfigurator;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.parse.StaticBasicParserPool;
import org.opensaml.xml.parse.XMLParserException;
import org.opensaml.xml.security.DefaultSecurityConfigurationBootstrap;
import org.opensaml.xml.security.SecurityConfiguration;
import org.owasp.esapi.ESAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBootstrap {
    private static String[] xmlToolingConfigs = new String[]{"/default-config.xml", "/schema-config.xml", "/signature-config.xml", "/signature-validation-config.xml", "/encryption-config.xml", "/encryption-validation-config.xml", "/soap11-config.xml", "/wsfed11-protocol-config.xml", "/saml1-assertion-config.xml", "/saml1-protocol-config.xml", "/saml1-core-validation-config.xml", "/saml2-assertion-config.xml", "/saml2-protocol-config.xml", "/saml2-core-validation-config.xml", "/saml1-metadata-config.xml", "/saml2-metadata-config.xml", "/saml2-metadata-validation-config.xml", "/saml2-metadata-attr-config.xml", "/saml2-metadata-idp-discovery-config.xml", "/saml2-metadata-ui-config.xml", "/saml2-protocol-thirdparty-config.xml", "/saml2-metadata-query-config.xml", "/saml2-assertion-delegation-restriction-config.xml", "/saml2-ecp-config.xml", "/xacml10-saml2-profile-config.xml", "/xacml11-saml2-profile-config.xml", "/xacml20-context-config.xml", "/xacml20-policy-config.xml", "/xacml2-saml2-profile-config.xml", "/xacml3-saml2-profile-config.xml", "/wsaddressing-config.xml", "/wssecurity-config.xml"};

    protected DefaultBootstrap() {
    }

    public static synchronized void bootstrap() throws ConfigurationException {
        DefaultBootstrap.initializeXMLSecurity();
        DefaultBootstrap.initializeVelocity();
        DefaultBootstrap.initializeXMLTooling(xmlToolingConfigs);
        DefaultBootstrap.initializeArtifactBuilderFactories();
        DefaultBootstrap.initializeGlobalSecurityConfiguration();
        DefaultBootstrap.initializeParserPool();
        DefaultBootstrap.initializeESAPI();
    }

    protected static void initializeESAPI() {
        ESAPI.initialize((String)"org.opensaml.ESAPISecurityConfig");
    }

    protected static void initializeParserPool() throws ConfigurationException {
        StaticBasicParserPool pp = new StaticBasicParserPool();
        pp.setMaxPoolSize(50);
        try {
            pp.initialize();
        }
        catch (XMLParserException e) {
            throw new ConfigurationException("Error initializing parser pool", (Exception)((Object)e));
        }
        Configuration.setParserPool((ParserPool)pp);
    }

    protected static void initializeGlobalSecurityConfiguration() {
        Configuration.setGlobalSecurityConfiguration((SecurityConfiguration)DefaultSecurityConfigurationBootstrap.buildDefaultConfig());
    }

    protected static void initializeXMLSecurity() throws ConfigurationException {
        Logger log = DefaultBootstrap.getLogger();
        String lineBreakPropName = "org.apache.xml.security.ignoreLineBreaks";
        if (System.getProperty(lineBreakPropName) == null) {
            System.setProperty(lineBreakPropName, "true");
        }
        if (!Init.isInitialized()) {
            log.debug("Initializing Apache XMLSecurity library");
            Init.init();
        }
    }

    protected static void initializeVelocity() throws ConfigurationException {
        Logger log = DefaultBootstrap.getLogger();
        try {
            log.debug("Initializing Velocity template engine");
            Velocity.setProperty((String)"runtime.log.logsystem.class", (Object)"org.apache.velocity.runtime.log.NullLogChute");
            Velocity.setProperty((String)"ISO-8859-1", (Object)"UTF-8");
            Velocity.setProperty((String)"output.encoding", (Object)"UTF-8");
            Velocity.setProperty((String)"resource.loader", (Object)"classpath");
            Velocity.setProperty((String)"classpath.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
            Velocity.init();
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to initialize Velocity template engine", e);
        }
    }

    protected static void initializeXMLTooling(String[] providerConfigs) throws ConfigurationException {
        Logger log = DefaultBootstrap.getLogger();
        Class<Configuration> clazz = Configuration.class;
        XMLConfigurator configurator = new XMLConfigurator();
        String[] stringArray = providerConfigs;
        int n = providerConfigs.length;
        int n2 = 0;
        while (n2 < n) {
            String config = stringArray[n2];
            log.debug("Loading XMLTooling configuration {}", (Object)config);
            configurator.load(clazz.getResourceAsStream(config));
            ++n2;
        }
    }

    protected static void initializeArtifactBuilderFactories() throws ConfigurationException {
        Logger log = DefaultBootstrap.getLogger();
        log.debug("Initializing SAML Artifact builder factories");
        Configuration.setSAML1ArtifactBuilderFactory(new SAML1ArtifactBuilderFactory());
        Configuration.setSAML2ArtifactBuilderFactory(new SAML2ArtifactBuilderFactory());
    }

    protected static Logger getLogger() {
        return LoggerFactory.getLogger(DefaultBootstrap.class);
    }
}

