/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.io.svn.ISVNConnector;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryImpl;
import org.tmatesoft.svn.core.internal.util.SVNSocketFactory;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNPlainConnector
implements ISVNConnector {
    private static final int DEFAULT_SVN_TIMEOUT = 0;
    private Socket mySocket;
    private OutputStream myOutputStream;
    private InputStream myInputStream;

    public void open(SVNRepositoryImpl repository) throws SVNException {
        if (this.mySocket != null) {
            return;
        }
        SVNURL location = repository.getLocation();
        try {
            int connectTimeout = repository.getAuthenticationManager() != null ? repository.getAuthenticationManager().getConnectTimeout(repository) : 0;
            int readTimeout = repository.getAuthenticationManager() != null ? repository.getAuthenticationManager().getReadTimeout(repository) : 0;
            this.mySocket = SVNSocketFactory.createPlainSocket(location.getHost(), location.getPort(), connectTimeout, readTimeout, repository.getCanceller());
        }
        catch (SocketTimeoutException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_SVN_IO_ERROR, "timed out waiting for server", null, 0, e);
            SVNErrorManager.error(err, e, SVNLogType.NETWORK);
        }
        catch (UnknownHostException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_SVN_IO_ERROR, "Unknown host " + e.getMessage(), null, 0, e);
            SVNErrorManager.error(err, e, SVNLogType.NETWORK);
        }
        catch (ConnectException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_SVN_IO_ERROR, "connection refused by the server", null, 0, e);
            SVNErrorManager.error(err, e, SVNLogType.NETWORK);
        }
        catch (IOException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_SVN_IO_ERROR, e.getLocalizedMessage());
            SVNErrorManager.error(err, e, SVNLogType.NETWORK);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(SVNRepositoryImpl repository) throws SVNException {
        if (this.mySocket != null) {
            try {
                this.mySocket.close();
            }
            catch (IOException ex) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_SVN_IO_ERROR, ex.getMessage(), ex), SVNLogType.NETWORK);
            }
            finally {
                this.mySocket = null;
                this.myInputStream = null;
                this.myOutputStream = null;
            }
        }
    }

    public boolean isStale() {
        try {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "checking whether connection is stale.");
            boolean result = this.mySocket != null && SVNSocketFactory.isSocketStale(this.mySocket);
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "connection is stale: " + result);
            return result;
        }
        catch (IOException e) {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "failure during stale check");
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, e);
            return true;
        }
    }

    public boolean isConnected(SVNRepositoryImpl repos) throws SVNException {
        return this.mySocket != null && this.mySocket.isConnected();
    }

    public InputStream getInputStream() throws IOException {
        if (this.myInputStream == null) {
            this.myInputStream = this.mySocket.getInputStream();
            this.myInputStream = new BufferedInputStream(this.myInputStream);
        }
        return this.myInputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.myOutputStream == null) {
            this.myOutputStream = new BufferedOutputStream(this.mySocket.getOutputStream());
        }
        return this.myOutputStream;
    }

    public void free() {
    }

    public boolean occupy() {
        return true;
    }
}

