/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.table;

import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeDataTable;
import org.tmatesoft.sqljet.core.internal.table.SqlJetIndexOrderCursor;
import org.tmatesoft.sqljet.core.table.ISqlJetTransaction;
import org.tmatesoft.sqljet.core.table.SqlJetDb;

public class SqlJetIndexScopeCursor
extends SqlJetIndexOrderCursor {
    private Object[] firstKey;
    private Object[] lastKey;
    private long firstRowId;
    private long lastRowId;

    public SqlJetIndexScopeCursor(ISqlJetBtreeDataTable table, SqlJetDb db, String indexName, Object[] firstKey, Object[] lastKey) throws SqlJetException {
        super(table, db, indexName);
        this.firstKey = SqlJetUtility.copyArray(firstKey);
        this.lastKey = SqlJetUtility.copyArray(lastKey);
        if (null == this.indexTable) {
            this.firstRowId = this.getRowIdFromKey(this.firstKey);
            this.lastRowId = this.getRowIdFromKey(this.lastKey);
        }
        this.first();
    }

    public boolean goTo(final long rowId) throws SqlJetException {
        return (Boolean)this.db.runReadTransaction(new ISqlJetTransaction(){

            public Object run(SqlJetDb db) throws SqlJetException {
                SqlJetIndexScopeCursor.super.goTo(rowId);
                return !SqlJetIndexScopeCursor.this.eof();
            }
        });
    }

    public boolean first() throws SqlJetException {
        return (Boolean)this.db.runReadTransaction(new ISqlJetTransaction(){

            public Object run(SqlJetDb db) throws SqlJetException {
                if (SqlJetIndexScopeCursor.this.firstKey == null) {
                    return SqlJetIndexScopeCursor.super.first();
                }
                if (SqlJetIndexScopeCursor.this.indexTable == null) {
                    if (SqlJetIndexScopeCursor.this.firstRowId == 0L) {
                        return SqlJetIndexScopeCursor.super.first();
                    }
                    return SqlJetIndexScopeCursor.this.firstRowNum(SqlJetIndexScopeCursor.this.goTo(SqlJetIndexScopeCursor.this.firstRowId));
                }
                long lookup = SqlJetIndexScopeCursor.this.indexTable.lookupNear(false, SqlJetIndexScopeCursor.this.firstKey);
                if (lookup != 0L) {
                    return SqlJetIndexScopeCursor.this.firstRowNum(SqlJetIndexScopeCursor.this.goTo(lookup));
                }
                return false;
            }
        });
    }

    public boolean next() throws SqlJetException {
        return (Boolean)this.db.runReadTransaction(new ISqlJetTransaction(){

            public Object run(SqlJetDb db) throws SqlJetException {
                if (SqlJetIndexScopeCursor.this.lastKey == null) {
                    return SqlJetIndexScopeCursor.super.next();
                }
                if (SqlJetIndexScopeCursor.this.indexTable == null) {
                    SqlJetIndexScopeCursor.super.next();
                    return !SqlJetIndexScopeCursor.this.eof();
                }
                if (SqlJetIndexScopeCursor.this.indexTable.next() && !SqlJetIndexScopeCursor.this.eof()) {
                    return SqlJetIndexScopeCursor.this.nextRowNum(SqlJetIndexScopeCursor.this.goTo(SqlJetIndexScopeCursor.this.indexTable.getKeyRowId()));
                }
                return false;
            }
        });
    }

    public boolean eof() throws SqlJetException {
        return (Boolean)this.db.runReadTransaction(new ISqlJetTransaction(){

            public Object run(SqlJetDb db) throws SqlJetException {
                return SqlJetIndexScopeCursor.super.eof() || !SqlJetIndexScopeCursor.this.checkScope();
            }
        });
    }

    private boolean checkScope() throws SqlJetException {
        if (this.indexTable == null) {
            if (this.getBtreeDataTable().eof()) {
                return false;
            }
            long rowId = this.getRowId();
            if (this.firstRowId != 0L && this.firstRowId > rowId) {
                return false;
            }
            if (this.lastRowId != 0L && this.lastRowId < rowId) {
                return false;
            }
        } else {
            if (this.firstKey != null && this.indexTable.compareKey(this.firstKey) < 0) {
                return false;
            }
            if (this.lastKey != null && this.indexTable.compareKey(this.lastKey) > 0) {
                return false;
            }
        }
        return true;
    }

    public boolean last() throws SqlJetException {
        return (Boolean)this.db.runReadTransaction(new ISqlJetTransaction(){

            public Object run(SqlJetDb db) throws SqlJetException {
                if (SqlJetIndexScopeCursor.this.lastKey == null) {
                    return SqlJetIndexScopeCursor.super.last();
                }
                if (SqlJetIndexScopeCursor.this.indexTable == null) {
                    if (SqlJetIndexScopeCursor.this.lastRowId == 0L) {
                        return SqlJetIndexScopeCursor.super.last();
                    }
                    return SqlJetIndexScopeCursor.this.lastRowNum(SqlJetIndexScopeCursor.this.goTo(SqlJetIndexScopeCursor.this.lastRowId));
                }
                long lookup = SqlJetIndexScopeCursor.this.indexTable.lookupLastNear(SqlJetIndexScopeCursor.this.lastKey);
                if (lookup != 0L) {
                    return SqlJetIndexScopeCursor.this.lastRowNum(SqlJetIndexScopeCursor.this.goTo(lookup));
                }
                return false;
            }
        });
    }

    private long getRowIdFromKey(Object[] key) {
        if (key != null && key.length > 0 && key[0] instanceof Long) {
            return (Long)key[0];
        }
        return 0L;
    }

    public void delete() throws SqlJetException {
        super.delete();
        this.db.runReadTransaction(new ISqlJetTransaction(){

            public Object run(SqlJetDb db) throws SqlJetException {
                if (!SqlJetIndexScopeCursor.this.checkScope()) {
                    SqlJetIndexScopeCursor.this.next();
                }
                return false;
            }
        });
    }

    public long getRowId() throws SqlJetException {
        if (this.indexTable != null && !this.indexTable.eof()) {
            return this.indexTable.getKeyRowId();
        }
        return super.getRowId();
    }
}

