/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.management.provider;

import java.util.concurrent.atomic.AtomicBoolean;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.management.provider.MBeanRegistrationProvider;
import net.sf.ehcache.management.provider.MBeanRegistrationProviderException;
import net.sf.ehcache.management.sampled.SampledMBeanRegistrationProvider;
import net.sf.ehcache.store.StoreFactory;

public class MBeanRegistrationProviderImpl
implements MBeanRegistrationProvider {
    private final Configuration.Monitoring monitoring;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private SampledMBeanRegistrationProvider sampledProvider;
    private CacheManager cachedCacheManager;
    private StoreFactory storeFactory;

    public MBeanRegistrationProviderImpl(Configuration configuration) {
        this.monitoring = configuration.getMonitoring();
    }

    private synchronized SampledMBeanRegistrationProvider getSampledMBeanRegistrationProvider() {
        if (this.sampledProvider == null) {
            this.sampledProvider = new SampledMBeanRegistrationProvider();
        }
        return this.sampledProvider;
    }

    public void initialize(CacheManager cacheManager, StoreFactory storeFactory) throws MBeanRegistrationProviderException {
        if (!this.initialized.getAndSet(true)) {
            if (this.shouldRegisterMBeans()) {
                this.getSampledMBeanRegistrationProvider().initialize(cacheManager, storeFactory);
            }
        } else {
            throw new IllegalStateException("MBeanRegistrationProvider is already initialized");
        }
        this.cachedCacheManager = cacheManager;
        this.storeFactory = storeFactory;
    }

    public void reinitialize() throws MBeanRegistrationProviderException {
        if (this.shouldRegisterMBeans()) {
            if (this.getSampledMBeanRegistrationProvider().isAlive()) {
                this.getSampledMBeanRegistrationProvider().reinitialize();
            } else {
                this.getSampledMBeanRegistrationProvider().initialize(this.cachedCacheManager, this.storeFactory);
            }
        }
    }

    private boolean shouldRegisterMBeans() {
        switch (this.monitoring) {
            case AUTODETECT: {
                return this.isTcActive();
            }
            case ON: {
                return true;
            }
            case OFF: {
                return false;
            }
        }
        throw new IllegalArgumentException("Unknown type of monitoring specified in config: " + (Object)((Object)this.monitoring));
    }

    private boolean isTcActive() {
        return Boolean.getBoolean("tc.active");
    }
}

