/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.config;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.bootstrap.BootstrapCacheLoader;
import net.sf.ehcache.bootstrap.BootstrapCacheLoaderFactory;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.DiskStoreConfiguration;
import net.sf.ehcache.config.FactoryConfiguration;
import net.sf.ehcache.config.TerracottaConfiguration;
import net.sf.ehcache.distribution.CacheManagerPeerListener;
import net.sf.ehcache.distribution.CacheManagerPeerListenerFactory;
import net.sf.ehcache.distribution.CacheManagerPeerProvider;
import net.sf.ehcache.distribution.CacheManagerPeerProviderFactory;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.event.CacheEventListenerFactory;
import net.sf.ehcache.event.CacheManagerEventListener;
import net.sf.ehcache.event.CacheManagerEventListenerFactory;
import net.sf.ehcache.event.RegisteredEventListeners;
import net.sf.ehcache.exceptionhandler.CacheExceptionHandler;
import net.sf.ehcache.exceptionhandler.CacheExceptionHandlerFactory;
import net.sf.ehcache.exceptionhandler.ExceptionHandlingDynamicCacheProxy;
import net.sf.ehcache.extension.CacheExtension;
import net.sf.ehcache.extension.CacheExtensionFactory;
import net.sf.ehcache.loader.CacheLoader;
import net.sf.ehcache.loader.CacheLoaderFactory;
import net.sf.ehcache.util.ClassLoaderUtil;
import net.sf.ehcache.util.PropertyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConfigurationHelper {
    private static final Logger LOG = LoggerFactory.getLogger((String)ConfigurationHelper.class.getName());
    private Configuration configuration;
    private CacheManager cacheManager;

    public ConfigurationHelper(CacheManager cacheManager, Configuration configuration) {
        if (cacheManager == null || configuration == null) {
            throw new IllegalArgumentException("Cannot have null parameters");
        }
        this.cacheManager = cacheManager;
        this.configuration = configuration;
    }

    protected static void registerCacheListeners(CacheConfiguration cacheConfiguration, RegisteredEventListeners registeredEventListeners) {
        List cacheEventListenerConfigurations = cacheConfiguration.getCacheEventListenerConfigurations();
        for (Object cacheEventListenerConfiguration : cacheEventListenerConfigurations) {
            CacheConfiguration.CacheEventListenerFactoryConfiguration factoryConfiguration = (CacheConfiguration.CacheEventListenerFactoryConfiguration)cacheEventListenerConfiguration;
            CacheEventListener cacheEventListener = ConfigurationHelper.createCacheEventListener(factoryConfiguration);
            registeredEventListeners.registerListener(cacheEventListener);
        }
    }

    protected static void registerCacheExtensions(CacheConfiguration cacheConfiguration, Ehcache cache) {
        List cacheExtensionConfigurations = cacheConfiguration.getCacheExtensionConfigurations();
        for (Object cacheExtensionConfiguration : cacheExtensionConfigurations) {
            CacheConfiguration.CacheExtensionFactoryConfiguration factoryConfiguration = (CacheConfiguration.CacheExtensionFactoryConfiguration)cacheExtensionConfiguration;
            CacheExtension cacheExtension = ConfigurationHelper.createCacheExtension(factoryConfiguration, cache);
            cache.registerCacheExtension(cacheExtension);
        }
    }

    protected static void registerCacheLoaders(CacheConfiguration cacheConfiguration, Ehcache cache) {
        List cacheLoaderConfigurations = cacheConfiguration.getCacheLoaderConfigurations();
        for (Object cacheLoaderConfiguration : cacheLoaderConfigurations) {
            CacheConfiguration.CacheLoaderFactoryConfiguration factoryConfiguration = (CacheConfiguration.CacheLoaderFactoryConfiguration)cacheLoaderConfiguration;
            CacheLoader cacheLoader = ConfigurationHelper.createCacheLoader(factoryConfiguration, cache);
            cache.registerCacheLoader(cacheLoader);
        }
    }

    private static CacheEventListener createCacheEventListener(CacheConfiguration.CacheEventListenerFactoryConfiguration factoryConfiguration) {
        String className = null;
        CacheEventListener cacheEventListener = null;
        if (factoryConfiguration != null) {
            className = factoryConfiguration.getFullyQualifiedClassPath();
        }
        if (className == null) {
            LOG.debug("CacheEventListener factory not configured. Skipping...");
        } else {
            CacheEventListenerFactory factory = (CacheEventListenerFactory)ClassLoaderUtil.createNewInstance(className);
            Properties properties = PropertyUtil.parseProperties(factoryConfiguration.getProperties(), factoryConfiguration.getPropertySeparator());
            cacheEventListener = factory.createCacheEventListener(properties);
        }
        return cacheEventListener;
    }

    private static CacheExtension createCacheExtension(CacheConfiguration.CacheExtensionFactoryConfiguration factoryConfiguration, Ehcache cache) {
        String className = null;
        CacheExtension cacheExtension = null;
        if (factoryConfiguration != null) {
            className = factoryConfiguration.getFullyQualifiedClassPath();
        }
        if (className == null) {
            LOG.debug("CacheExtension factory not configured. Skipping...");
        } else {
            CacheExtensionFactory factory = (CacheExtensionFactory)ClassLoaderUtil.createNewInstance(className);
            Properties properties = PropertyUtil.parseProperties(factoryConfiguration.getProperties(), factoryConfiguration.getPropertySeparator());
            cacheExtension = factory.createCacheExtension(cache, properties);
        }
        return cacheExtension;
    }

    private static CacheLoader createCacheLoader(CacheConfiguration.CacheLoaderFactoryConfiguration factoryConfiguration, Ehcache cache) {
        String className = null;
        CacheLoader cacheLoader = null;
        if (factoryConfiguration != null) {
            className = factoryConfiguration.getFullyQualifiedClassPath();
        }
        if (className == null) {
            LOG.debug("CacheLoader factory not configured. Skipping...");
        } else {
            CacheLoaderFactory factory = (CacheLoaderFactory)ClassLoaderUtil.createNewInstance(className);
            Properties properties = PropertyUtil.parseProperties(factoryConfiguration.getProperties(), factoryConfiguration.getPropertySeparator());
            cacheLoader = factory.createCacheLoader(cache, properties);
        }
        return cacheLoader;
    }

    public final BootstrapCacheLoader createBootstrapCacheLoader(CacheConfiguration.BootstrapCacheLoaderFactoryConfiguration factoryConfiguration) throws CacheException {
        String className = null;
        BootstrapCacheLoader bootstrapCacheLoader = null;
        if (factoryConfiguration != null) {
            className = factoryConfiguration.getFullyQualifiedClassPath();
        }
        if (className != null && className.length() != 0) {
            BootstrapCacheLoaderFactory factory = (BootstrapCacheLoaderFactory)ClassLoaderUtil.createNewInstance(className);
            Properties properties = PropertyUtil.parseProperties(factoryConfiguration.getProperties(), factoryConfiguration.getPropertySeparator());
            return factory.createBootstrapCacheLoader(properties);
        }
        LOG.debug("No BootstrapCacheLoaderFactory class specified. Skipping...");
        return bootstrapCacheLoader;
    }

    public final CacheExceptionHandler createCacheExceptionHandler(CacheConfiguration.CacheExceptionHandlerFactoryConfiguration factoryConfiguration) throws CacheException {
        String className = null;
        CacheExceptionHandler cacheExceptionHandler = null;
        if (factoryConfiguration != null) {
            className = factoryConfiguration.getFullyQualifiedClassPath();
        }
        if (className != null && className.length() != 0) {
            CacheExceptionHandlerFactory factory = (CacheExceptionHandlerFactory)ClassLoaderUtil.createNewInstance(className);
            Properties properties = PropertyUtil.parseProperties(factoryConfiguration.getProperties(), factoryConfiguration.getPropertySeparator());
            return factory.createExceptionHandler(properties);
        }
        LOG.debug("No CacheExceptionHandlerFactory class specified. Skipping...");
        return cacheExceptionHandler;
    }

    public Map<String, CacheManagerPeerProvider> createCachePeerProviders() {
        String className = null;
        HashMap<String, CacheManagerPeerProvider> cacheManagerPeerProviders = new HashMap<String, CacheManagerPeerProvider>();
        List<FactoryConfiguration> cachePeerProviderFactoryConfiguration = this.configuration.getCacheManagerPeerProviderFactoryConfiguration();
        for (FactoryConfiguration factoryConfiguration : cachePeerProviderFactoryConfiguration) {
            if (factoryConfiguration != null) {
                className = factoryConfiguration.getFullyQualifiedClassPath();
            }
            if (className == null) {
                LOG.debug("No CachePeerProviderFactoryConfiguration specified. Not configuring a CacheManagerPeerProvider.");
                return null;
            }
            CacheManagerPeerProviderFactory cacheManagerPeerProviderFactory = (CacheManagerPeerProviderFactory)ClassLoaderUtil.createNewInstance(className);
            Properties properties = PropertyUtil.parseProperties(factoryConfiguration.getProperties(), factoryConfiguration.getPropertySeparator());
            CacheManagerPeerProvider cacheManagerPeerProvider = cacheManagerPeerProviderFactory.createCachePeerProvider(this.cacheManager, properties);
            cacheManagerPeerProviders.put(cacheManagerPeerProvider.getScheme(), cacheManagerPeerProvider);
        }
        return cacheManagerPeerProviders;
    }

    public Map<String, CacheManagerPeerListener> createCachePeerListeners() {
        String className = null;
        HashMap<String, CacheManagerPeerListener> cacheManagerPeerListeners = new HashMap<String, CacheManagerPeerListener>();
        List<FactoryConfiguration> cacheManagerPeerListenerFactoryConfigurations = this.configuration.getCacheManagerPeerListenerFactoryConfigurations();
        boolean first = true;
        for (FactoryConfiguration factoryConfiguration : cacheManagerPeerListenerFactoryConfigurations) {
            if (factoryConfiguration != null) {
                className = factoryConfiguration.getFullyQualifiedClassPath();
            }
            if (className == null) {
                LOG.debug("No CachePeerListenerFactoryConfiguration specified. Not configuring a CacheManagerPeerListener.");
                return null;
            }
            CacheManagerPeerListenerFactory cacheManagerPeerListenerFactory = (CacheManagerPeerListenerFactory)ClassLoaderUtil.createNewInstance(className);
            Properties properties = PropertyUtil.parseProperties(factoryConfiguration.getProperties(), factoryConfiguration.getPropertySeparator());
            CacheManagerPeerListener cacheManagerPeerListener = cacheManagerPeerListenerFactory.createCachePeerListener(this.cacheManager, properties);
            cacheManagerPeerListeners.put(cacheManagerPeerListener.getScheme(), cacheManagerPeerListener);
        }
        return cacheManagerPeerListeners;
    }

    public final CacheManagerEventListener createCacheManagerEventListener() throws CacheException {
        String className = null;
        FactoryConfiguration cacheManagerEventListenerFactoryConfiguration = this.configuration.getCacheManagerEventListenerFactoryConfiguration();
        if (cacheManagerEventListenerFactoryConfiguration != null) {
            className = cacheManagerEventListenerFactoryConfiguration.getFullyQualifiedClassPath();
        }
        if (className == null || className.length() == 0) {
            LOG.debug("No CacheManagerEventListenerFactory class specified. Skipping...");
            return null;
        }
        CacheManagerEventListenerFactory factory = (CacheManagerEventListenerFactory)ClassLoaderUtil.createNewInstance(className);
        Properties properties = PropertyUtil.parseProperties(cacheManagerEventListenerFactoryConfiguration.properties, cacheManagerEventListenerFactoryConfiguration.getPropertySeparator());
        return factory.createCacheManagerEventListener(properties);
    }

    public final String getDiskStorePath() {
        DiskStoreConfiguration diskStoreConfiguration = this.configuration.getDiskStoreConfiguration();
        if (diskStoreConfiguration == null) {
            return null;
        }
        return diskStoreConfiguration.getPath();
    }

    public final Ehcache createDefaultCache() throws CacheException {
        CacheConfiguration cacheConfiguration = this.configuration.getDefaultCacheConfiguration();
        if (cacheConfiguration == null) {
            throw new CacheException("Illegal configuration. No default cache is configured.");
        }
        cacheConfiguration.name = "default";
        return this.createCache(cacheConfiguration);
    }

    public final Set createCaches() {
        HashSet<Ehcache> caches = new HashSet<Ehcache>();
        Set cacheConfigurations = this.configuration.getCacheConfigurations().entrySet();
        for (Map.Entry entry : cacheConfigurations) {
            CacheConfiguration cacheConfiguration = (CacheConfiguration)entry.getValue();
            Ehcache cache = this.createCache(cacheConfiguration);
            caches.add(cache);
        }
        return caches;
    }

    public final Integer numberOfCachesThatOverflowToDisk() {
        int count = 0;
        Set cacheConfigurations = this.configuration.getCacheConfigurations().entrySet();
        for (Map.Entry entry : cacheConfigurations) {
            CacheConfiguration cacheConfiguration = (CacheConfiguration)entry.getValue();
            if (!cacheConfiguration.overflowToDisk) continue;
            ++count;
        }
        return count;
    }

    public final Integer numberOfCachesThatAreDiskPersistent() {
        int count = 0;
        Set cacheConfigurations = this.configuration.getCacheConfigurations().entrySet();
        for (Map.Entry entry : cacheConfigurations) {
            CacheConfiguration cacheConfiguration = (CacheConfiguration)entry.getValue();
            if (!cacheConfiguration.isDiskPersistent()) continue;
            ++count;
        }
        return count;
    }

    final Ehcache createCacheFromName(String name) {
        CacheConfiguration cacheConfiguration = null;
        Set cacheConfigurations = this.configuration.getCacheConfigurations().entrySet();
        for (Map.Entry entry : cacheConfigurations) {
            CacheConfiguration cacheConfigurationCandidate = (CacheConfiguration)entry.getValue();
            if (!cacheConfigurationCandidate.name.equals(name)) continue;
            cacheConfiguration = cacheConfigurationCandidate;
            break;
        }
        if (cacheConfiguration == null) {
            return null;
        }
        return this.createCache(cacheConfiguration);
    }

    final Ehcache createCache(CacheConfiguration cacheConfiguration) {
        boolean terracottaClustered = false;
        String terracottaValueMode = null;
        boolean terracottaCoherentReads = true;
        TerracottaConfiguration tcConfiguration = cacheConfiguration.getTerracottaConfiguration();
        if (tcConfiguration != null) {
            terracottaClustered = tcConfiguration.isClustered();
            terracottaValueMode = tcConfiguration.getValueMode().name();
            terracottaCoherentReads = tcConfiguration.getCoherentReads();
        }
        Ehcache cache = new Cache(cacheConfiguration.name, cacheConfiguration.maxElementsInMemory, cacheConfiguration.memoryStoreEvictionPolicy, cacheConfiguration.overflowToDisk, this.getDiskStorePath(), cacheConfiguration.eternal, cacheConfiguration.timeToLiveSeconds, cacheConfiguration.timeToIdleSeconds, cacheConfiguration.diskPersistent, cacheConfiguration.diskExpiryThreadIntervalSeconds, null, null, cacheConfiguration.maxElementsOnDisk, cacheConfiguration.diskSpoolBufferSizeMB, cacheConfiguration.clearOnFlush, terracottaClustered, terracottaValueMode, terracottaCoherentReads);
        RegisteredEventListeners listeners = cache.getCacheEventNotificationService();
        ConfigurationHelper.registerCacheListeners(cacheConfiguration, listeners);
        ConfigurationHelper.registerCacheExtensions(cacheConfiguration, cache);
        BootstrapCacheLoader bootstrapCacheLoader = this.createBootstrapCacheLoader(cacheConfiguration.getBootstrapCacheLoaderFactoryConfiguration());
        cache.setBootstrapCacheLoader(bootstrapCacheLoader);
        ConfigurationHelper.registerCacheLoaders(cacheConfiguration, cache);
        cache = this.applyCacheExceptionHandler(cacheConfiguration, cache);
        return cache;
    }

    private Ehcache applyCacheExceptionHandler(CacheConfiguration cacheConfiguration, Ehcache cache) {
        CacheExceptionHandler cacheExceptionHandler = this.createCacheExceptionHandler(cacheConfiguration.getCacheExceptionHandlerFactoryConfiguration());
        cache.setCacheExceptionHandler(cacheExceptionHandler);
        if (cache.getCacheExceptionHandler() != null) {
            return ExceptionHandlingDynamicCacheProxy.createProxy(cache);
        }
        return cache;
    }

    public final Configuration getConfigurationBean() {
        return this.configuration;
    }
}

