/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.attribute.filtering.provider;

import edu.internet2.middleware.shibboleth.common.attribute.BaseAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.filtering.provider.MatchFunctor;
import edu.internet2.middleware.shibboleth.common.profile.provider.SAMLProfileRequestContext;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShibbolethFilteringContext {
    private SAMLProfileRequestContext attributeRequestContext;
    private Map<String, BaseAttribute> unfilteredAttributes;
    private Map<String, Collection> retainedValues;
    private Map<String, List<MatchFunctor>> denyValueRules;

    public ShibbolethFilteringContext(Map<String, BaseAttribute> attributes, SAMLProfileRequestContext context) {
        this.attributeRequestContext = context;
        this.unfilteredAttributes = attributes;
        this.retainedValues = new HashMap<String, Collection>();
        this.denyValueRules = new HashMap<String, List<MatchFunctor>>();
    }

    public SAMLProfileRequestContext getAttributeRequestContext() {
        return this.attributeRequestContext;
    }

    public Map<String, BaseAttribute> getUnfilteredAttributes() {
        return this.unfilteredAttributes;
    }

    public Collection getRetainedValues(String attributeId, boolean prepopulate) {
        BaseAttribute attribute = this.unfilteredAttributes.get(attributeId);
        Collection attributeValues = null;
        if (!this.retainedValues.containsKey(attributeId) && prepopulate) {
            if (prepopulate) {
                if (attribute != null) {
                    attributeValues = attribute.getValues();
                }
                this.retainedValues.put(attributeId, attributeValues);
            }
        } else {
            attributeValues = this.retainedValues.get(attributeId);
        }
        if (attributeValues == null) {
            ObjectStringComparator valueComparator = null;
            if (attribute != null) {
                valueComparator = attribute.getValueComparator();
            }
            if (valueComparator == null) {
                valueComparator = new ObjectStringComparator();
            }
            attributeValues = new TreeSet(valueComparator);
            this.retainedValues.put(attributeId, attributeValues);
        }
        return attributeValues;
    }

    public Map<String, List<MatchFunctor>> getDenyValueRules() {
        return this.denyValueRules;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ObjectStringComparator
    implements Comparator<Object> {
        private ObjectStringComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.toString().compareTo(o2.toString());
        }
    }
}

