/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.attribute;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import edu.internet2.middleware.shibboleth.common.attribute.AttributeRequestException;
import edu.internet2.middleware.shibboleth.common.attribute.BaseAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.provider.SAML1AttributeAuthority;
import edu.internet2.middleware.shibboleth.common.attribute.provider.SAML2AttributeAuthority;
import edu.internet2.middleware.shibboleth.common.config.SpringConfigurationUtils;
import edu.internet2.middleware.shibboleth.common.profile.provider.BaseSAMLProfileRequestContext;
import edu.internet2.middleware.shibboleth.common.relyingparty.provider.SAMLMDRelyingPartyConfigurationManager;
import jargs.gnu.CmdLineParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Map;
import org.opensaml.Configuration;
import org.opensaml.common.SAMLObject;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.util.resource.FilesystemResource;
import org.opensaml.util.resource.Resource;
import org.opensaml.util.resource.ResourceException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AttributeAuthorityCLI {
    private static Logger log = LoggerFactory.getLogger(AttributeAuthorityCLI.class);
    private static String[] aacliConfigs = new String[]{"internal.xml", "service.xml"};
    private static SAML1AttributeAuthority saml1AA;
    private static SAML2AttributeAuthority saml2AA;

    public static void main(String[] args) throws Exception {
        CmdLineParser parser = AttributeAuthorityCLI.parseCommandArguments(args);
        ApplicationContext appCtx = AttributeAuthorityCLI.loadConfigurations((String)parser.getOptionValue(CLIParserBuilder.CONFIG_DIR_ARG), (String)parser.getOptionValue(CLIParserBuilder.SPRING_EXTS_ARG));
        saml1AA = (SAML1AttributeAuthority)appCtx.getBean("shibboleth.SAML1AttributeAuthority");
        saml2AA = (SAML2AttributeAuthority)appCtx.getBean("shibboleth.SAML2AttributeAuthority");
        Boolean saml1 = (Boolean)parser.getOptionValue(CLIParserBuilder.SAML1_ARG, (Object)Boolean.FALSE);
        SAMLObject attributeStatement = saml1 != false ? AttributeAuthorityCLI.performSAML1AttributeResolution(parser, appCtx) : AttributeAuthorityCLI.performSAML2AttributeResolution(parser, appCtx);
        AttributeAuthorityCLI.printAttributeStatement(attributeStatement);
    }

    private static CmdLineParser parseCommandArguments(String[] args) throws Exception {
        if (args.length < 2) {
            AttributeAuthorityCLI.printHelp(System.out);
            System.out.flush();
            System.exit(0);
        }
        CmdLineParser parser = CLIParserBuilder.buildParser();
        try {
            parser.parse(args);
        }
        catch (CmdLineParser.OptionException e) {
            AttributeAuthorityCLI.errorAndExit(e.getMessage(), (Exception)((Object)e));
        }
        Boolean helpEnabled = (Boolean)parser.getOptionValue(CLIParserBuilder.HELP_ARG);
        if (helpEnabled != null) {
            AttributeAuthorityCLI.printHelp(System.out);
            System.out.flush();
            System.exit(0);
        }
        return parser;
    }

    private static ApplicationContext loadConfigurations(String configDir, String springExts) throws IOException, ResourceException {
        File configDirectory = configDir != null ? new File(configDir) : new File(System.getenv("IDP_HOME") + "/conf");
        if (!(configDirectory.exists() && configDirectory.isDirectory() && configDirectory.canRead())) {
            AttributeAuthorityCLI.errorAndExit("Configuration directory " + configDir + " does not exist, is not a directory, or is not readable", null);
        }
        AttributeAuthorityCLI.loadLoggingConfiguration(configDirectory.getAbsolutePath());
        ArrayList<String> configFiles = new ArrayList<String>();
        ArrayList<Resource> configs = new ArrayList<Resource>();
        for (String i : aacliConfigs) {
            configFiles.add(i);
        }
        if (springExts != null && !springExts.isEmpty()) {
            String[] extFiles;
            for (String extFile : extFiles = springExts.split(":")) {
                configFiles.add(extFile);
            }
        }
        for (String cfile : configFiles) {
            File config = new File(configDirectory.getPath() + File.separator + cfile);
            if (config.isDirectory() || !config.canRead()) {
                AttributeAuthorityCLI.errorAndExit("Configuration file " + config.getAbsolutePath() + " is a directory or is not readable", null);
            }
            configs.add((Resource)new FilesystemResource(config.getPath()));
        }
        GenericApplicationContext gContext = new GenericApplicationContext();
        SpringConfigurationUtils.populateRegistry((BeanDefinitionRegistry)gContext, configs);
        gContext.refresh();
        return gContext;
    }

    private static void loadLoggingConfiguration(String configDir) {
        String loggingConfig = configDir + File.separator + "logging.xml";
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        StatusManager statusManager = loggerContext.getStatusManager();
        statusManager.add((Status)new InfoStatus("Loading logging configuration file: " + loggingConfig, null));
        try {
            loggerContext.reset();
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)loggerContext);
            configurator.doConfigure((InputStream)new FileInputStream(loggingConfig));
            loggerContext.start();
        }
        catch (JoranException e) {
            statusManager.add((Status)new ErrorStatus("Error loading logging configuration file: " + configDir, null, (Throwable)e));
        }
        catch (IOException e) {
            statusManager.add((Status)new ErrorStatus("Error loading logging configuration file: " + configDir, null, (Throwable)e));
        }
    }

    private static SAMLObject performSAML1AttributeResolution(CmdLineParser parser, ApplicationContext appCtx) {
        BaseSAMLProfileRequestContext requestCtx = AttributeAuthorityCLI.buildAttributeRequestContext(parser, appCtx);
        try {
            Map<String, BaseAttribute> attributes = saml1AA.getAttributes(requestCtx);
            return saml1AA.buildAttributeStatement(null, attributes.values());
        }
        catch (AttributeRequestException e) {
            AttributeAuthorityCLI.errorAndExit("Error encountered during attribute resolution and filtering", e);
            return null;
        }
    }

    private static SAMLObject performSAML2AttributeResolution(CmdLineParser parser, ApplicationContext appCtx) {
        BaseSAMLProfileRequestContext requestCtx = AttributeAuthorityCLI.buildAttributeRequestContext(parser, appCtx);
        try {
            Map<String, BaseAttribute> attributes = saml2AA.getAttributes(requestCtx);
            return saml2AA.buildAttributeStatement(null, attributes.values());
        }
        catch (AttributeRequestException e) {
            AttributeAuthorityCLI.errorAndExit("Error encountered during attribute resolution and filtering", e);
            return null;
        }
    }

    private static BaseSAMLProfileRequestContext buildAttributeRequestContext(CmdLineParser parser, ApplicationContext appCtx) {
        BaseSAMLProfileRequestContext requestContext = new BaseSAMLProfileRequestContext();
        String[] rpConfigManagerNames = appCtx.getBeanNamesForType(SAMLMDRelyingPartyConfigurationManager.class);
        SAMLMDRelyingPartyConfigurationManager rpConfigManager = (SAMLMDRelyingPartyConfigurationManager)appCtx.getBean(rpConfigManagerNames[0]);
        requestContext.setMetadataProvider(rpConfigManager.getMetadataProvider());
        String requester = (String)parser.getOptionValue(CLIParserBuilder.REQUESTER_ARG);
        if (requester != null) {
            requestContext.setRelyingPartyConfiguration(rpConfigManager.getRelyingPartyConfiguration(requester));
        } else {
            requester = rpConfigManager.getAnonymousRelyingConfiguration().getRelyingPartyId();
            requestContext.setRelyingPartyConfiguration(rpConfigManager.getAnonymousRelyingConfiguration());
        }
        try {
            requestContext.setInboundMessageIssuer(requester);
            requestContext.setPeerEntityId(requester);
            requestContext.setPeerEntityMetadata(requestContext.getMetadataProvider().getEntityDescriptor(requester));
        }
        catch (MetadataProviderException e) {
            AttributeAuthorityCLI.errorAndExit("Unable to query for metadata for requester " + requester, (Exception)((Object)e));
        }
        try {
            String issuer = requestContext.getRelyingPartyConfiguration().getProviderId();
            requestContext.setOutboundMessageIssuer(issuer);
            requestContext.setLocalEntityId(issuer);
            requestContext.setLocalEntityMetadata(requestContext.getMetadataProvider().getEntityDescriptor(issuer));
        }
        catch (MetadataProviderException e) {
            AttributeAuthorityCLI.errorAndExit("Unable to query for metadata for issuer " + requester, (Exception)((Object)e));
        }
        String principal = (String)parser.getOptionValue(CLIParserBuilder.PRINCIPAL_ARG);
        requestContext.setPrincipalName(principal);
        String authnMethod = (String)parser.getOptionValue(CLIParserBuilder.AUTHN_METHOD_ARG);
        requestContext.setPrincipalAuthenticationMethod(authnMethod);
        return requestContext;
    }

    private static void printAttributeStatement(SAMLObject attributeStatement) {
        if (attributeStatement == null) {
            System.out.println("No attribute statement.");
            return;
        }
        Marshaller statementMarshaller = Configuration.getMarshallerFactory().getMarshaller((XMLObject)attributeStatement);
        try {
            Element statement = statementMarshaller.marshall((XMLObject)attributeStatement);
            System.out.println();
            System.out.println(XMLHelper.prettyPrintXML((Node)statement));
        }
        catch (MarshallingException e) {
            AttributeAuthorityCLI.errorAndExit("Unable to marshall attribute statement", (Exception)((Object)e));
        }
    }

    private static void printHelp(PrintStream out) {
        out.println("Attribute Authority, Command Line Interface");
        out.println("  This tools provides a command line interface to the Shibboleth Attribute Authority,");
        out.println("  providing deployers a means to test their attribute resolution and configurations.");
        out.println();
        out.println("usage:");
        out.println("  On Unix systems:       ./aacli.sh <PARAMETERS>");
        out.println("  On Windows systems:    .\\aacli.bat <PARAMETERS>");
        out.println();
        out.println("Required Parameters:");
        out.println(String.format("  --%-16s %s", "configDir", "Directory containing attribute authority configuration files"));
        out.println(String.format("  --%-16s %s", "principal", "Principal name (user id) of the person whose attributes will be retrieved"));
        out.println();
        out.println("Optional Parameters:");
        out.println(String.format("  --%-16s %s", "help", "Print this message"));
        out.println(String.format("  --%-16s %s", "springExts", "Colon-delimited list of files containing Spring extension configurations"));
        out.println(String.format("  --%-16s %s", "requester", "SAML entity ID of the relying party requesting the attributes. For example, the SPs entity ID.  If not provided, requester is treated as anonymous."));
        out.println(String.format("  --%-16s %s", "authnMethod", "Method used to authenticate the user"));
        out.println(String.format("  --%-16s %s", "saml1", "No-value parameter indicating the attribute authority should answer as if it received a SAML 1 request"));
        out.println();
    }

    private static void errorAndExit(String errorMessage, Exception e) {
        if (e == null) {
            log.error(errorMessage);
        } else {
            log.error(errorMessage, (Throwable)e);
        }
        System.out.flush();
        System.exit(1);
    }

    private static class CLIParserBuilder {
        public static final String HELP = "help";
        public static final String CONFIG_DIR = "configDir";
        public static final String SPRING_EXTS = "springExts";
        public static final String REQUESTER = "requester";
        public static final String ISSUER = "issuer";
        public static final String PRINCIPAL = "principal";
        public static final String AUTHN_METHOD = "authnMethod";
        public static final String SAML1 = "saml1";
        public static CmdLineParser.Option HELP_ARG;
        public static CmdLineParser.Option CONFIG_DIR_ARG;
        public static CmdLineParser.Option SPRING_EXTS_ARG;
        public static CmdLineParser.Option REQUESTER_ARG;
        public static CmdLineParser.Option ISSUER_ARG;
        public static CmdLineParser.Option PRINCIPAL_ARG;
        public static CmdLineParser.Option AUTHN_METHOD_ARG;
        public static CmdLineParser.Option SAML1_ARG;

        private CLIParserBuilder() {
        }

        public static CmdLineParser buildParser() {
            CmdLineParser parser = new CmdLineParser();
            HELP_ARG = parser.addBooleanOption(HELP);
            CONFIG_DIR_ARG = parser.addStringOption(CONFIG_DIR);
            SPRING_EXTS_ARG = parser.addStringOption(SPRING_EXTS);
            REQUESTER_ARG = parser.addStringOption(REQUESTER);
            ISSUER_ARG = parser.addStringOption(ISSUER);
            PRINCIPAL_ARG = parser.addStringOption(PRINCIPAL);
            AUTHN_METHOD_ARG = parser.addStringOption(AUTHN_METHOD);
            SAML1_ARG = parser.addBooleanOption(SAML1);
            return parser;
        }
    }
}

