/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.security.credential;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.AbstractCredentialResolver;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.CredentialResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainingCredentialResolver
extends AbstractCredentialResolver {
    private final Logger log = LoggerFactory.getLogger(ChainingCredentialResolver.class);
    private List<CredentialResolver> resolvers = new ArrayList<CredentialResolver>();

    public List<CredentialResolver> getResolverChain() {
        return this.resolvers;
    }

    @Override
    public Iterable<Credential> resolve(CriteriaSet criteriaSet) throws SecurityException {
        if (this.resolvers.isEmpty()) {
            this.log.warn("Chaining credential resolver resolution was attempted with an empty resolver chain");
            throw new IllegalStateException("The resolver chain is empty");
        }
        return new CredentialIterable(this, criteriaSet);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CredentialIterable
    implements Iterable<Credential> {
        private ChainingCredentialResolver parent;
        private CriteriaSet critSet;

        public CredentialIterable(ChainingCredentialResolver resolver, CriteriaSet criteriaSet) {
            this.parent = resolver;
            this.critSet = criteriaSet;
        }

        @Override
        public Iterator<Credential> iterator() {
            return new CredentialIterator(this.parent, this.critSet);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CredentialIterator
    implements Iterator<Credential> {
        private final Logger log = LoggerFactory.getLogger(CredentialIterator.class);
        private ChainingCredentialResolver parent;
        private CriteriaSet critSet;
        private Iterator<CredentialResolver> resolverIterator;
        private Iterator<Credential> credentialIterator;
        private CredentialResolver currentResolver;
        private Credential nextCredential;

        public CredentialIterator(ChainingCredentialResolver resolver, CriteriaSet criteriaSet) {
            this.parent = resolver;
            this.critSet = criteriaSet;
            this.resolverIterator = this.parent.getResolverChain().iterator();
            this.credentialIterator = this.getNextCredentialIterator();
            this.nextCredential = null;
        }

        @Override
        public boolean hasNext() {
            if (this.nextCredential != null) {
                return true;
            }
            this.nextCredential = this.getNextCredential();
            return this.nextCredential != null;
        }

        @Override
        public Credential next() {
            if (this.nextCredential != null) {
                Credential tempCred = this.nextCredential;
                this.nextCredential = null;
                return tempCred;
            }
            Credential tempCred = this.getNextCredential();
            if (tempCred != null) {
                return tempCred;
            }
            throw new NoSuchElementException("No more Credential elements are available");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove operation is not supported by this iterator");
        }

        private Iterator<Credential> getNextCredentialIterator() {
            while (this.resolverIterator.hasNext()) {
                this.currentResolver = this.resolverIterator.next();
                this.log.debug("Getting credential iterator from next resolver in chain: {}", (Object)this.currentResolver.getClass().toString());
                try {
                    return this.currentResolver.resolve(this.critSet).iterator();
                }
                catch (SecurityException e) {
                    this.log.error(String.format("Error resolving credentials from chaining resolver member '%s'", this.currentResolver.getClass().getName()), (Throwable)e);
                    if (!this.resolverIterator.hasNext()) continue;
                    this.log.error("Will attempt to resolve credentials from next member of resolver chain");
                }
            }
            this.log.debug("No more credential resolvers available in the resolver chain");
            this.currentResolver = null;
            return null;
        }

        private Credential getNextCredential() {
            if (this.credentialIterator != null && this.credentialIterator.hasNext()) {
                return this.credentialIterator.next();
            }
            this.credentialIterator = this.getNextCredentialIterator();
            while (this.credentialIterator != null) {
                if (this.credentialIterator.hasNext()) {
                    return this.credentialIterator.next();
                }
                this.credentialIterator = this.getNextCredentialIterator();
            }
            return null;
        }
    }
}

