/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.idp.config.profile.authn;

import edu.internet2.middleware.shibboleth.common.config.SpringConfigurationUtils;
import java.util.ArrayList;
import java.util.List;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.w3c.dom.Element;

public abstract class AbstractLoginHandlerBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private static Logger log = LoggerFactory.getLogger(AbstractLoginHandlerBeanDefinitionParser.class);

    protected void doParse(Element config, BeanDefinitionBuilder builder) {
        log.debug("Parsing configuration for {} authentication handler.", (Object)XMLHelper.getXSIType((Element)config).getLocalPart());
        long duration = 1800000L;
        if (config.hasAttributeNS(null, "authenticationDuration")) {
            duration = SpringConfigurationUtils.parseDurationToMillis((String)("'authenticationDuration' on LoginHandler of type " + XMLHelper.getXSIType((Element)config)), (String)config.getAttributeNS(null, "authenticationDuration"), (int)60000);
        }
        log.debug("Authentication duration: {}ms", (Object)duration);
        builder.addPropertyValue("authenticationDuration", (Object)duration);
        ArrayList<String> authnMethods = new ArrayList<String>();
        List authnMethodElems = XMLHelper.getChildElementsByTagNameNS((Element)config, (String)"urn:mace:shibboleth:2.0:idp:profile-handler", (String)"AuthenticationMethod");
        for (Element authnMethodElem : authnMethodElems) {
            String authnMethod = DatatypeHelper.safeTrimOrNullString((String)authnMethodElem.getTextContent());
            log.debug("Authentication handler declared support for authentication method {}", (Object)authnMethod);
            authnMethods.add(authnMethod);
        }
        builder.addPropertyValue("authenticationMethods", authnMethods);
    }

    protected boolean shouldGenerateId() {
        return true;
    }
}

