/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.config.security;

import edu.internet2.middleware.shibboleth.common.config.security.AbstractCredentialBeanDefinitionParser;
import edu.internet2.middleware.shibboleth.common.config.security.X509CredentialFactoryBean;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.opensaml.xml.security.x509.X509Util;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractX509CredentialBeanDefinitionParser
extends AbstractCredentialBeanDefinitionParser {
    private final Logger log = LoggerFactory.getLogger(AbstractX509CredentialBeanDefinitionParser.class);

    protected Class getBeanClass(Element element) {
        return X509CredentialFactoryBean.class;
    }

    @Override
    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) {
        return element.getAttributeNS(null, "id");
    }

    protected void doParse(Element element, BeanDefinitionBuilder builder) {
        this.log.info("Parsing configuration for {} credential with id: {}", (Object)XMLHelper.getXSIType((Element)element).getLocalPart(), (Object)element.getAttributeNS(null, "id"));
        this.parseAttributes(element, builder);
        Map configChildren = XMLHelper.getChildElements((Element)element);
        this.parseCommon(configChildren, builder);
        this.parsePrivateKey(configChildren, builder);
        this.parseCertificates(configChildren, builder);
        this.parseCRLs(configChildren, builder);
    }

    protected void parseCertificates(Map<QName, List<Element>> configChildren, BeanDefinitionBuilder builder) {
        List<Element> certElems = configChildren.get(new QName("urn:mace:shibboleth:2.0:security", "Certificate"));
        if (certElems == null || certElems.isEmpty()) {
            return;
        }
        this.log.debug("Parsing x509 credential certificates");
        ArrayList certs = new ArrayList();
        for (Element certElem : certElems) {
            byte[] encodedCert = this.getEncodedCertificate(DatatypeHelper.safeTrimOrNullString((String)certElem.getTextContent()));
            if (encodedCert == null) continue;
            boolean isEntityCert = false;
            Attr entityCertAttr = certElem.getAttributeNodeNS(null, "entityCertificate");
            if (entityCertAttr != null) {
                isEntityCert = XMLHelper.getAttributeValueAsBoolean((Attr)entityCertAttr);
            }
            if (isEntityCert) {
                this.log.debug("Element config flag found indicating entity certificate");
            }
            try {
                Collection decodedCerts = X509Util.decodeCertificate((byte[])encodedCert);
                certs.addAll(decodedCerts);
                if (!isEntityCert) continue;
                if (decodedCerts.size() == 1) {
                    builder.addPropertyValue("entityCertificate", decodedCerts.iterator().next());
                    continue;
                }
                throw new FatalBeanException("Config element indicated an entityCertificate, but multiple certs where decoded");
            }
            catch (CertificateException e) {
                throw new FatalBeanException("Unable to create X509 credential, unable to parse certificates", (Throwable)e);
            }
        }
        builder.addPropertyValue("certificates", certs);
    }

    protected abstract byte[] getEncodedCertificate(String var1);

    protected void parseCRLs(Map<QName, List<Element>> configChildren, BeanDefinitionBuilder builder) {
        List<Element> crlElems = configChildren.get(new QName("urn:mace:shibboleth:2.0:security", "CRL"));
        if (crlElems == null || crlElems.isEmpty()) {
            return;
        }
        this.log.debug("Parsing x509 credential CRLs");
        ArrayList crls = new ArrayList();
        for (Element crlElem : crlElems) {
            byte[] encodedCRL = this.getEncodedCRL(DatatypeHelper.safeTrimOrNullString((String)crlElem.getTextContent()));
            if (encodedCRL == null) continue;
            try {
                Collection decodedCRLs = X509Util.decodeCRLs((byte[])encodedCRL);
                crls.addAll(decodedCRLs);
            }
            catch (CRLException e) {
                throw new FatalBeanException("Unable to create X509 credential, unable to parse CRLs", (Throwable)e);
            }
        }
        builder.addPropertyValue("crls", crls);
    }

    protected abstract byte[] getEncodedCRL(String var1);
}

