/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.config.relyingparty;

import edu.internet2.middleware.shibboleth.common.config.SpringConfigurationUtils;
import edu.internet2.middleware.shibboleth.common.config.relyingparty.RelyingPartyFactoryBean;
import java.util.List;
import javax.xml.namespace.QName;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RelyingPartyConfigurationBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    public static final QName URP_TYPE_NAME = new QName("urn:mace:shibboleth:2.0:relying-party", "UnidentifiedRelyingParty");
    public static final QName RP_TYPE_NAME = new QName("urn:mace:shibboleth:2.0:relying-party", "IdentifiedRelyingParty");
    public static final QName ANON_RP_ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:relying-party", "AnonymousRelyingParty");
    public static final QName DEFAULT_RP_ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:relying-party", "DefaultRelyingParty");
    public static final QName RP_ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:relying-party", "RelyingParty");
    private final Logger log = LoggerFactory.getLogger(RelyingPartyConfigurationBeanDefinitionParser.class);

    protected Class getBeanClass(Element arg0) {
        return RelyingPartyFactoryBean.class;
    }

    protected void doParse(Element config, ParserContext parserContext, BeanDefinitionBuilder builder) {
        List profileConfigs;
        String rpId = this.getRelyingPartyId(config);
        this.log.info("Parsing configuration for relying party with id: {}", (Object)rpId);
        builder.addPropertyValue("relyingPartyId", (Object)rpId);
        String provider = DatatypeHelper.safeTrimOrNullString((String)config.getAttributeNS(null, "provider"));
        this.log.debug("Relying party configuration - provider ID: {}", (Object)provider);
        builder.addPropertyValue("providerId", (Object)provider);
        String authnMethod = DatatypeHelper.safeTrimOrNullString((String)config.getAttributeNS(null, "defaultAuthenticationMethod"));
        this.log.debug("Relying party configuration - default authentication method: {}", (Object)authnMethod);
        builder.addPropertyValue("defaultAuthenticationMethod", (Object)authnMethod);
        String secCredRef = DatatypeHelper.safeTrimOrNullString((String)config.getAttributeNS(null, "defaultSigningCredentialRef"));
        if (secCredRef != null) {
            this.log.debug("Relying party configuration - default signing credential: {}", (Object)secCredRef);
            builder.addPropertyReference("defaultSigningCredential", secCredRef);
        }
        if ((profileConfigs = XMLHelper.getChildElementsByTagNameNS((Element)config, (String)"urn:mace:shibboleth:2.0:relying-party", (String)"ProfileConfiguration")) != null && profileConfigs.size() > 0) {
            this.log.debug("Relying party configuration - {} profile configurations", (Object)profileConfigs.size());
            builder.addPropertyValue("profileConfigurations", (Object)SpringConfigurationUtils.parseInnerCustomElements(profileConfigs, parserContext));
        }
    }

    protected String getRelyingPartyId(Element config) {
        String id = DatatypeHelper.safeTrimOrNullString((String)config.getAttributeNS(null, "id"));
        if (id == null) {
            if (XMLHelper.getNodeQName((Node)config).equals(ANON_RP_ELEMENT_NAME)) {
                id = "anonymous";
            } else if (XMLHelper.getNodeQName((Node)config).equals(DEFAULT_RP_ELEMENT_NAME)) {
                id = "default";
            }
        }
        return id;
    }

    protected String resolveId(Element arg0, AbstractBeanDefinition arg1, ParserContext arg2) {
        return this.getRelyingPartyId(arg0);
    }
}

