/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.attribute.filtering.provider;

import edu.internet2.middleware.shibboleth.common.attribute.BaseAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.filtering.AttributeFilteringEngine;
import edu.internet2.middleware.shibboleth.common.attribute.filtering.AttributeFilteringException;
import edu.internet2.middleware.shibboleth.common.attribute.filtering.provider.AttributeFilterPolicy;
import edu.internet2.middleware.shibboleth.common.attribute.filtering.provider.AttributeRule;
import edu.internet2.middleware.shibboleth.common.attribute.filtering.provider.FilterProcessingException;
import edu.internet2.middleware.shibboleth.common.attribute.filtering.provider.MatchFunctor;
import edu.internet2.middleware.shibboleth.common.attribute.filtering.provider.ShibbolethFilteringContext;
import edu.internet2.middleware.shibboleth.common.config.BaseReloadableService;
import edu.internet2.middleware.shibboleth.common.profile.provider.SAMLProfileRequestContext;
import edu.internet2.middleware.shibboleth.common.service.ServiceException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShibbolethAttributeFilteringEngine
extends BaseReloadableService
implements AttributeFilteringEngine<SAMLProfileRequestContext> {
    private final Logger log = LoggerFactory.getLogger(ShibbolethAttributeFilteringEngine.class);
    private List<AttributeFilterPolicy> filterPolicies = new ArrayList<AttributeFilterPolicy>();

    public List<AttributeFilterPolicy> getFilterPolicies() {
        return this.filterPolicies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, BaseAttribute> filterAttributes(Map<String, BaseAttribute> attributes, SAMLProfileRequestContext context) throws AttributeFilteringException {
        this.log.debug(this.getId() + " filtering {} attributes for principal {}", (Object)attributes.size(), (Object)context.getPrincipalName());
        if (attributes.size() == 0) {
            return new HashMap<String, BaseAttribute>();
        }
        if (this.getFilterPolicies() == null) {
            this.log.debug("No filter policies were loaded in {}, filtering out all attributes for {}", (Object)this.getId(), (Object)context.getPrincipalName());
            return new HashMap<String, BaseAttribute>();
        }
        ShibbolethFilteringContext filterContext = new ShibbolethFilteringContext(attributes, context);
        Lock readLock = this.getReadWriteLock().readLock();
        readLock.lock();
        try {
            for (AttributeFilterPolicy filterPolicy : this.filterPolicies) {
                this.filterAttributes(filterContext, filterPolicy);
                this.runDenyRules(filterContext);
            }
        }
        finally {
            readLock.unlock();
        }
        Iterator<Map.Entry<String, BaseAttribute>> attributeEntryItr = attributes.entrySet().iterator();
        while (attributeEntryItr.hasNext()) {
            Map.Entry<String, BaseAttribute> attributeEntry = attributeEntryItr.next();
            BaseAttribute attribute = attributeEntry.getValue();
            Collection retainedValues = filterContext.getRetainedValues(attribute.getId(), false);
            attribute.getValues().retainAll(retainedValues);
            if (attribute.getValues().size() != 0) continue;
            this.log.debug("Removing attribute from return set, no more values: {}", (Object)attribute.getId());
            attributeEntryItr.remove();
        }
        this.log.debug("Filtered attributes for principal {}.  The following attributes remain: {}", (Object)context.getPrincipalName(), attributes.keySet());
        return attributes;
    }

    protected void filterAttributes(ShibbolethFilteringContext filterContext, AttributeFilterPolicy filterPolicy) throws FilterProcessingException {
        this.log.debug("Evaluating if filter policy {} is active for principal {}", (Object)filterPolicy.getPolicyId(), (Object)filterContext.getAttributeRequestContext().getPrincipalName());
        MatchFunctor policyRequirement = filterPolicy.getPolicyRequirementRule();
        if (policyRequirement == null || !policyRequirement.evaluatePolicyRequirement(filterContext)) {
            this.log.debug("Filter policy {} is not active for principal {}", (Object)filterPolicy.getPolicyId(), (Object)filterContext.getAttributeRequestContext().getPrincipalName());
            return;
        }
        this.log.debug("Filter policy {} is active for principal {}", (Object)filterPolicy.getPolicyId(), (Object)filterContext.getAttributeRequestContext().getPrincipalName());
        for (AttributeRule attributeRule : filterPolicy.getAttributeRules()) {
            this.filterAttributes(filterContext, attributeRule);
        }
    }

    protected void filterAttributes(ShibbolethFilteringContext filterContext, AttributeRule attributeRule) throws FilterProcessingException {
        MatchFunctor denyRule;
        String attributeId = attributeRule.getAttributeId();
        Collection attributeValues = filterContext.getRetainedValues(attributeId, false);
        MatchFunctor permitRule = attributeRule.getPermitValueRule();
        if (permitRule != null) {
            this.log.debug("Processing permit value rule for attribute {} for principal {}", (Object)attributeId, (Object)filterContext.getAttributeRequestContext().getPrincipalName());
            BaseAttribute attribute = filterContext.getUnfilteredAttributes().get(attributeId);
            if (attribute == null) {
                return;
            }
            Collection unfilteredValues = attribute.getValues();
            for (Object attributeValue : unfilteredValues) {
                if (permitRule.evaluatePermitValue(filterContext, attributeId, attributeValue)) {
                    attributeValues.add(attributeValue);
                    continue;
                }
                this.log.trace("The following value for attribute {} does not meet permit value rule: {}", (Object)attributeId, (Object)attributeValue.toString());
            }
        }
        if ((denyRule = attributeRule.getDenyValueRule()) != null) {
            this.log.debug("Registering deny value rule for attribute {} for principal {}", (Object)attributeId, (Object)filterContext.getAttributeRequestContext().getPrincipalName());
            List<MatchFunctor> denyRules = filterContext.getDenyValueRules().get(attributeId);
            if (denyRules == null) {
                denyRules = new ArrayList<MatchFunctor>();
                filterContext.getDenyValueRules().put(attributeId, denyRules);
            }
            denyRules.add(denyRule);
        }
    }

    protected void runDenyRules(ShibbolethFilteringContext filterContext) throws FilterProcessingException {
        Map<String, List<MatchFunctor>> denyRuleEntries = filterContext.getDenyValueRules();
        if (denyRuleEntries.isEmpty()) {
            return;
        }
        for (Map.Entry<String, List<MatchFunctor>> denyRuleEntry : denyRuleEntries.entrySet()) {
            List<MatchFunctor> denyRules = denyRuleEntry.getValue();
            Collection attributeValues = filterContext.getRetainedValues(denyRuleEntry.getKey(), false);
            if (denyRules.isEmpty() || attributeValues.isEmpty()) continue;
            Iterator attributeValueItr = attributeValues.iterator();
            for (MatchFunctor denyRule : denyRules) {
                while (attributeValueItr.hasNext()) {
                    Object attributeValue = attributeValueItr.next();
                    if (!denyRule.evaluateDenyRule(filterContext, denyRuleEntry.getKey(), attributeValue)) continue;
                    this.log.trace("Removing the following value of attribute {} per deny rule: {}", (Object)denyRuleEntry.getKey(), attributeValue);
                    attributeValueItr.remove();
                }
            }
        }
    }

    @Override
    protected void onNewContextCreated(ApplicationContext newServiceContext) throws ServiceException {
        List<AttributeFilterPolicy> oldFilterPolicies = this.filterPolicies;
        try {
            String[] beanNames;
            ArrayList<AttributeFilterPolicy> newFilterPolicies = new ArrayList<AttributeFilterPolicy>();
            for (String beanName : beanNames = newServiceContext.getBeanNamesForType(AttributeFilterPolicy.class)) {
                newFilterPolicies.add((AttributeFilterPolicy)newServiceContext.getBean(beanName));
            }
            this.filterPolicies = newFilterPolicies;
        }
        catch (Exception e) {
            this.filterPolicies = oldFilterPolicies;
            throw new ServiceException(this.getId() + " configuration is not valid, retaining old configuration", e);
        }
    }
}

