/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.auth;

import edu.vt.middleware.ldap.LdapConfig;
import edu.vt.middleware.ldap.LdapUtil;
import edu.vt.middleware.ldap.auth.AuthenticatorConfig;
import edu.vt.middleware.ldap.auth.AuthorizationException;
import edu.vt.middleware.ldap.auth.handler.AuthenticationCriteria;
import edu.vt.middleware.ldap.auth.handler.AuthenticationHandler;
import edu.vt.middleware.ldap.auth.handler.AuthenticationResultHandler;
import edu.vt.middleware.ldap.auth.handler.AuthorizationHandler;
import edu.vt.middleware.ldap.handler.ConnectionHandler;
import edu.vt.middleware.ldap.props.AbstractPropertyConfig;
import java.util.Arrays;
import javax.naming.AuthenticationException;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAuthenticator<T extends AuthenticatorConfig> {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected T config;

    public void setAuthenticatorConfig(T authConfig) {
        if (this.config != null) {
            ((AbstractPropertyConfig)this.config).checkImmutable();
        }
        this.config = authConfig;
    }

    protected boolean authenticateAndAuthorize(String dn, Object credential, AuthenticationResultHandler[] authResultHandler, AuthorizationHandler[] authzHandler) throws NamingException {
        boolean success;
        block4: {
            success = false;
            try {
                this.authenticateAndAuthorize(dn, credential, false, null, authResultHandler, authzHandler);
                success = true;
            }
            catch (AuthenticationException e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Authentication failed for dn: " + dn), (Throwable)e);
                }
            }
            catch (AuthorizationException e) {
                if (!this.logger.isDebugEnabled()) break block4;
                this.logger.debug((Object)("Authorization failed for dn: " + dn), (Throwable)e);
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Attributes authenticateAndAuthorize(String dn, Object credential, boolean searchAttrs, String[] retAttrs, AuthenticationResultHandler[] authResultHandler, AuthorizationHandler[] authzHandler) throws NamingException {
        String authtype = ((LdapConfig)this.config).getAuthtype();
        if (authtype.equalsIgnoreCase("none")) {
            throw new AuthenticationException("Cannot authenticate dn, authtype is 'none'");
        }
        if (!LdapUtil.checkCredential(credential)) {
            throw new AuthenticationException("Cannot authenticate dn, invalid credential");
        }
        if (dn == null || "".equals(dn)) {
            throw new AuthenticationException("Cannot authenticate dn, invalid dn");
        }
        Attributes userAttributes = null;
        ConnectionHandler ch = ((LdapConfig)this.config).getConnectionHandler().newInstance();
        try {
            AuthenticationCriteria ac = new AuthenticationCriteria(dn);
            ac.setCredential(credential);
            try {
                AuthenticationHandler authHandler = ((AuthenticatorConfig)this.config).getAuthenticationHandler().newInstance();
                authHandler.authenticate(ch, ac);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Authentication succeeded for dn: " + dn));
                }
            }
            catch (AuthenticationException e) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Authentication failed for dn: " + dn));
                }
                if (authResultHandler != null && authResultHandler.length > 0) {
                    for (AuthenticationResultHandler ah : authResultHandler) {
                        ah.process(ac, false);
                    }
                }
                throw e;
            }
            if (authzHandler != null && authzHandler.length > 0) {
                for (AuthorizationHandler azh : authzHandler) {
                    try {
                        azh.process(ac, ch.getLdapContext());
                        if (!this.logger.isInfoEnabled()) continue;
                        this.logger.info((Object)("Authorization succeeded for dn: " + dn + " with handler: " + azh));
                    }
                    catch (AuthenticationException e) {
                        if (this.logger.isInfoEnabled()) {
                            this.logger.info((Object)("Authorization failed for dn: " + dn + " with handler: " + azh));
                        }
                        if (authResultHandler != null && authResultHandler.length > 0) {
                            for (AuthenticationResultHandler ah : authResultHandler) {
                                ah.process(ac, false);
                            }
                        }
                        throw e;
                    }
                }
            }
            if (searchAttrs) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Returning attributes: ");
                    this.logger.debug((Object)("    " + (retAttrs == null ? "all attributes" : Arrays.toString(retAttrs))));
                }
                userAttributes = ch.getLdapContext().getAttributes(dn, retAttrs);
            }
            if (authResultHandler != null && authResultHandler.length > 0) {
                for (AuthenticationResultHandler ah : authResultHandler) {
                    ah.process(ac, true);
                }
            }
        }
        finally {
            ch.close();
        }
        return userAttributes;
    }

    public synchronized void close() {
        if (((AuthenticatorConfig)this.config).getDnResolver() != null) {
            ((AuthenticatorConfig)this.config).getDnResolver().close();
        }
    }
}

