/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.lang;

import com.mchange.v1.util.StringTokenizerUtils;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;

public final class VersionUtils {
    private static final MLogger logger;
    private static final int[] DFLT_VERSION_ARRAY;
    private static final int[] JDK_VERSION_ARRAY;
    private static final int JDK_VERSION;
    private static final Integer NUM_BITS;

    public static Integer jvmNumberOfBits() {
        return NUM_BITS;
    }

    public static boolean isJavaVersion10() {
        return JDK_VERSION == 10;
    }

    public static boolean isJavaVersion11() {
        return JDK_VERSION == 11;
    }

    public static boolean isJavaVersion12() {
        return JDK_VERSION == 12;
    }

    public static boolean isJavaVersion13() {
        return JDK_VERSION == 13;
    }

    public static boolean isJavaVersion14() {
        return JDK_VERSION == 14;
    }

    public static boolean isJavaVersion15() {
        return JDK_VERSION == 15;
    }

    public static boolean isAtLeastJavaVersion10() {
        return JDK_VERSION >= 10;
    }

    public static boolean isAtLeastJavaVersion11() {
        return JDK_VERSION >= 11;
    }

    public static boolean isAtLeastJavaVersion12() {
        return JDK_VERSION >= 12;
    }

    public static boolean isAtLeastJavaVersion13() {
        return JDK_VERSION >= 13;
    }

    public static boolean isAtLeastJavaVersion14() {
        return JDK_VERSION >= 14;
    }

    public static boolean isAtLeastJavaVersion15() {
        return JDK_VERSION >= 15;
    }

    public static int[] extractVersionNumberArray(String versionString, String delims) throws NumberFormatException {
        String[] intStrs = StringTokenizerUtils.tokenizeToArray(versionString, delims, false);
        int len = intStrs.length;
        int[] out = new int[len];
        for (int i = 0; i < len; ++i) {
            out[i] = Integer.parseInt(intStrs[i]);
        }
        return out;
    }

    public boolean prefixMatches(int[] pfx, int[] fullVersion) {
        if (pfx.length > fullVersion.length) {
            return false;
        }
        int len = pfx.length;
        for (int i = 0; i < len; ++i) {
            if (pfx[i] == fullVersion[i]) continue;
            return false;
        }
        return true;
    }

    public static int lexicalCompareVersionNumberArrays(int[] a, int[] b) {
        int alen = a.length;
        int blen = b.length;
        for (int i = 0; i < alen; ++i) {
            if (i == blen) {
                return 1;
            }
            if (a[i] > b[i]) {
                return 1;
            }
            if (a[i] >= b[i]) continue;
            return -1;
        }
        if (blen > alen) {
            return -1;
        }
        return 0;
    }

    static {
        Integer tmpNumBits;
        int[] v;
        logger = MLog.getLogger(VersionUtils.class);
        DFLT_VERSION_ARRAY = new int[]{1, 1};
        String vstr = System.getProperty("java.version");
        if (vstr == null) {
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.warning("Could not find java.version System property. Defaulting to JDK 1.1");
            }
            v = DFLT_VERSION_ARRAY;
        } else {
            try {
                v = VersionUtils.extractVersionNumberArray(vstr, "._");
            }
            catch (NumberFormatException e) {
                if (logger.isLoggable(MLevel.WARNING)) {
                    logger.warning("java.version ''" + vstr + "'' could not be parsed. Defaulting to JDK 1.1.");
                }
                v = DFLT_VERSION_ARRAY;
            }
        }
        int jdkv = 0;
        if (v.length > 0) {
            jdkv += v[0] * 10;
        }
        if (v.length > 1) {
            jdkv += v[1];
        }
        JDK_VERSION_ARRAY = v;
        JDK_VERSION = jdkv;
        try {
            String numBitsStr = System.getProperty("sun.arch.data.model");
            tmpNumBits = numBitsStr == null ? null : new Integer(numBitsStr);
        }
        catch (Exception e) {
            tmpNumBits = null;
        }
        if (tmpNumBits == null || tmpNumBits == 32 || tmpNumBits == 64) {
            NUM_BITS = tmpNumBits;
        } else {
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.warning("Determined a surprising jvmNumerOfBits: " + tmpNumBits + ". Setting jvmNumberOfBits to unknown (null).");
            }
            NUM_BITS = null;
        }
    }
}

