/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.idp.profile.saml1;

import edu.internet2.middleware.shibboleth.common.profile.ProfileException;
import edu.internet2.middleware.shibboleth.common.profile.provider.BaseSAMLProfileRequestContext;
import edu.internet2.middleware.shibboleth.common.relyingparty.ProfileConfiguration;
import edu.internet2.middleware.shibboleth.common.relyingparty.RelyingPartyConfiguration;
import edu.internet2.middleware.shibboleth.common.relyingparty.provider.saml1.ShibbolethSSOConfiguration;
import edu.internet2.middleware.shibboleth.common.util.HttpHelper;
import edu.internet2.middleware.shibboleth.idp.authn.LoginContext;
import edu.internet2.middleware.shibboleth.idp.authn.ShibbolethSSOLoginContext;
import edu.internet2.middleware.shibboleth.idp.profile.saml1.AbstractSAML1ProfileHandler;
import edu.internet2.middleware.shibboleth.idp.profile.saml1.BaseSAML1ProfileRequestContext;
import edu.internet2.middleware.shibboleth.idp.profile.saml1.ShibbolethSSOEndpointSelector;
import edu.internet2.middleware.shibboleth.idp.util.HttpServletHelper;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.SAMLObjectBuilder;
import org.opensaml.common.binding.decoding.SAMLMessageDecoder;
import org.opensaml.saml1.core.AttributeStatement;
import org.opensaml.saml1.core.AuthenticationStatement;
import org.opensaml.saml1.core.Request;
import org.opensaml.saml1.core.Response;
import org.opensaml.saml1.core.Statement;
import org.opensaml.saml1.core.StatusCode;
import org.opensaml.saml1.core.Subject;
import org.opensaml.saml1.core.SubjectLocality;
import org.opensaml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml2.metadata.Endpoint;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml2.metadata.SPSSODescriptor;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.message.decoder.MessageDecodingException;
import org.opensaml.ws.transport.InTransport;
import org.opensaml.ws.transport.OutTransport;
import org.opensaml.ws.transport.http.HTTPInTransport;
import org.opensaml.ws.transport.http.HTTPOutTransport;
import org.opensaml.ws.transport.http.HttpServletRequestAdapter;
import org.opensaml.ws.transport.http.HttpServletResponseAdapter;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShibbolethSSOProfileHandler
extends AbstractSAML1ProfileHandler {
    private final Logger log = LoggerFactory.getLogger(ShibbolethSSOProfileHandler.class);
    private SAMLObjectBuilder<AuthenticationStatement> authnStatementBuilder;
    private SAMLObjectBuilder<SubjectLocality> subjectLocalityBuilder;
    private SAMLObjectBuilder<Endpoint> endpointBuilder;
    private String authenticationManagerPath;

    public ShibbolethSSOProfileHandler(String authnManagerPath) {
        if (DatatypeHelper.isEmpty((String)authnManagerPath)) {
            throw new IllegalArgumentException("Authentication manager path may not be null");
        }
        this.authenticationManagerPath = authnManagerPath.startsWith("/") ? authnManagerPath : "/" + authnManagerPath;
        this.authnStatementBuilder = (SAMLObjectBuilder)this.getBuilderFactory().getBuilder(AuthenticationStatement.DEFAULT_ELEMENT_NAME);
        this.subjectLocalityBuilder = (SAMLObjectBuilder)this.getBuilderFactory().getBuilder(SubjectLocality.DEFAULT_ELEMENT_NAME);
        this.endpointBuilder = (SAMLObjectBuilder)this.getBuilderFactory().getBuilder(AssertionConsumerService.DEFAULT_ELEMENT_NAME);
    }

    public String getProfileId() {
        return "urn:mace:shibboleth:2.0:profiles:saml1:sso";
    }

    public void processRequest(HTTPInTransport inTransport, HTTPOutTransport outTransport) throws ProfileException {
        this.log.debug("Processing incoming request");
        HttpServletRequest httpRequest = ((HttpServletRequestAdapter)inTransport).getWrappedRequest();
        HttpServletResponse httpResponse = ((HttpServletResponseAdapter)outTransport).getWrappedResponse();
        ServletContext servletContext = httpRequest.getSession().getServletContext();
        LoginContext loginContext = HttpServletHelper.getLoginContext(this.getStorageService(), servletContext, httpRequest);
        if (loginContext == null || !(loginContext instanceof ShibbolethSSOLoginContext)) {
            this.log.debug("Incoming request does not contain a login context, processing as first leg of request");
            this.performAuthentication(inTransport, outTransport);
        } else if (loginContext.isPrincipalAuthenticated() || loginContext.getAuthenticationFailure() != null) {
            this.log.debug("Incoming request contains a login context, processing as second leg of request");
            HttpServletHelper.unbindLoginContext(this.getStorageService(), servletContext, httpRequest, httpResponse);
            this.completeAuthenticationRequest((ShibbolethSSOLoginContext)loginContext, inTransport, outTransport);
        } else {
            this.log.debug("Incoming request contained a login context but principal was not authenticated, processing as first leg of request");
            this.performAuthentication(inTransport, outTransport);
        }
    }

    protected void performAuthentication(HTTPInTransport inTransport, HTTPOutTransport outTransport) throws ProfileException {
        HttpServletRequest httpRequest = ((HttpServletRequestAdapter)inTransport).getWrappedRequest();
        HttpServletResponse httpResponse = ((HttpServletResponseAdapter)outTransport).getWrappedResponse();
        ShibbolethSSORequestContext requestContext = new ShibbolethSSORequestContext();
        this.decodeRequest(requestContext, inTransport, outTransport);
        ShibbolethSSOLoginContext loginContext = requestContext.getLoginContext();
        RelyingPartyConfiguration rpConfig = this.getRelyingPartyConfiguration(loginContext.getRelyingPartyId());
        loginContext.setDefaultAuthenticationMethod(rpConfig.getDefaultAuthenticationMethod());
        ProfileConfiguration ssoConfig = rpConfig.getProfileConfiguration("urn:mace:shibboleth:2.0:profiles:saml1:sso");
        if (ssoConfig == null) {
            String msg = "Shibboleth SSO profile is not configured for relying party " + loginContext.getRelyingPartyId();
            this.log.warn(msg);
            throw new ProfileException(msg);
        }
        HttpServletHelper.bindLoginContext(loginContext, this.getStorageService(), httpRequest.getSession().getServletContext(), httpRequest, httpResponse);
        try {
            String authnEngineUrl = HttpServletHelper.getContextRelativeUrl(httpRequest, this.authenticationManagerPath).buildURL();
            this.log.debug("Redirecting user to authentication engine at {}", (Object)authnEngineUrl);
            httpResponse.sendRedirect(authnEngineUrl);
        }
        catch (IOException e) {
            String msg = "Error forwarding Shibboleth SSO request to AuthenticationManager";
            this.log.error(msg, (Throwable)e);
            throw new ProfileException(msg, (Exception)e);
        }
    }

    protected void decodeRequest(ShibbolethSSORequestContext requestContext, HTTPInTransport inTransport, HTTPOutTransport outTransport) throws ProfileException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Decoding message with decoder binding {}", (Object)this.getInboundMessageDecoder(requestContext).getBindingURI());
        }
        HttpServletRequest httpRequest = ((HttpServletRequestAdapter)inTransport).getWrappedRequest();
        requestContext.setCommunicationProfileId(this.getProfileId());
        requestContext.setMetadataProvider(this.getMetadataProvider());
        requestContext.setSecurityPolicyResolver(this.getSecurityPolicyResolver());
        requestContext.setCommunicationProfileId("urn:mace:shibboleth:2.0:profiles:saml1:sso");
        requestContext.setInboundMessageTransport((InTransport)inTransport);
        requestContext.setInboundSAMLProtocol("urn:mace:shibboleth:1.0");
        requestContext.setPeerEntityRole(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        requestContext.setOutboundMessageTransport((OutTransport)outTransport);
        requestContext.setOutboundSAMLProtocol("urn:oasis:names:tc:SAML:1.1:protocol");
        SAMLMessageDecoder decoder = this.getInboundMessageDecoder(requestContext);
        requestContext.setMessageDecoder(decoder);
        try {
            decoder.decode((MessageContext)requestContext);
            this.log.debug("Decoded Shibboleth SSO request from relying party '{}'", (Object)requestContext.getInboundMessageIssuer());
        }
        catch (MessageDecodingException e) {
            String msg = "Error decoding Shibboleth SSO request";
            this.log.warn(msg, (Throwable)e);
            throw new ProfileException(msg, (Exception)((Object)e));
        }
        catch (SecurityException e) {
            String msg = "Shibboleth SSO request does not meet security requirements: " + e.getMessage();
            this.log.warn(msg);
            throw new ProfileException(msg, (Exception)((Object)e));
        }
        ShibbolethSSOLoginContext loginContext = new ShibbolethSSOLoginContext();
        loginContext.setRelyingParty(requestContext.getInboundMessageIssuer());
        loginContext.setSpAssertionConsumerService(requestContext.getSpAssertionConsumerService());
        loginContext.setSpTarget(requestContext.getRelayState());
        loginContext.setAuthenticationEngineURL(this.authenticationManagerPath);
        loginContext.setProfileHandlerURL(HttpHelper.getRequestUriWithoutContext((HttpServletRequest)httpRequest));
        requestContext.setLoginContext(loginContext);
    }

    protected void completeAuthenticationRequest(ShibbolethSSOLoginContext loginContext, HTTPInTransport inTransport, HTTPOutTransport outTransport) throws ProfileException {
        Response samlResponse;
        ShibbolethSSORequestContext requestContext = this.buildRequestContext(loginContext, inTransport, outTransport);
        try {
            AttributeStatement attributeStatement;
            if (loginContext.getAuthenticationFailure() != null) {
                requestContext.setFailureStatus(this.buildStatus(StatusCode.RESPONDER, null, "User failed authentication"));
                throw new ProfileException("Authentication failure", (Exception)loginContext.getAuthenticationFailure());
            }
            this.resolveAttributes(requestContext);
            ArrayList<Statement> statements = new ArrayList<Statement>();
            statements.add((Statement)this.buildAuthenticationStatement(requestContext));
            if (((ShibbolethSSOConfiguration)requestContext.getProfileConfiguration()).includeAttributeStatement() && (attributeStatement = this.buildAttributeStatement(requestContext, "urn:oasis:names:tc:SAML:1.0:cm:bearer")) != null) {
                requestContext.setReleasedAttributes(requestContext.getAttributes().keySet());
                statements.add((Statement)attributeStatement);
            }
            samlResponse = this.buildResponse(requestContext, statements);
        }
        catch (ProfileException e) {
            samlResponse = this.buildErrorResponse(requestContext);
        }
        requestContext.setOutboundSAMLMessage((SAMLObject)samlResponse);
        requestContext.setOutboundSAMLMessageId(samlResponse.getID());
        requestContext.setOutboundSAMLMessageIssueInstant(samlResponse.getIssueInstant());
        this.encodeResponse(requestContext);
        this.writeAuditLogEntry(requestContext);
    }

    protected ShibbolethSSORequestContext buildRequestContext(ShibbolethSSOLoginContext loginContext, HTTPInTransport in, HTTPOutTransport out) throws ProfileException {
        ShibbolethSSORequestContext requestContext = new ShibbolethSSORequestContext();
        requestContext.setCommunicationProfileId(this.getProfileId());
        requestContext.setMessageDecoder(this.getInboundMessageDecoder(requestContext));
        requestContext.setLoginContext(loginContext);
        requestContext.setRelayState(loginContext.getSpTarget());
        requestContext.setInboundMessageTransport((InTransport)in);
        requestContext.setInboundSAMLProtocol("urn:mace:shibboleth:1.0");
        requestContext.setOutboundMessageTransport((OutTransport)out);
        requestContext.setOutboundSAMLProtocol("urn:oasis:names:tc:SAML:1.1:protocol");
        requestContext.setMetadataProvider(this.getMetadataProvider());
        String relyingPartyId = loginContext.getRelyingPartyId();
        requestContext.setPeerEntityId(relyingPartyId);
        requestContext.setInboundMessageIssuer(relyingPartyId);
        this.populateRequestContext(requestContext);
        return requestContext;
    }

    protected void populateRelyingPartyInformation(BaseSAMLProfileRequestContext requestContext) throws ProfileException {
        super.populateRelyingPartyInformation(requestContext);
        EntityDescriptor relyingPartyMetadata = requestContext.getPeerEntityMetadata();
        if (relyingPartyMetadata != null) {
            requestContext.setPeerEntityRole(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
            requestContext.setPeerEntityRoleMetadata((RoleDescriptor)relyingPartyMetadata.getSPSSODescriptor("urn:oasis:names:tc:SAML:1.1:protocol"));
        }
    }

    protected void populateAssertingPartyInformation(BaseSAMLProfileRequestContext requestContext) throws ProfileException {
        super.populateAssertingPartyInformation(requestContext);
        EntityDescriptor localEntityDescriptor = requestContext.getLocalEntityMetadata();
        if (localEntityDescriptor != null) {
            requestContext.setLocalEntityRole(IDPSSODescriptor.DEFAULT_ELEMENT_NAME);
            requestContext.setLocalEntityRoleMetadata((RoleDescriptor)localEntityDescriptor.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol"));
        }
    }

    protected void populateSAMLMessageInformation(BaseSAMLProfileRequestContext requestContext) throws ProfileException {
    }

    protected Endpoint selectEndpoint(BaseSAMLProfileRequestContext requestContext) {
        ShibbolethSSOLoginContext loginContext = ((ShibbolethSSORequestContext)requestContext).getLoginContext();
        Endpoint endpoint = null;
        if (requestContext.getRelyingPartyConfiguration().getRelyingPartyId() == "anonymous") {
            if (loginContext.getSpAssertionConsumerService() != null) {
                endpoint = (Endpoint)this.endpointBuilder.buildObject();
                endpoint.setLocation(loginContext.getSpAssertionConsumerService());
                endpoint.setBinding(this.getSupportedOutboundBindings().get(0));
                this.log.warn("Generating endpoint for anonymous relying party. ACS url {} and binding {}", new Object[]{requestContext.getInboundMessageIssuer(), endpoint.getLocation(), endpoint.getBinding()});
            } else {
                this.log.warn("Unable to generate endpoint for anonymous party.  No ACS url provided.");
            }
        } else {
            ShibbolethSSOEndpointSelector endpointSelector = new ShibbolethSSOEndpointSelector();
            endpointSelector.setSpAssertionConsumerService(loginContext.getSpAssertionConsumerService());
            endpointSelector.setEndpointType(AssertionConsumerService.DEFAULT_ELEMENT_NAME);
            endpointSelector.setMetadataProvider(this.getMetadataProvider());
            endpointSelector.setEntityMetadata(requestContext.getPeerEntityMetadata());
            endpointSelector.setEntityRoleMetadata(requestContext.getPeerEntityRoleMetadata());
            endpointSelector.setSamlRequest(requestContext.getInboundSAMLMessage());
            endpointSelector.getSupportedIssuerBindings().addAll(this.getSupportedOutboundBindings());
            endpoint = endpointSelector.selectEndpoint();
        }
        return endpoint;
    }

    protected AuthenticationStatement buildAuthenticationStatement(ShibbolethSSORequestContext requestContext) throws ProfileException {
        ShibbolethSSOLoginContext loginContext = requestContext.getLoginContext();
        AuthenticationStatement statement = (AuthenticationStatement)this.authnStatementBuilder.buildObject();
        statement.setAuthenticationInstant(loginContext.getAuthenticationInstant());
        statement.setAuthenticationMethod(loginContext.getAuthenticationMethod());
        statement.setSubjectLocality(this.buildSubjectLocality(requestContext));
        Endpoint endpoint = this.selectEndpoint(requestContext);
        Subject statementSubject = endpoint.getBinding().equals("urn:oasis:names:tc:SAML:1.0:profiles:artifact-01") ? this.buildSubject(requestContext, "urn:oasis:names:tc:SAML:1.0:cm:artifact") : this.buildSubject(requestContext, "urn:oasis:names:tc:SAML:1.0:cm:bearer");
        statement.setSubject(statementSubject);
        return statement;
    }

    protected SubjectLocality buildSubjectLocality(ShibbolethSSORequestContext requestContext) {
        SubjectLocality subjectLocality = (SubjectLocality)this.subjectLocalityBuilder.buildObject();
        HTTPInTransport inTransport = (HTTPInTransport)requestContext.getInboundMessageTransport();
        subjectLocality.setIPAddress(inTransport.getPeerAddress());
        return subjectLocality;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ShibbolethSSORequestContext
    extends BaseSAML1ProfileRequestContext<Request, Response, ShibbolethSSOConfiguration> {
        private String spAssertionConsumerService;
        private ShibbolethSSOLoginContext loginContext;

        public ShibbolethSSOLoginContext getLoginContext() {
            return this.loginContext;
        }

        public void setLoginContext(ShibbolethSSOLoginContext context) {
            this.loginContext = context;
        }

        public String getSpAssertionConsumerService() {
            return this.spAssertionConsumerService;
        }

        public void setSpAssertionConsumerService(String acs) {
            this.spAssertionConsumerService = acs;
        }
    }
}

