/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.idp.profile.saml1;

import edu.internet2.middleware.shibboleth.common.profile.ProfileException;
import edu.internet2.middleware.shibboleth.common.profile.provider.BaseSAMLProfileRequestContext;
import edu.internet2.middleware.shibboleth.common.relyingparty.provider.saml1.ArtifactResolutionConfiguration;
import edu.internet2.middleware.shibboleth.idp.profile.saml1.AbstractSAML1ProfileHandler;
import edu.internet2.middleware.shibboleth.idp.profile.saml1.BaseSAML1ProfileRequestContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.joda.time.DateTime;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.SAMLObjectBuilder;
import org.opensaml.common.binding.BasicEndpointSelector;
import org.opensaml.common.binding.artifact.SAMLArtifactMap;
import org.opensaml.common.binding.decoding.SAMLMessageDecoder;
import org.opensaml.saml1.binding.SAML1ArtifactMessageContext;
import org.opensaml.saml1.core.Assertion;
import org.opensaml.saml1.core.AssertionArtifact;
import org.opensaml.saml1.core.NameIdentifier;
import org.opensaml.saml1.core.Request;
import org.opensaml.saml1.core.Response;
import org.opensaml.saml1.core.ResponseAbstractType;
import org.opensaml.saml1.core.Status;
import org.opensaml.saml1.core.StatusCode;
import org.opensaml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml2.metadata.AttributeAuthorityDescriptor;
import org.opensaml.saml2.metadata.Endpoint;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.message.decoder.MessageDecodingException;
import org.opensaml.ws.transport.InTransport;
import org.opensaml.ws.transport.OutTransport;
import org.opensaml.ws.transport.http.HTTPInTransport;
import org.opensaml.ws.transport.http.HTTPOutTransport;
import org.opensaml.xml.security.SecurityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactResolution
extends AbstractSAML1ProfileHandler {
    private final Logger log = LoggerFactory.getLogger(ArtifactResolution.class);
    private SAMLObjectBuilder<Response> responseBuilder;
    private SAMLObjectBuilder<AssertionConsumerService> acsEndpointBuilder;
    private SAMLArtifactMap artifactMap;

    public ArtifactResolution(SAMLArtifactMap map) {
        this.artifactMap = map;
        this.responseBuilder = (SAMLObjectBuilder)this.getBuilderFactory().getBuilder(Response.DEFAULT_ELEMENT_NAME);
        this.acsEndpointBuilder = (SAMLObjectBuilder)this.getBuilderFactory().getBuilder(AssertionConsumerService.DEFAULT_ELEMENT_NAME);
    }

    public String getProfileId() {
        return "urn:mace:shibboleth:2.0:profiles:saml1:query:artifact";
    }

    public void processRequest(HTTPInTransport inTransport, HTTPOutTransport outTransport) throws ProfileException {
        Response samlResponse;
        ArtifactResolutionRequestContext requestContext = new ArtifactResolutionRequestContext();
        this.decodeRequest(requestContext, inTransport, outTransport);
        try {
            if (requestContext.getProfileConfiguration() == null) {
                String msg = "SAML 1 Artifact resolution profile is not configured for relying party " + requestContext.getInboundMessageIssuer();
                requestContext.setFailureStatus(this.buildStatus(StatusCode.SUCCESS, StatusCode.REQUEST_DENIED, msg));
                this.log.warn(msg);
                throw new ProfileException(msg);
            }
            this.checkSamlVersion(requestContext);
            this.derferenceArtifacts(requestContext);
            samlResponse = this.buildArtifactResponse(requestContext);
        }
        catch (ProfileException e) {
            samlResponse = this.buildErrorResponse(requestContext);
        }
        requestContext.setOutboundSAMLMessage((SAMLObject)samlResponse);
        requestContext.setOutboundSAMLMessageId(samlResponse.getID());
        requestContext.setOutboundSAMLMessageIssueInstant(samlResponse.getIssueInstant());
        this.encodeResponse(requestContext);
        this.writeAuditLogEntry(requestContext);
    }

    protected void decodeRequest(ArtifactResolutionRequestContext requestContext, HTTPInTransport inTransport, HTTPOutTransport outTransport) throws ProfileException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Decoding message with decoder binding '{}'", (Object)this.getInboundMessageDecoder(requestContext).getBindingURI());
        }
        requestContext.setCommunicationProfileId(this.getProfileId());
        MetadataProvider metadataProvider = this.getMetadataProvider();
        requestContext.setMetadataProvider(metadataProvider);
        requestContext.setInboundMessageTransport((InTransport)inTransport);
        requestContext.setInboundSAMLProtocol("urn:oasis:names:tc:SAML:1.1:protocol");
        requestContext.setSecurityPolicyResolver(this.getSecurityPolicyResolver());
        requestContext.setPeerEntityRole(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        requestContext.setOutboundMessageTransport((OutTransport)outTransport);
        requestContext.setOutboundSAMLProtocol("urn:oasis:names:tc:SAML:1.1:protocol");
        try {
            SAMLMessageDecoder decoder = this.getInboundMessageDecoder(requestContext);
            requestContext.setMessageDecoder(decoder);
            decoder.decode((MessageContext)requestContext);
            this.log.debug("Decoded artifact resolution request from relying party '{}'", (Object)requestContext.getInboundMessageIssuer());
        }
        catch (MessageDecodingException e) {
            String msg = "Error decoding artifact resolve message";
            requestContext.setFailureStatus(this.buildStatus(StatusCode.RESPONDER, null, msg));
            this.log.warn(msg, (Throwable)e);
            throw new ProfileException(msg, (Exception)((Object)e));
        }
        catch (SecurityException e) {
            String msg = "Message did not meet security requirements";
            requestContext.setFailureStatus(this.buildStatus(StatusCode.RESPONDER, StatusCode.REQUEST_DENIED, msg));
            this.log.warn(msg, (Throwable)e);
            throw new ProfileException(msg, (Exception)((Object)e));
        }
        finally {
            this.populateRequestContext(requestContext);
        }
    }

    protected void populateRelyingPartyInformation(BaseSAMLProfileRequestContext requestContext) throws ProfileException {
        super.populateRelyingPartyInformation(requestContext);
        EntityDescriptor relyingPartyMetadata = requestContext.getPeerEntityMetadata();
        if (relyingPartyMetadata != null) {
            requestContext.setPeerEntityRole(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
            requestContext.setPeerEntityRoleMetadata((RoleDescriptor)relyingPartyMetadata.getSPSSODescriptor("urn:oasis:names:tc:SAML:1.1:protocol"));
        }
    }

    protected void populateAssertingPartyInformation(BaseSAMLProfileRequestContext requestContext) throws ProfileException {
        super.populateAssertingPartyInformation(requestContext);
        EntityDescriptor localEntityDescriptor = requestContext.getLocalEntityMetadata();
        if (localEntityDescriptor != null) {
            requestContext.setLocalEntityRole(AttributeAuthorityDescriptor.DEFAULT_ELEMENT_NAME);
            requestContext.setLocalEntityRoleMetadata((RoleDescriptor)localEntityDescriptor.getAttributeAuthorityDescriptor("urn:oasis:names:tc:SAML:1.1:protocol"));
        }
    }

    protected void populateSAMLMessageInformation(BaseSAMLProfileRequestContext requestContext) throws ProfileException {
    }

    protected Endpoint selectEndpoint(BaseSAMLProfileRequestContext requestContext) {
        Endpoint endpoint;
        if (this.getInboundBinding().equals("urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding")) {
            endpoint = (Endpoint)this.acsEndpointBuilder.buildObject();
            endpoint.setBinding("urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding");
        } else {
            BasicEndpointSelector endpointSelector = new BasicEndpointSelector();
            endpointSelector.setEndpointType(AssertionConsumerService.DEFAULT_ELEMENT_NAME);
            endpointSelector.setMetadataProvider(this.getMetadataProvider());
            endpointSelector.setEntityMetadata(requestContext.getPeerEntityMetadata());
            endpointSelector.setEntityRoleMetadata(requestContext.getPeerEntityRoleMetadata());
            endpointSelector.setSamlRequest(requestContext.getInboundSAMLMessage());
            endpointSelector.getSupportedIssuerBindings().addAll(this.getSupportedOutboundBindings());
            endpoint = endpointSelector.selectEndpoint();
        }
        return endpoint;
    }

    protected void derferenceArtifacts(ArtifactResolutionRequestContext requestContext) throws ProfileException {
        Request request = (Request)requestContext.getInboundSAMLMessage();
        List assertionArtifacts = request.getAssertionArtifacts();
        if (assertionArtifacts == null || assertionArtifacts.size() == 0) {
            String msg = "No AssertionArtifacts available in request from relying party " + requestContext.getInboundMessageIssuer();
            this.log.warn(msg);
            throw new ProfileException(msg);
        }
        ArrayList<Assertion> assertions = new ArrayList<Assertion>();
        for (AssertionArtifact assertionArtifact : assertionArtifacts) {
            SAMLArtifactMap.SAMLArtifactMapEntry artifactEntry = this.artifactMap.get(assertionArtifact.getAssertionArtifact());
            if (artifactEntry == null || artifactEntry.isExpired()) {
                this.log.warn("Unknown AssertionArtifact '{}' from relying party '{}'", (Object)assertionArtifact.getAssertionArtifact(), (Object)requestContext.getInboundMessageIssuer());
                continue;
            }
            if (!artifactEntry.getIssuerId().equals(requestContext.getLocalEntityId())) {
                this.log.warn("Artifact issuer mismatch.  Artifact issued by '{}' but IdP has entity ID of '{}'", (Object)artifactEntry.getIssuerId(), (Object)requestContext.getLocalEntityId());
                continue;
            }
            this.artifactMap.remove(assertionArtifact.getAssertionArtifact());
            assertions.add((Assertion)artifactEntry.getSamlMessage());
        }
        requestContext.setDereferencedAssertions(assertions);
    }

    protected Response buildArtifactResponse(ArtifactResolutionRequestContext requestContext) {
        DateTime issueInstant = new DateTime();
        Response samlResponse = (Response)this.responseBuilder.buildObject();
        samlResponse.setIssueInstant(issueInstant);
        this.populateStatusResponse(requestContext, (ResponseAbstractType)samlResponse);
        if (requestContext.getDereferencedAssertions() != null) {
            samlResponse.getAssertions().addAll(requestContext.getDereferencedAssertions());
        }
        Status status = this.buildStatus(StatusCode.SUCCESS, null, null);
        samlResponse.setStatus(status);
        return samlResponse;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ArtifactResolutionRequestContext
    extends BaseSAML1ProfileRequestContext<Request, Response, ArtifactResolutionConfiguration>
    implements SAML1ArtifactMessageContext<Request, Response, NameIdentifier> {
        private Collection<String> artifacts;
        private Collection<Assertion> referencedAssertions;

        public Collection<String> getArtifacts() {
            return this.artifacts;
        }

        public void setArtifacts(Collection<String> encodedArtifacts) {
            this.artifacts = encodedArtifacts;
        }

        public Collection<Assertion> getDereferencedAssertions() {
            return this.referencedAssertions;
        }

        public void setDereferencedAssertions(Collection<Assertion> assertions) {
            this.referencedAssertions = assertions;
        }
    }
}

