/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.config;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DiskStoreConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger((String)DiskStoreConfiguration.class.getName());
    private String path;

    public final String getPath() {
        return this.path;
    }

    public static String getDefaultPath() {
        return DiskStoreConfiguration.translatePath("java.io.tmpdir");
    }

    public final void setPath(String path) {
        String translatedPath;
        this.path = translatedPath = DiskStoreConfiguration.translatePath(path);
    }

    private static String translatePath(String path) {
        String translatedPath = DiskStoreConfiguration.replaceToken("user.home", System.getProperty("user.home"), path);
        translatedPath = DiskStoreConfiguration.replaceToken("user.dir", System.getProperty("user.dir"), translatedPath);
        translatedPath = DiskStoreConfiguration.replaceToken("java.io.tmpdir", System.getProperty("java.io.tmpdir"), translatedPath);
        translatedPath = DiskStoreConfiguration.replaceToken("ehcache.disk.store.dir", System.getProperty("ehcache.disk.store.dir"), translatedPath);
        translatedPath = DiskStoreConfiguration.replaceToken(File.separator + File.separator, File.separator, translatedPath);
        LOG.debug("Disk Store Path: " + translatedPath);
        return translatedPath;
    }

    public static String replaceToken(String token, String replacement, String source) {
        int foundIndex = source.indexOf(token);
        if (foundIndex == -1) {
            return source;
        }
        String firstFragment = source.substring(0, foundIndex);
        String lastFragment = source.substring(foundIndex + token.length(), source.length());
        return firstFragment + replacement + lastFragment;
    }

    private static final class Env {
        static final String USER_HOME = "user.home";
        static final String USER_DIR = "user.dir";
        static final String JAVA_IO_TMPDIR = "java.io.tmpdir";
        static final String EHCACHE_DISK_STORE_DIR = "ehcache.disk.store.dir";

        private Env() {
        }
    }
}

