/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.servlets;

import edu.vt.middleware.ldap.Ldap;
import edu.vt.middleware.ldap.LdapConfig;
import edu.vt.middleware.ldap.SearchFilter;
import edu.vt.middleware.ldap.bean.LdapAttribute;
import edu.vt.middleware.ldap.bean.LdapBeanFactory;
import edu.vt.middleware.ldap.bean.LdapBeanProvider;
import edu.vt.middleware.ldap.bean.LdapEntry;
import edu.vt.middleware.ldap.bean.LdapResult;
import edu.vt.middleware.ldap.pool.BlockingLdapPool;
import edu.vt.middleware.ldap.pool.DefaultLdapFactory;
import edu.vt.middleware.ldap.pool.LdapPool;
import edu.vt.middleware.ldap.pool.LdapPoolConfig;
import edu.vt.middleware.ldap.pool.SharedLdapPool;
import edu.vt.middleware.ldap.pool.SoftLimitLdapPool;
import java.io.IOException;
import java.util.Iterator;
import javax.naming.directory.SearchResult;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class AttributeServlet
extends HttpServlet {
    private static final long serialVersionUID = -5918353780927139315L;
    private final Log logger = LogFactory.getLog(AttributeServlet.class);
    private LdapBeanFactory beanFactory = LdapBeanProvider.getLdapBeanFactory();
    private LdapPool<Ldap> pool;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String propertiesFile = this.getInitParameter("edu.vt.middleware.ldap.servlets.propertiesFile");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("edu.vt.middleware.ldap.servlets.propertiesFile = " + propertiesFile));
        }
        LdapConfig ldapConfig = LdapConfig.createFromProperties(AttributeServlet.class.getResourceAsStream(propertiesFile));
        String poolPropertiesFile = this.getInitParameter("edu.vt.middleware.ldap.servlets.poolPropertiesFile");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("edu.vt.middleware.ldap.servlets.poolPropertiesFile = " + poolPropertiesFile));
        }
        LdapPoolConfig ldapPoolConfig = LdapPoolConfig.createFromProperties(AttributeServlet.class.getResourceAsStream(poolPropertiesFile));
        String poolType = this.getInitParameter("edu.vt.middleware.ldap.servlets.poolType");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("edu.vt.middleware.ldap.servlets.poolType = " + poolType));
        }
        if (PoolType.BLOCKING == PoolType.valueOf(poolType)) {
            this.pool = new BlockingLdapPool(ldapPoolConfig, new DefaultLdapFactory(ldapConfig));
        } else if (PoolType.SOFTLIMIT == PoolType.valueOf(poolType)) {
            this.pool = new SoftLimitLdapPool(ldapPoolConfig, new DefaultLdapFactory(ldapConfig));
        } else if (PoolType.SHARED == PoolType.valueOf(poolType)) {
            this.pool = new SharedLdapPool(ldapPoolConfig, new DefaultLdapFactory(ldapConfig));
        } else {
            throw new ServletException("Unknown pool type: " + poolType);
        }
        this.pool.initialize();
        String beanFactoryClass = this.getInitParameter("edu.vt.middleware.ldap.servlets.beanFactory");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("edu.vt.middleware.ldap.servlets.beanFactory = " + this.beanFactory));
        }
        if (beanFactoryClass != null) {
            try {
                this.beanFactory = (LdapBeanFactory)Class.forName(beanFactoryClass).newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new ServletException((Throwable)e);
            }
            catch (InstantiationException e) {
                throw new ServletException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new ServletException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String attribute = request.getParameter("attr");
        byte[] value = null;
        String content = request.getParameter("content-type");
        if (content != null && content.equalsIgnoreCase("octet")) {
            response.setContentType("application/octet-stream");
            response.setHeader("Content-Disposition", "attachment; filename=\"" + attribute + ".bin\"");
        } else {
            response.setContentType("text/plain");
        }
        try {
            Ldap ldap = null;
            try {
                ldap = this.pool.checkOut();
                Iterator<SearchResult> i = ldap.search(new SearchFilter(request.getParameter("query")), request.getParameterValues("attr"));
                LdapResult r = this.beanFactory.newLdapResult();
                r.addEntries(i);
                for (LdapEntry e : r.getEntries()) {
                    LdapAttribute a = e.getLdapAttributes().getAttribute(attribute);
                    if (a == null || a.getValues().size() <= 0) continue;
                    Object rawValue = a.getValues().iterator().next();
                    if (rawValue instanceof String) {
                        String stringValue = (String)rawValue;
                        value = stringValue.getBytes();
                        continue;
                    }
                    value = (byte[])rawValue;
                }
            }
            finally {
                this.pool.checkIn(ldap);
            }
            if (value != null) {
                ServletOutputStream out = response.getOutputStream();
                out.write(value);
                out.flush();
                out.close();
            }
        }
        catch (Exception e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error((Object)"Error performing search", (Throwable)e);
            }
            throw new ServletException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            this.pool.close();
        }
        finally {
            super.destroy();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PoolType {
        BLOCKING,
        SOFTLIMIT,
        SHARED;

    }
}

