/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.jaas;

import com.sun.security.auth.callback.TextCallbackHandler;
import edu.vt.middleware.ldap.auth.Authenticator;
import edu.vt.middleware.ldap.jaas.AbstractLoginModule;
import edu.vt.middleware.ldap.jaas.LdapDnPrincipal;
import edu.vt.middleware.ldap.jaas.LdapPrincipal;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapDnAuthorizationModule
extends AbstractLoginModule
implements LoginModule {
    private boolean noResultsIsError;
    private Authenticator auth;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        for (String key : options.keySet()) {
            String value = (String)options.get(key);
            if (!key.equalsIgnoreCase("noResultsIsError")) continue;
            this.noResultsIsError = Boolean.valueOf(value);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("noResultsIsError = " + this.noResultsIsError));
        }
        this.auth = LdapDnAuthorizationModule.createAuthenticator(options);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Created authenticator: " + this.auth.getAuthenticatorConfig()));
        }
    }

    @Override
    public boolean login() throws LoginException {
        try {
            String loginDn;
            String loginName;
            NameCallback nameCb = new NameCallback("Enter user: ");
            PasswordCallback passCb = new PasswordCallback("Enter user password: ", false);
            this.getCredentials(nameCb, passCb, false);
            if (nameCb.getName() == null && this.tryFirstPass) {
                this.getCredentials(nameCb, passCb, true);
            }
            if ((loginName = nameCb.getName()) != null && this.setLdapPrincipal) {
                this.principals.add(new LdapPrincipal(loginName));
                this.success = true;
            }
            if ((loginDn = this.auth.getDn(nameCb.getName())) == null && this.noResultsIsError) {
                this.success = false;
                throw new LoginException("Could not find DN for " + nameCb.getName());
            }
            if (loginDn != null && this.setLdapDnPrincipal) {
                this.principals.add(new LdapDnPrincipal(loginDn));
                this.success = true;
            }
            if (this.defaultRole != null && !this.defaultRole.isEmpty()) {
                this.roles.addAll(this.defaultRole);
                this.success = true;
            }
            this.storeCredentials(nameCb, passCb, loginDn);
        }
        catch (NamingException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Error occured attempting DN lookup", (Throwable)e);
            }
            this.success = false;
            throw new LoginException(e.getMessage());
        }
        finally {
            this.auth.close();
        }
        return true;
    }

    public static void main(String[] args) throws Exception {
        String name = "vt-ldap-dn";
        if (args.length > 0) {
            name = args[0];
        }
        LoginContext lc = new LoginContext(name, new TextCallbackHandler());
        lc.login();
        System.out.println("Authorization succeeded");
        Set<Principal> principals = lc.getSubject().getPrincipals();
        System.out.println("Subject Principal(s): ");
        for (Principal p : principals) {
            System.out.println("  " + p.getName());
        }
        lc.logout();
    }
}

