/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.auth;

import edu.vt.middleware.ldap.AbstractLdap;
import edu.vt.middleware.ldap.SearchFilter;
import edu.vt.middleware.ldap.auth.AuthenticatorConfig;
import edu.vt.middleware.ldap.auth.DnResolver;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import javax.naming.NamingException;
import javax.naming.directory.SearchResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchDnResolver
extends AbstractLdap<AuthenticatorConfig>
implements DnResolver,
Serializable {
    private static final long serialVersionUID = -7615995272176088807L;

    public SearchDnResolver() {
    }

    public SearchDnResolver(AuthenticatorConfig authConfig) {
        this.setAuthenticatorConfig(authConfig);
    }

    @Override
    public void setAuthenticatorConfig(AuthenticatorConfig authConfig) {
        super.setLdapConfig(authConfig);
    }

    @Override
    public AuthenticatorConfig getAuthenticatorConfig() {
        return (AuthenticatorConfig)this.config;
    }

    @Override
    public String resolve(String user) throws NamingException {
        String dn = null;
        if (user != null && !"".equals(user)) {
            SearchFilter filter = new SearchFilter();
            if (((AuthenticatorConfig)this.config).getUserFilter() != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Looking up DN using userFilter");
                }
                filter.setFilter(((AuthenticatorConfig)this.config).getUserFilter());
                filter.setFilterArgs(((AuthenticatorConfig)this.config).getUserFilterArgs());
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Looking up DN using userField");
                }
                if (((AuthenticatorConfig)this.config).getUserField() == null || ((AuthenticatorConfig)this.config).getUserField().length == 0) {
                    if (this.logger.isErrorEnabled()) {
                        this.logger.error((Object)"Invalid userField, cannot be null or empty.");
                    }
                } else {
                    StringBuffer searchFilter = new StringBuffer();
                    if (((AuthenticatorConfig)this.config).getUserField().length > 1) {
                        searchFilter.append("(|");
                        for (int i = 0; i < ((AuthenticatorConfig)this.config).getUserField().length; ++i) {
                            searchFilter.append("(").append(((AuthenticatorConfig)this.config).getUserField()[i]).append("=").append(user).append(")");
                        }
                        searchFilter.append(")");
                    } else {
                        searchFilter.append("(").append(((AuthenticatorConfig)this.config).getUserField()[0]).append("=").append(user).append(")");
                    }
                    filter.setFilter(searchFilter.toString());
                }
            }
            if (filter.getFilter() != null) {
                ArrayList<Object> filterArgs = new ArrayList<Object>();
                filterArgs.add(user);
                filterArgs.addAll(filter.getFilterArgs());
                Iterator<SearchResult> answer = this.search(((AuthenticatorConfig)this.config).getBaseDn(), filter.getFilter(), filterArgs.toArray(), ((AuthenticatorConfig)this.config).getSearchControls(new String[0]), ((AuthenticatorConfig)this.config).getSearchResultHandlers());
                if (answer != null && answer.hasNext()) {
                    SearchResult sr = answer.next();
                    dn = sr.getName();
                    if (answer.hasNext()) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("Multiple results found for user: " + user + " using filter: " + filter));
                        }
                        if (!((AuthenticatorConfig)this.config).getAllowMultipleDns()) {
                            throw new NamingException("Found more than (1) DN for: " + user);
                        }
                    }
                } else if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Search for user: " + user + " failed using filter: " + filter.getFilter()));
                }
            } else if (this.logger.isErrorEnabled()) {
                this.logger.error((Object)"DN search filter not found, no search performed");
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"User input was empty or null");
        }
        return dn;
    }

    @Override
    public void close() {
        super.close();
    }
}

