/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.config.metadata;

import edu.internet2.middleware.shibboleth.common.config.SpringConfigurationUtils;
import edu.internet2.middleware.shibboleth.common.config.metadata.AbstractReloadingMetadataProviderBeanDefinitionParser;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;
import javax.xml.namespace.QName;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.opensaml.saml2.metadata.provider.HTTPMetadataProvider;
import org.opensaml.ws.soap.client.http.HttpClientBuilder;
import org.opensaml.ws.soap.client.http.TLSProtocolSocketFactory;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class HTTPMetadataProviderBeanDefinitionParser
extends AbstractReloadingMetadataProviderBeanDefinitionParser {
    public static final QName TYPE_NAME = new QName("urn:mace:shibboleth:2.0:metadata", "HTTPMetadataProvider");
    private Logger log = LoggerFactory.getLogger(HTTPMetadataProviderBeanDefinitionParser.class);

    protected Class getBeanClass(Element element) {
        return HTTPMetadataProvider.class;
    }

    protected void doParse(Element config, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String providerId = this.getProviderId(config);
        super.doParse(config, parserContext, builder);
        String metadataURL = DatatypeHelper.safeTrimOrNullString((String)config.getAttributeNS(null, "metadataURL"));
        URI metadataURI = null;
        try {
            metadataURI = new URI(metadataURL);
        }
        catch (URISyntaxException e) {
            throw new BeanCreationException("metadataURL attribute for metadata provider " + providerId + " must be present and must contain a valid URL");
        }
        HttpClient httpClient = this.buildHttpClient(config, providerId, metadataURI);
        builder.addConstructorArgValue((Object)httpClient);
        this.log.debug("Metadata provider '{}' metadata URL: {}", (Object)providerId, (Object)metadataURL);
        builder.addConstructorArgValue((Object)metadataURL);
    }

    protected HttpClient buildHttpClient(Element config, String providerId, URI metadataURL) {
        HttpClientBuilder builder = new HttpClientBuilder();
        int requestTimeout = 5000;
        if (config.hasAttributeNS(null, "requestTimeout")) {
            requestTimeout = (int)SpringConfigurationUtils.parseDurationToMillis("'requestTimeout' on metadata provider " + providerId, config.getAttributeNS(null, "requestTimeout"), 0);
        }
        this.log.debug("Metadata provider '{}' HTTP request timeout: {}ms", (Object)providerId, (Object)requestTimeout);
        builder.setConnectionTimeout(requestTimeout);
        if (metadataURL.getScheme().equalsIgnoreCase("https")) {
            boolean disregardSslCertificate = XMLHelper.getAttributeValueAsBoolean((Attr)config.getAttributeNodeNS(null, "disregardSslCertificate"));
            this.log.debug("Metadata provider '{}' disregards server SSL certificate: {}", (Object)providerId, (Object)disregardSslCertificate);
            if (disregardSslCertificate) {
                builder.setHttpsProtocolSocketFactory((SecureProtocolSocketFactory)new TLSProtocolSocketFactory(null, this.buildNoTrustTrustManager()));
            }
        }
        this.setHttpProxySettings(builder, config, providerId);
        HttpClient httpClient = builder.buildClient();
        this.setHttpBasicAuthSettings(httpClient, config, providerId, metadataURL);
        return httpClient;
    }

    protected X509TrustManager buildNoTrustTrustManager() {
        X509TrustManager noTrustManager = new X509TrustManager(){

            public void checkClientTrusted(X509Certificate[] certs, String auth) {
            }

            public void checkServerTrusted(X509Certificate[] certs, String auth) {
            }

            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
        return noTrustManager;
    }

    protected void setHttpProxySettings(HttpClientBuilder builder, Element config, String providerId) {
        String proxyUser;
        String proxyHost = DatatypeHelper.safeTrimOrNullString((String)config.getAttributeNS(null, "proxyHost"));
        if (proxyHost == null) {
            return;
        }
        this.log.debug("Metadata provider '{}' HTTP proxy host: {}ms", (Object)providerId, (Object)proxyHost);
        builder.setProxyHost(proxyHost);
        if (config.hasAttributeNS(null, "proxyPort")) {
            int proxyPort = Integer.parseInt(config.getAttributeNS(null, "proxyPort"));
            this.log.debug("Metadata provider '{}' HTTP proxy port: ", (Object)providerId, (Object)proxyPort);
            builder.setProxyPort(proxyPort);
        }
        if ((proxyUser = DatatypeHelper.safeTrimOrNullString((String)config.getAttributeNS(null, "proxyUser"))) != null) {
            this.log.debug("Metadata provider '{}' HTTP proxy username: ", (Object)providerId, (Object)proxyUser);
            builder.setProxyUsername(proxyUser);
            this.log.debug("Metadata provider '{}' HTTP proxy password not shown", (Object)providerId);
            builder.setProxyPassword(DatatypeHelper.safeTrimOrNullString((String)config.getAttributeNS(null, "proxyPassword")));
        }
    }

    protected void setHttpBasicAuthSettings(HttpClient httpClient, Element config, String providerId, URI metadataURL) {
        String authUser = DatatypeHelper.safeTrimOrNullString((String)config.getAttributeNS(null, "basicAuthUser"));
        if (authUser == null) {
            return;
        }
        this.log.debug("Metadata provider '{}' HTTP Basic Auth username: {}", (Object)providerId, (Object)authUser);
        String authPassword = DatatypeHelper.safeTrimOrNullString((String)config.getAttributeNS(null, "basicAuthPassword"));
        this.log.debug("Metadata provider '{}' HTTP Basic Auth password not show", (Object)providerId);
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(authUser, authPassword);
        AuthScope authScope = new AuthScope(metadataURL.getHost(), metadataURL.getPort());
        httpClient.getState().setCredentials(authScope, (Credentials)credentials);
    }
}

