/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.config.attribute.resolver.dataConnector;

import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector.LdapDataConnector;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector.LdapPoolEmptyStrategy;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector.LdapPoolVTStrategy;
import edu.internet2.middleware.shibboleth.common.config.SpringConfigurationUtils;
import edu.internet2.middleware.shibboleth.common.config.attribute.resolver.dataConnector.BaseDataConnectorBeanDefinitionParser;
import edu.internet2.middleware.shibboleth.common.config.attribute.resolver.dataConnector.LdapDataConnectorFactoryBean;
import edu.vt.middleware.ldap.LdapConfig;
import edu.vt.middleware.ldap.SearchFilter;
import edu.vt.middleware.ldap.handler.ConnectionHandler;
import edu.vt.middleware.ldap.pool.CompareLdapValidator;
import edu.vt.middleware.ldap.pool.LdapPoolConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapDataConnectorBeanDefinitionParser
extends BaseDataConnectorBeanDefinitionParser {
    public static final QName TYPE_NAME = new QName("urn:mace:shibboleth:2.0:resolver:dc", "LDAPDirectory");
    private final Logger log = LoggerFactory.getLogger(LdapDataConnectorBeanDefinitionParser.class);

    protected Class<?> getBeanClass(Element element) {
        return LdapDataConnectorFactoryBean.class;
    }

    @Override
    protected void doParse(String pluginId, Element pluginConfig, Map<QName, List<Element>> pluginConfigChildren, BeanDefinitionBuilder pluginBuilder, ParserContext parserContext) {
        super.doParse(pluginId, pluginConfig, pluginConfigChildren, pluginBuilder, parserContext);
        this.processBasicConnectionConfig(pluginId, pluginConfig, pluginConfigChildren, pluginBuilder, parserContext);
        this.processSecurityConfig(pluginId, pluginConfig, pluginConfigChildren, pluginBuilder, parserContext);
        this.processResultHandlingConfig(pluginId, pluginConfig, pluginConfigChildren, pluginBuilder, parserContext);
        Map<String, String> ldapProperties = this.processLDAPProperties(pluginConfigChildren.get(new QName("urn:mace:shibboleth:2.0:resolver:dc", "LDAPProperty")));
        if (ldapProperties != null) {
            this.log.debug("Data connector {} LDAP properties: {}", (Object)pluginId, ldapProperties);
            pluginBuilder.addPropertyValue("ldapProperties", ldapProperties);
        }
        this.processPoolingConfig(pluginId, pluginConfig, pluginConfigChildren, pluginBuilder, parserContext);
        this.processCacheConfig(pluginId, pluginConfig, pluginBuilder);
    }

    protected void processBasicConnectionConfig(String pluginId, Element pluginConfig, Map<QName, List<Element>> pluginConfigChildren, BeanDefinitionBuilder pluginBuilder, ParserContext parserContext) {
        String ldapURL = pluginConfig.getAttributeNS(null, "ldapURL");
        this.log.debug("Data connector {} LDAP URL: {}", (Object)pluginId, (Object)ldapURL);
        pluginBuilder.addPropertyValue("ldapUrl", (Object)ldapURL);
        ConnectionHandler.ConnectionStrategy connStrategy = ConnectionHandler.ConnectionStrategy.ACTIVE_PASSIVE;
        if (pluginConfig.hasAttributeNS(null, "connectionStrategy")) {
            connStrategy = ConnectionHandler.ConnectionStrategy.valueOf((String)pluginConfig.getAttributeNS(null, "connectionStrategy"));
        }
        this.log.debug("Data connector {} connection strategy: {}", (Object)pluginId, (Object)connStrategy);
        pluginBuilder.addPropertyValue("connectionStrategy", (Object)connStrategy);
        if (pluginConfig.hasAttributeNS(null, "baseDN")) {
            String baseDN = pluginConfig.getAttributeNS(null, "baseDN");
            this.log.debug("Data connector {} base DN: {}", (Object)pluginId, (Object)baseDN);
            pluginBuilder.addPropertyValue("baseDN", (Object)baseDN);
        }
        LdapDataConnector.AUTHENTICATION_TYPE authnType = LdapDataConnector.AUTHENTICATION_TYPE.SIMPLE;
        if (pluginConfig.hasAttributeNS(null, "authenticationType")) {
            authnType = LdapDataConnector.AUTHENTICATION_TYPE.valueOf(pluginConfig.getAttributeNS(null, "authenticationType"));
        }
        this.log.debug("Data connector {} authentication type: {}", (Object)pluginId, (Object)authnType);
        pluginBuilder.addPropertyValue("authenticationType", (Object)authnType);
        String principal = pluginConfig.getAttributeNS(null, "principal");
        this.log.debug("Data connector {} principal: {}", (Object)pluginId, (Object)principal);
        pluginBuilder.addPropertyValue("principal", (Object)principal);
        String credential = pluginConfig.getAttributeNS(null, "principalCredential");
        pluginBuilder.addPropertyValue("principalCredential", (Object)credential);
        String templateEngineRef = pluginConfig.getAttributeNS(null, "templateEngine");
        pluginBuilder.addPropertyReference("templateEngine", templateEngineRef);
        String filterTemplate = pluginConfigChildren.get(new QName("urn:mace:shibboleth:2.0:resolver:dc", "FilterTemplate")).get(0).getTextContent();
        filterTemplate = DatatypeHelper.safeTrimOrNullString((String)filterTemplate);
        this.log.debug("Data connector {} LDAP filter template: {}", (Object)pluginId, (Object)filterTemplate);
        pluginBuilder.addPropertyValue("filterTemplate", (Object)filterTemplate);
        LdapConfig.SearchScope searchScope = LdapConfig.SearchScope.SUBTREE;
        if (pluginConfig.hasAttributeNS(null, "searchScope")) {
            searchScope = LdapConfig.SearchScope.valueOf((String)pluginConfig.getAttributeNS(null, "searchScope"));
        }
        this.log.debug("Data connector {} search scope: {}", (Object)pluginId, (Object)searchScope);
        pluginBuilder.addPropertyValue("searchScope", (Object)searchScope);
        QName returnAttributesName = new QName("urn:mace:shibboleth:2.0:resolver:dc", "ReturnAttributes");
        if (pluginConfigChildren.containsKey(returnAttributesName)) {
            List returnAttributes = XMLHelper.getElementContentAsList((Element)pluginConfigChildren.get(returnAttributesName).get(0));
            this.log.debug("Data connector {} return attributes: {}", (Object)pluginId, (Object)returnAttributes);
            pluginBuilder.addPropertyValue("returnAttributes", (Object)returnAttributes);
        }
    }

    protected void processSecurityConfig(String pluginId, Element pluginConfig, Map<QName, List<Element>> pluginConfigChildren, BeanDefinitionBuilder pluginBuilder, ParserContext parserContext) {
        RuntimeBeanReference connectionCredential;
        RuntimeBeanReference trustCredential = this.processCredential(pluginConfigChildren.get(new QName("urn:mace:shibboleth:2.0:resolver:dc", "StartTLSTrustCredential")), parserContext);
        if (trustCredential != null) {
            this.log.debug("Data connector {} using provided SSL/TLS trust material", (Object)pluginId);
            pluginBuilder.addPropertyValue("trustCredential", (Object)trustCredential);
        }
        if ((connectionCredential = this.processCredential(pluginConfigChildren.get(new QName("urn:mace:shibboleth:2.0:resolver:dc", "StartTLSAuthenticationCredential")), parserContext)) != null) {
            this.log.debug("Data connector {} using provided SSL/TLS client authentication material", (Object)pluginId);
            pluginBuilder.addPropertyValue("connectionCredential", (Object)connectionCredential);
        }
        boolean useStartTLS = false;
        if (pluginConfig.hasAttributeNS(null, "useStartTLS")) {
            useStartTLS = XMLHelper.getAttributeValueAsBoolean((Attr)pluginConfig.getAttributeNodeNS(null, "useStartTLS"));
        }
        this.log.debug("Data connector {} use startTLS: {}", (Object)pluginId, (Object)useStartTLS);
        pluginBuilder.addPropertyValue("useStartTLS", (Object)useStartTLS);
    }

    protected void processResultHandlingConfig(String pluginId, Element pluginConfig, Map<QName, List<Element>> pluginConfigChildren, BeanDefinitionBuilder pluginBuilder, ParserContext parserContext) {
        int searchTimeLimit = 3000;
        if (pluginConfig.hasAttributeNS(null, "searchTimeLimit")) {
            searchTimeLimit = (int)SpringConfigurationUtils.parseDurationToMillis("'searchTimeLimit' on data connector " + pluginId, pluginConfig.getAttributeNS(null, "searchTimeLimit"), 0);
        }
        this.log.debug("Data connector {} search timeout: {}ms", (Object)pluginId, (Object)searchTimeLimit);
        pluginBuilder.addPropertyValue("searchTimeLimit", (Object)searchTimeLimit);
        int maxResultSize = 1;
        if (pluginConfig.hasAttributeNS(null, "maxResultSize")) {
            maxResultSize = Integer.parseInt(pluginConfig.getAttributeNS(null, "maxResultSize"));
        }
        this.log.debug("Data connector {} max search result size: {}", (Object)pluginId, (Object)maxResultSize);
        pluginBuilder.addPropertyValue("maxResultSize", (Object)maxResultSize);
        boolean mergeResults = false;
        if (pluginConfig.hasAttributeNS(null, "mergeResults")) {
            mergeResults = XMLHelper.getAttributeValueAsBoolean((Attr)pluginConfig.getAttributeNodeNS(null, "mergeResults"));
        }
        this.log.debug("Data connector {} merge results: {}", (Object)pluginId, (Object)mergeResults);
        pluginBuilder.addPropertyValue("mergeResults", (Object)mergeResults);
        boolean noResultsIsError = false;
        if (pluginConfig.hasAttributeNS(null, "noResultIsError")) {
            noResultsIsError = XMLHelper.getAttributeValueAsBoolean((Attr)pluginConfig.getAttributeNodeNS(null, "noResultIsError"));
        }
        this.log.debug("Data connector {} no results is error: {}", (Object)pluginId, (Object)noResultsIsError);
        pluginBuilder.addPropertyValue("noResultsIsError", (Object)noResultsIsError);
        boolean lowercaseAttributeNames = false;
        if (pluginConfig.hasAttributeNS(null, "lowercaseAttributeNames")) {
            lowercaseAttributeNames = XMLHelper.getAttributeValueAsBoolean((Attr)pluginConfig.getAttributeNodeNS(null, "lowercaseAttributeNames"));
        }
        this.log.debug("Data connector {} will lower case attribute IDs: {}", (Object)pluginId, (Object)lowercaseAttributeNames);
        pluginBuilder.addPropertyValue("lowercaseAttributeNames", (Object)lowercaseAttributeNames);
    }

    protected void processPoolingConfig(String pluginId, Element pluginConfig, Map<QName, List<Element>> pluginConfigChildren, BeanDefinitionBuilder pluginBuilder, ParserContext parserContext) {
        List<Element> poolConfigElems = pluginConfigChildren.get(new QName("urn:mace:shibboleth:2.0:resolver:dc", "ConnectionPool"));
        if (poolConfigElems == null || poolConfigElems.size() == 0) {
            this.log.debug("Data connector {} is pooling connections: {}", (Object)pluginId, (Object)false);
            pluginBuilder.addPropertyValue("poolStrategy", (Object)new LdapPoolEmptyStrategy());
            return;
        }
        Element poolConfigElem = poolConfigElems.get(0);
        LdapPoolConfig ldapPoolConfig = new LdapPoolConfig();
        LdapPoolVTStrategy ldapPoolStrategy = new LdapPoolVTStrategy();
        ldapPoolStrategy.setLdapPoolConfig(ldapPoolConfig);
        this.log.debug("Data connector {} is pooling connections: {}", (Object)pluginId, (Object)true);
        pluginBuilder.addPropertyValue("poolStrategy", (Object)ldapPoolStrategy);
        int poolMinSize = 0;
        if (pluginConfig.hasAttributeNS(null, "poolInitialSize")) {
            poolMinSize = Integer.parseInt(pluginConfig.getAttributeNS(null, "poolInitialSize"));
            this.log.warn("Data connector {} using deprecated attribute poolInitialSize on <DataConnector> use minPoolSize on child <PoolConfig> instead");
        } else if (poolConfigElem != null && poolConfigElem.hasAttributeNS(null, "minPoolSize")) {
            poolMinSize = Integer.parseInt(poolConfigElem.getAttributeNS(null, "minPoolSize"));
        }
        this.log.debug("Data connector {} pool minimum connections: {}", (Object)pluginId, (Object)poolMinSize);
        ldapPoolConfig.setMinPoolSize(poolMinSize);
        int poolMaxSize = 3;
        if (pluginConfig.hasAttributeNS(null, "poolMaxIdleSize")) {
            poolMaxSize = Integer.parseInt(pluginConfig.getAttributeNS(null, "poolMaxIdleSize"));
            this.log.warn("Data connector {} using deprecated attribute poolMaxIdleSize on <DataConnector> use maxPoolSize on child <PoolConfig> instead");
        } else if (poolConfigElem != null && poolConfigElem.hasAttributeNS(null, "maxPoolSize")) {
            poolMaxSize = Integer.parseInt(poolConfigElem.getAttributeNS(null, "maxPoolSize"));
        }
        this.log.debug("Data connector {} pool maximum connections: {}", (Object)pluginId, (Object)poolMaxSize);
        ldapPoolConfig.setMaxPoolSize(poolMaxSize);
        boolean blockWhenEmpty = true;
        if (poolConfigElem != null && poolConfigElem.hasAttributeNS(null, "blockWhenEmpty")) {
            blockWhenEmpty = XMLHelper.getAttributeValueAsBoolean((Attr)poolConfigElem.getAttributeNodeNS(null, "blockWhenEmpty"));
        }
        this.log.debug("Data connector {} pool block when empty: {}", (Object)pluginId, (Object)blockWhenEmpty);
        ldapPoolStrategy.setBlockWhenEmpty(blockWhenEmpty);
        boolean poolValidatePeriodically = false;
        if (poolConfigElem != null && poolConfigElem.hasAttributeNS(null, "validatePeriodically")) {
            poolValidatePeriodically = XMLHelper.getAttributeValueAsBoolean((Attr)poolConfigElem.getAttributeNodeNS(null, "validatePeriodically"));
        }
        this.log.debug("Data connector {} pool validate periodically: {}", (Object)pluginId, (Object)poolValidatePeriodically);
        ldapPoolConfig.setValidatePeriodically(poolValidatePeriodically);
        int poolValidateTimerPeriod = 1800000;
        if (poolConfigElem != null && poolConfigElem.hasAttributeNS(null, "validateTimerPeriod")) {
            poolValidateTimerPeriod = (int)SpringConfigurationUtils.parseDurationToMillis("validateTimerPeriod", poolConfigElem.getAttributeNS(null, "validateTimerPeriod"), 0);
        }
        this.log.debug("Data connector {} pool validate timer period: {}ms", (Object)pluginId, (Object)poolValidateTimerPeriod);
        ldapPoolConfig.setValidateTimerPeriod((long)poolValidateTimerPeriod);
        String poolValidateDn = "";
        if (poolConfigElem != null && poolConfigElem.hasAttributeNS(null, "validateDN")) {
            poolValidateDn = poolConfigElem.getAttributeNS(null, "validateDN");
        }
        String poolValidateFilter = "(objectClass=*)";
        if (poolConfigElem != null && poolConfigElem.hasAttributeNS(null, "validateFilter")) {
            poolValidateFilter = poolConfigElem.getAttributeNS(null, "validateFilter");
        }
        CompareLdapValidator poolValidator = new CompareLdapValidator(poolValidateDn, new SearchFilter(poolValidateFilter));
        this.log.debug("Data connector {} pool validation filter: {}", (Object)pluginId, (Object)poolValidateFilter);
        pluginBuilder.addPropertyValue("poolValidator", (Object)poolValidator);
        int poolExpirationTime = 600000;
        if (poolConfigElem != null && poolConfigElem.hasAttributeNS(null, "expirationTime")) {
            poolExpirationTime = (int)SpringConfigurationUtils.parseDurationToMillis("expirationTime", poolConfigElem.getAttributeNS(null, "expirationTime"), 0);
        }
        this.log.debug("Data connector {} pool expiration time: {}ms", (Object)pluginId, (Object)poolExpirationTime);
        ldapPoolConfig.setExpirationTime((long)poolExpirationTime);
    }

    protected void processCacheConfig(String pluginId, Element pluginConfig, BeanDefinitionBuilder pluginBuilder) {
        boolean cacheResults = false;
        String cacheManagerId = "shibboleth.CacheManager";
        long cacheElementTtl = 14400000L;
        int maximumCachedElements = 500;
        List cacheConfigs = XMLHelper.getChildElementsByTagNameNS((Element)pluginConfig, (String)"urn:mace:shibboleth:2.0:resolver:dc", (String)"ResultCache");
        if (cacheConfigs != null && !cacheConfigs.isEmpty()) {
            Element cacheConfig = (Element)cacheConfigs.get(0);
            cacheResults = true;
            if (cacheConfig.hasAttributeNS(null, "cacheManagerRef")) {
                cacheManagerId = DatatypeHelper.safeTrim((String)cacheConfig.getAttributeNS(null, "cacheManagerRef"));
            }
            if (cacheConfig.hasAttributeNS(null, "elementTimeToLive")) {
                cacheElementTtl = SpringConfigurationUtils.parseDurationToMillis("elementTimeToLive on data connector " + pluginId, cacheConfig.getAttributeNS(null, "elementTimeToLive"), 0);
            }
            if (cacheConfig.hasAttributeNS(null, "maximumCachedElements")) {
                maximumCachedElements = Integer.parseInt(DatatypeHelper.safeTrim((String)cacheConfig.getAttributeNS(null, "maximumCachedElements")));
            }
        }
        if (pluginConfig.hasAttributeNS(null, "cacheResults")) {
            this.log.warn("Data connection {}: use of 'cacheResults' attribute is deprecated.  Use <ResultCache> instead.", (Object)pluginId);
            cacheResults = XMLHelper.getAttributeValueAsBoolean((Attr)pluginConfig.getAttributeNodeNS(null, "cacheResults"));
        }
        if (cacheResults) {
            this.log.debug("Data connector {} is caching results: {}", (Object)pluginId, (Object)cacheResults);
            pluginBuilder.addPropertyReference("cacheManager", cacheManagerId);
            this.log.debug("Data connector {} cache element time to live: {}ms", (Object)pluginId, (Object)cacheElementTtl);
            pluginBuilder.addPropertyValue("cacheElementTimeToLive", (Object)cacheElementTtl);
            this.log.debug("Data connector {} maximum number of caches elements: {}", (Object)pluginId, (Object)maximumCachedElements);
            pluginBuilder.addPropertyValue("maximumCachedElements", (Object)maximumCachedElements);
        }
    }

    protected Map<String, String> processLDAPProperties(List<Element> propertyElems) {
        if (propertyElems == null || propertyElems.size() == 0) {
            return null;
        }
        HashMap<String, String> properties = new HashMap<String, String>(5);
        for (Element propertyElem : propertyElems) {
            String propName = DatatypeHelper.safeTrimOrNullString((String)propertyElem.getAttributeNS(null, "name"));
            String propValue = DatatypeHelper.safeTrimOrNullString((String)propertyElem.getAttributeNS(null, "value"));
            properties.put(propName, propValue);
        }
        return properties;
    }

    protected RuntimeBeanReference processCredential(List<Element> credentials, ParserContext parserContext) {
        if (credentials == null) {
            return null;
        }
        Element credentialElem = credentials.get(0);
        return SpringConfigurationUtils.parseCustomElement(credentialElem, parserContext);
    }
}

