/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.config.attribute.resolver.attributeDefinition;

import edu.internet2.middleware.shibboleth.common.config.attribute.resolver.attributeDefinition.BaseAttributeDefinitionBeanDefinitionParser;
import edu.internet2.middleware.shibboleth.common.config.attribute.resolver.attributeDefinition.ScriptedAttributeDefinitionFactoryBean;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptedAttributeDefinitionBeanDefinitionParser
extends BaseAttributeDefinitionBeanDefinitionParser {
    public static final QName TYPE_NAME = new QName("urn:mace:shibboleth:2.0:resolver:ad", "Script");
    private final Logger log = LoggerFactory.getLogger(ScriptedAttributeDefinitionBeanDefinitionParser.class);

    protected Class getBeanClass(Element arg0) {
        return ScriptedAttributeDefinitionFactoryBean.class;
    }

    @Override
    protected void doParse(String pluginId, Element pluginConfig, Map<QName, List<Element>> pluginConfigChildren, BeanDefinitionBuilder pluginBuilder, ParserContext parserContext) {
        super.doParse(pluginId, pluginConfig, pluginConfigChildren, pluginBuilder, parserContext);
        String scriptLanguage = "javascript";
        if (pluginConfig.hasAttributeNS(null, "language")) {
            scriptLanguage = pluginConfig.getAttributeNS(null, "language");
        }
        this.log.debug("Attribute definition {} scripting language: {}", (Object)pluginId, (Object)scriptLanguage);
        pluginBuilder.addPropertyValue("language", (Object)scriptLanguage);
        String script = null;
        List<Element> scriptElem = pluginConfigChildren.get(new QName("urn:mace:shibboleth:2.0:resolver:ad", "Script"));
        if (scriptElem != null && scriptElem.size() > 0) {
            script = scriptElem.get(0).getTextContent();
        } else {
            List<Element> scriptFileElem = pluginConfigChildren.get(new QName("urn:mace:shibboleth:2.0:resolver:ad", "ScriptFile"));
            if (scriptFileElem != null && scriptFileElem.size() > 0) {
                String scriptFile = scriptFileElem.get(0).getTextContent();
                try {
                    script = DatatypeHelper.inputstreamToString((InputStream)new FileInputStream(scriptFile), null);
                }
                catch (IOException e) {
                    throw new BeanCreationException("Unable to read script file " + scriptFile, (Throwable)e);
                }
            }
        }
        if (script == null) {
            throw new BeanCreationException("No script specified for this attribute definition");
        }
        this.log.debug("Attribute definition {} script: {}", (Object)pluginId, (Object)script);
        pluginBuilder.addPropertyValue("script", (Object)script);
    }
}

