/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.config;

import edu.internet2.middleware.shibboleth.common.config.SpringConfigurationUtils;
import edu.internet2.middleware.shibboleth.common.service.Service;
import edu.internet2.middleware.shibboleth.common.service.ServiceException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.opensaml.util.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.GenericApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseService
implements Service,
ApplicationContextAware,
BeanNameAware {
    private final Logger log = LoggerFactory.getLogger(BaseService.class);
    private String serviceName;
    private ReentrantReadWriteLock serviceContextRWLock = new ReentrantReadWriteLock(true);
    private ApplicationContext owningContext;
    private GenericApplicationContext serviceContext;
    private ArrayList<Resource> serviceConfigurations;
    private boolean isInitialized = false;
    private boolean isDestroyed;

    @Override
    public void destroy() throws ServiceException {
        Lock writeLock = this.getReadWriteLock().writeLock();
        writeLock.lock();
        this.isDestroyed = true;
        this.serviceContext = null;
        this.serviceConfigurations.clear();
        this.setInitialized(false);
        writeLock.unlock();
        this.serviceContextRWLock = null;
    }

    public ApplicationContext getApplicationContext() {
        return this.owningContext;
    }

    @Override
    public String getId() {
        return this.serviceName;
    }

    protected ReadWriteLock getReadWriteLock() {
        return this.serviceContextRWLock;
    }

    public List<Resource> getServiceConfigurations() {
        return Collections.unmodifiableList(this.serviceConfigurations);
    }

    public ApplicationContext getServiceContext() {
        return this.serviceContext;
    }

    @Override
    public void initialize() throws ServiceException {
        if (this.isDestroyed()) {
            throw new SecurityException(this.getId() + " service has been destroyed, it may not be initialized.");
        }
        if (this.isInitialized()) {
            return;
        }
        this.loadContext();
    }

    @Override
    public boolean isInitialized() {
        return this.isInitialized;
    }

    @Override
    public boolean isDestroyed() {
        return this.isDestroyed;
    }

    protected void loadContext() throws ServiceException {
        this.log.info("Loading new configuration for service {}", (Object)this.getId());
        if (this.serviceConfigurations == null || this.serviceConfigurations.isEmpty()) {
            this.setInitialized(true);
            return;
        }
        GenericApplicationContext newServiceContext = new GenericApplicationContext(this.getApplicationContext());
        newServiceContext.setDisplayName("ApplicationContext:" + this.getId());
        Lock writeLock = this.getReadWriteLock().writeLock();
        writeLock.lock();
        try {
            SpringConfigurationUtils.populateRegistry((BeanDefinitionRegistry)newServiceContext, this.getServiceConfigurations());
            newServiceContext.refresh();
            GenericApplicationContext replacedServiceContext = this.serviceContext;
            this.onNewContextCreated((ApplicationContext)newServiceContext);
            this.setServiceContext(newServiceContext);
            this.setInitialized(true);
            if (replacedServiceContext != null) {
                replacedServiceContext.close();
            }
            this.log.info("{} service loaded new configuration", (Object)this.getId());
        }
        catch (Exception e) {
            this.setInitialized(false);
            Throwable rootCause = e;
            while (rootCause.getCause() != null) {
                rootCause = rootCause.getCause();
            }
            this.log.error("Configuration was not loaded for " + this.getId() + " service, error creating components.  The root cause of this error was: " + rootCause.getClass().getCanonicalName() + ": " + rootCause.getMessage());
            this.log.trace("Full stacktrace is: ", (Throwable)e);
            throw new ServiceException("Configuration was not loaded for " + this.getId() + " service, error creating components.", (Exception)rootCause);
        }
        finally {
            writeLock.unlock();
        }
    }

    protected abstract void onNewContextCreated(ApplicationContext var1) throws ServiceException;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.owningContext = applicationContext;
    }

    public void setBeanName(String name) {
        this.serviceName = name;
    }

    protected void setInitialized(boolean initialized) {
        this.isInitialized = initialized;
    }

    public void setServiceConfigurations(List<Resource> configurations) {
        if (this.isInitialized) {
            throw new IllegalStateException("Service already initialized");
        }
        this.serviceConfigurations = new ArrayList<Resource>(configurations);
    }

    protected void setServiceContext(GenericApplicationContext context) {
        this.serviceContext = context;
    }
}

