/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoredIDStore {
    private final Logger log = LoggerFactory.getLogger(StoredIDStore.class);
    private DataSource dataSource;
    private int queryTimeout;
    private final String table = "shibpid";
    private final String localEntityColumn = "localEntity";
    private final String peerEntityColumn = "peerEntity";
    private final String principalNameColumn = "principalName";
    private final String localIdColumn = "localId";
    private final String persistentIdColumn = "persistentId";
    private final String peerProvidedIdColumn = "peerProvidedId";
    private final String createTimeColumn = "creationDate";
    private final String deactivationTimeColumn = "deactivationDate";
    private final String idEntrySelectSQL = "SELECT * FROM shibpid WHERE ";
    private final String deactivateIdSQL = "UPDATE shibpid SET deactivationDate= ? WHERE persistentId= ?";

    public StoredIDStore(DataSource source, int timeout) {
        this.dataSource = source;
        this.queryTimeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfPersistentIdEntries(String localEntity, String peerEntity, String localId) throws SQLException {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("SELECT");
        sqlBuilder.append(" count(").append("persistentId").append(")");
        sqlBuilder.append(" FROM ").append("shibpid").append(" WHERE ");
        sqlBuilder.append("localEntity").append(" = ?");
        sqlBuilder.append(" AND ");
        sqlBuilder.append("peerEntity").append(" = ?");
        sqlBuilder.append(" AND ");
        sqlBuilder.append("localId").append(" = ?");
        String sql = sqlBuilder.toString();
        Connection dbConn = this.dataSource.getConnection();
        try {
            this.log.debug("Selecting number of persistent ID entries based on prepared sql statement: {}", (Object)sql);
            PreparedStatement statement = dbConn.prepareStatement(sql);
            statement.setQueryTimeout(this.queryTimeout);
            this.log.debug("Setting prepared statement parameter {}: {}", (Object)1, (Object)localEntity);
            statement.setString(1, localEntity);
            this.log.debug("Setting prepared statement parameter {}: {}", (Object)2, (Object)peerEntity);
            statement.setString(2, peerEntity);
            this.log.debug("Setting prepared statement parameter {}: {}", (Object)3, (Object)localId);
            statement.setString(3, localId);
            ResultSet rs = statement.executeQuery();
            rs.next();
            int n = rs.getInt(1);
            return n;
        }
        finally {
            try {
                if (dbConn != null && !dbConn.isClosed()) {
                    dbConn.close();
                }
            }
            catch (SQLException e) {
                this.log.error("Error closing database connection", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PersistentIdEntry> getPersistentIdEntries(String localEntity, String peerEntity, String localId) throws SQLException {
        StringBuilder sqlBuilder = new StringBuilder("SELECT * FROM shibpid WHERE ");
        sqlBuilder.append("localEntity").append(" = ?");
        sqlBuilder.append(" AND ").append("peerEntity").append(" = ?");
        sqlBuilder.append(" AND ").append("localId").append(" = ?");
        String sql = sqlBuilder.toString();
        this.log.debug("Selecting all persistent ID entries based on prepared sql statement: {}", (Object)sql);
        Connection dbConn = this.dataSource.getConnection();
        try {
            PreparedStatement statement = dbConn.prepareStatement(sql);
            statement.setQueryTimeout(this.queryTimeout);
            this.log.debug("Setting prepared statement parameter {}: {}", (Object)1, (Object)localEntity);
            statement.setString(1, localEntity);
            this.log.debug("Setting prepared statement parameter {}: {}", (Object)2, (Object)peerEntity);
            statement.setString(2, peerEntity);
            this.log.debug("Setting prepared statement parameter {}: {}", (Object)3, (Object)localId);
            statement.setString(3, localId);
            List<PersistentIdEntry> list = this.buildIdentifierEntries(statement.executeQuery());
            return list;
        }
        finally {
            try {
                if (dbConn != null && !dbConn.isClosed()) {
                    dbConn.close();
                }
            }
            catch (SQLException e) {
                this.log.error("Error closing database connection", (Throwable)e);
            }
        }
    }

    public PersistentIdEntry getActivePersistentIdEntry(String persistentId) throws SQLException {
        return this.getPersistentIdEntry(persistentId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistentIdEntry getPersistentIdEntry(String persistentId, boolean onlyActiveId) throws SQLException {
        StringBuilder sqlBuilder = new StringBuilder("SELECT * FROM shibpid WHERE ");
        sqlBuilder.append("persistentId").append(" = ?");
        if (onlyActiveId) {
            sqlBuilder.append(" AND ").append("deactivationDate").append(" IS NULL");
        }
        String sql = sqlBuilder.toString();
        this.log.debug("Selecting persistent ID entry based on prepared sql statement: {}", (Object)sql);
        Connection dbConn = this.dataSource.getConnection();
        try {
            PreparedStatement statement = dbConn.prepareStatement(sql);
            statement.setQueryTimeout(this.queryTimeout);
            this.log.debug("Setting prepared statement parameter {}: {}", (Object)1, (Object)persistentId);
            statement.setString(1, persistentId);
            List<PersistentIdEntry> entries = this.buildIdentifierEntries(statement.executeQuery());
            if (entries == null || entries.size() == 0) {
                PersistentIdEntry persistentIdEntry = null;
                return persistentIdEntry;
            }
            if (entries.size() > 1) {
                this.log.warn("More than one identifier found, only the first will be used");
            }
            PersistentIdEntry persistentIdEntry = entries.get(0);
            return persistentIdEntry;
        }
        finally {
            try {
                if (dbConn != null && !dbConn.isClosed()) {
                    dbConn.close();
                }
            }
            catch (SQLException e) {
                this.log.error("Error closing database connection", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistentIdEntry getActivePersistentIdEntry(String localEntity, String peerEntity, String localId, boolean isActive) throws SQLException {
        StringBuilder sqlBuilder = new StringBuilder("SELECT * FROM shibpid WHERE ");
        sqlBuilder.append("localEntity").append(" = ?");
        sqlBuilder.append(" AND ").append("peerEntity").append(" = ?");
        sqlBuilder.append(" AND ").append("localId").append(" = ?");
        if (isActive) {
            sqlBuilder.append(" AND ").append("deactivationDate").append(" IS NULL");
        } else {
            sqlBuilder.append(" AND ").append("deactivationDate").append(" IS NOT NULL");
        }
        String sql = sqlBuilder.toString();
        this.log.debug("Selecting persistent ID entry based on prepared sql statement: {}", (Object)sql);
        Connection dbConn = this.dataSource.getConnection();
        try {
            PreparedStatement statement = dbConn.prepareStatement(sql);
            statement.setQueryTimeout(this.queryTimeout);
            this.log.debug("Setting prepared statement parameter {}: {}", (Object)1, (Object)localEntity);
            statement.setString(1, localEntity);
            this.log.debug("Setting prepared statement parameter {}: {}", (Object)2, (Object)peerEntity);
            statement.setString(2, peerEntity);
            this.log.debug("Setting prepared statement parameter {}: {}", (Object)3, (Object)localId);
            statement.setString(3, localId);
            this.log.debug("Getting active persistent Id entries.");
            List<PersistentIdEntry> entries = this.buildIdentifierEntries(statement.executeQuery());
            if (entries == null || entries.size() == 0) {
                PersistentIdEntry persistentIdEntry = null;
                return persistentIdEntry;
            }
            if (entries.size() > 1) {
                this.log.warn("More than one active identifier, only the first will be used");
            }
            PersistentIdEntry persistentIdEntry = entries.get(0);
            return persistentIdEntry;
        }
        finally {
            try {
                if (dbConn != null && !dbConn.isClosed()) {
                    dbConn.close();
                }
            }
            catch (SQLException e) {
                this.log.error("Error closing database connection", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistentIdEntry getActivePersistentIdEntry(String localEntity, String peerEntity, String localId) throws SQLException {
        StringBuilder sqlBuilder = new StringBuilder("SELECT * FROM shibpid WHERE ");
        sqlBuilder.append("localEntity").append(" = ?");
        sqlBuilder.append(" AND ").append("peerEntity").append(" = ?");
        sqlBuilder.append(" AND ").append("localId").append(" = ?");
        sqlBuilder.append(" AND ").append("deactivationDate").append(" IS NULL");
        String sql = sqlBuilder.toString();
        this.log.debug("Selecting active persistent ID entry based on prepared sql statement: {}", (Object)sql);
        Connection dbConn = this.dataSource.getConnection();
        try {
            PreparedStatement statement = dbConn.prepareStatement(sql);
            statement.setQueryTimeout(this.queryTimeout);
            this.log.debug("Setting prepared statement parameter {}: {}", (Object)1, (Object)localEntity);
            statement.setString(1, localEntity);
            this.log.debug("Setting prepared statement parameter {}: {}", (Object)2, (Object)peerEntity);
            statement.setString(2, peerEntity);
            this.log.debug("Setting prepared statement parameter {}: {}", (Object)3, (Object)localId);
            statement.setString(3, localId);
            this.log.debug("Getting active persistent Id entries.");
            List<PersistentIdEntry> entries = this.buildIdentifierEntries(statement.executeQuery());
            if (entries == null || entries.size() == 0) {
                PersistentIdEntry persistentIdEntry = null;
                return persistentIdEntry;
            }
            if (entries.size() > 1) {
                this.log.warn("More than one active identifier, only the first will be used");
            }
            PersistentIdEntry persistentIdEntry = entries.get(0);
            return persistentIdEntry;
        }
        finally {
            try {
                if (dbConn != null && !dbConn.isClosed()) {
                    dbConn.close();
                }
            }
            catch (SQLException e) {
                this.log.error("Error closing database connection", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PersistentIdEntry> getDeactivatedPersistentIdEntries(String localEntity, String peerEntity, String localId) throws SQLException {
        StringBuilder sqlBuilder = new StringBuilder("SELECT * FROM shibpid WHERE ");
        sqlBuilder.append("localEntity").append(" = ?");
        sqlBuilder.append(" AND ").append("peerEntity").append(" = ?");
        sqlBuilder.append(" AND ").append("localId").append(" = ?");
        sqlBuilder.append(" AND ").append("deactivationDate").append(" IS NOT NULL");
        String sql = sqlBuilder.toString();
        this.log.debug("Selecting deactivated persistent ID entries based on prepared sql statement: {}", (Object)sql);
        Connection dbConn = this.dataSource.getConnection();
        try {
            PreparedStatement statement = dbConn.prepareStatement(sql);
            statement.setQueryTimeout(this.queryTimeout);
            this.log.debug("Setting prepared statement parameter {}: {}", (Object)1, (Object)localEntity);
            statement.setString(1, localEntity);
            this.log.debug("Setting prepared statement parameter {}: {}", (Object)2, (Object)peerEntity);
            statement.setString(2, peerEntity);
            this.log.debug("Setting prepared statement parameter {}: {}", (Object)3, (Object)localId);
            statement.setString(3, localId);
            this.log.debug("Getting deactivated persistent Id entries");
            List<PersistentIdEntry> entries = this.buildIdentifierEntries(statement.executeQuery());
            if (entries == null || entries.size() == 0) {
                List<PersistentIdEntry> list = null;
                return list;
            }
            List<PersistentIdEntry> list = entries;
            return list;
        }
        finally {
            try {
                if (dbConn != null && !dbConn.isClosed()) {
                    dbConn.close();
                }
            }
            catch (SQLException e) {
                this.log.error("Error closing database connection", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storePersistentIdEntry(PersistentIdEntry entry) throws SQLException {
        StringBuilder sqlBuilder = new StringBuilder("INSERT INTO ");
        sqlBuilder.append("shibpid").append(" (");
        sqlBuilder.append("localEntity").append(", ");
        sqlBuilder.append("peerEntity").append(", ");
        sqlBuilder.append("principalName").append(", ");
        sqlBuilder.append("localId").append(", ");
        sqlBuilder.append("persistentId").append(", ");
        sqlBuilder.append("peerProvidedId").append(", ");
        sqlBuilder.append("creationDate");
        sqlBuilder.append(") VALUES (?, ?, ?, ?, ?, ?, ?)");
        String sql = sqlBuilder.toString();
        Connection dbConn = this.dataSource.getConnection();
        try {
            this.log.debug("Storing persistent ID entry based on prepared sql statement: {}", (Object)sql);
            PreparedStatement statement = dbConn.prepareStatement(sql);
            statement.setQueryTimeout(this.queryTimeout);
            this.log.debug("Setting prepared statement parameter {}: {}", (Object)1, (Object)entry.getLocalEntityId());
            statement.setString(1, entry.getLocalEntityId());
            this.log.debug("Setting prepared statement parameter {}: {}", (Object)2, (Object)entry.getPeerEntityId());
            statement.setString(2, entry.getPeerEntityId());
            this.log.debug("Setting prepared statement parameter {}: {}", (Object)3, (Object)entry.getPrincipalName());
            statement.setString(3, entry.getPrincipalName());
            this.log.debug("Setting prepared statement parameter {}: {}", (Object)4, (Object)entry.getLocalId());
            statement.setString(4, entry.getLocalId());
            this.log.debug("Setting prepared statement parameter {}: {}", (Object)5, (Object)entry.getPersistentId());
            statement.setString(5, entry.getPersistentId());
            if (entry.getPeerProvidedId() == null) {
                this.log.debug("Setting prepared statement parameter {}: {}", (Object)6, (Object)12);
                statement.setNull(6, 12);
            } else {
                this.log.debug("Setting prepared statement parameter {}: {}", (Object)6, (Object)entry.getPeerProvidedId());
                statement.setString(6, entry.getPeerProvidedId());
            }
            Timestamp timestamp = new Timestamp(System.currentTimeMillis());
            this.log.debug("Setting prepared statement parameter {}: {}", (Object)7, (Object)timestamp.toString());
            statement.setTimestamp(7, timestamp);
            statement.executeUpdate();
        }
        finally {
            try {
                if (dbConn != null && !dbConn.isClosed()) {
                    dbConn.close();
                }
            }
            catch (SQLException e) {
                this.log.error("Error closing database connection", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivatePersistentId(String persistentId, Timestamp deactivation) throws SQLException {
        Timestamp deactivationTime = deactivation;
        if (deactivationTime == null) {
            deactivationTime = new Timestamp(System.currentTimeMillis());
        }
        Connection dbConn = this.dataSource.getConnection();
        try {
            this.log.debug("Deactivating persistent id {} as of {}", (Object)persistentId, (Object)deactivationTime.toString());
            PreparedStatement statement = dbConn.prepareStatement("UPDATE shibpid SET deactivationDate= ? WHERE persistentId= ?");
            statement.setQueryTimeout(this.queryTimeout);
            statement.setTimestamp(1, deactivationTime);
            statement.setString(2, persistentId);
            statement.executeUpdate();
        }
        finally {
            try {
                if (dbConn != null && !dbConn.isClosed()) {
                    dbConn.close();
                }
            }
            catch (SQLException e) {
                this.log.error("Error closing database connection", (Throwable)e);
            }
        }
    }

    protected List<PersistentIdEntry> buildIdentifierEntries(ResultSet resultSet) throws SQLException {
        ArrayList<PersistentIdEntry> entries = new ArrayList<PersistentIdEntry>();
        while (resultSet.next()) {
            PersistentIdEntry entry = new PersistentIdEntry();
            entry.setLocalEntityId(resultSet.getString("localEntity"));
            entry.setPeerEntityId(resultSet.getString("peerEntity"));
            entry.setPrincipalName(resultSet.getString("principalName"));
            entry.setPersistentId(resultSet.getString("persistentId"));
            entry.setLocalId(resultSet.getString("localId"));
            entry.setPeerProvidedId(resultSet.getString("peerProvidedId"));
            entry.setCreationTime(resultSet.getTimestamp("creationDate"));
            entry.setDeactivationTime(resultSet.getTimestamp("deactivationDate"));
            entries.add(entry);
            this.log.trace("");
        }
        return entries;
    }

    public class PersistentIdEntry
    implements Serializable {
        private static final long serialVersionUID = -8711779466442306767L;
        private String localEntityId;
        private String peerEntityId;
        private String principalName;
        private String localId;
        private String persistentId;
        private String peerProvidedId;
        private Timestamp creationTime;
        private Timestamp deactivationTime;

        public String getLocalEntityId() {
            return this.localEntityId;
        }

        public void setLocalEntityId(String id) {
            this.localEntityId = id;
        }

        public String getPeerEntityId() {
            return this.peerEntityId;
        }

        public void setPeerEntityId(String id) {
            this.peerEntityId = id;
        }

        public String getPrincipalName() {
            return this.principalName;
        }

        public void setPrincipalName(String name) {
            this.principalName = name;
        }

        public String getLocalId() {
            return this.localId;
        }

        public void setLocalId(String id) {
            this.localId = id;
        }

        public String getPersistentId() {
            return this.persistentId;
        }

        public void setPersistentId(String id) {
            this.persistentId = id;
        }

        public String getPeerProvidedId() {
            return this.peerProvidedId;
        }

        public void setPeerProvidedId(String id) {
            this.peerProvidedId = id;
        }

        public Timestamp getCreationTime() {
            return this.creationTime;
        }

        public void setCreationTime(Timestamp time) {
            this.creationTime = time;
        }

        public Timestamp getDeactivationTime() {
            return this.deactivationTime;
        }

        public void setDeactivationTime(Timestamp time) {
            this.deactivationTime = time;
        }

        public String toString() {
            StringBuilder stringForm = new StringBuilder("PersistentIdEntry{");
            stringForm.append("persistentId:").append(this.persistentId).append(", ");
            stringForm.append("localEntityId:").append(this.localEntityId).append(", ");
            stringForm.append("peerEntityId:").append(this.peerEntityId).append(", ");
            stringForm.append("localId:").append(this.localId).append(", ");
            stringForm.append("principalName:").append(this.principalName).append(", ");
            stringForm.append("peerProvidedId:").append(this.peerProvidedId).append(", ");
            stringForm.append("creationTime:").append(this.creationTime).append(", ");
            stringForm.append("deactivationTime:").append(this.deactivationTime).append(", ");
            stringForm.append("}");
            return stringForm.toString();
        }
    }
}

