/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.schema.validator;

import org.opensaml.xml.schema.XSString;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.validation.ValidationException;
import org.opensaml.xml.validation.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSStringSchemaValidator<T extends XSString>
implements Validator<T> {
    private boolean allowEmptyContent;

    public XSStringSchemaValidator(boolean allowEmptyElementContent) {
        this.allowEmptyContent = allowEmptyElementContent;
    }

    public XSStringSchemaValidator() {
        this.allowEmptyContent = false;
    }

    @Override
    public void validate(T xmlObject) throws ValidationException {
        this.validateStringContent(xmlObject);
    }

    protected boolean isAllowEmptyContent() {
        return this.allowEmptyContent;
    }

    protected void validateStringContent(T xmlObject) throws ValidationException {
        if (!this.isAllowEmptyContent() && DatatypeHelper.isEmpty(xmlObject.getValue())) {
            throw new ValidationException("String content may not be empty");
        }
    }
}

