/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.idp.profile.saml2;

import edu.internet2.middleware.shibboleth.common.profile.ProfileException;
import edu.internet2.middleware.shibboleth.common.profile.provider.BaseSAMLProfileRequestContext;
import edu.internet2.middleware.shibboleth.common.relyingparty.provider.saml2.ArtifactResolutionConfiguration;
import edu.internet2.middleware.shibboleth.idp.profile.saml2.AbstractSAML2ProfileHandler;
import edu.internet2.middleware.shibboleth.idp.profile.saml2.BaseSAML2ProfileRequestContext;
import java.text.MessageFormat;
import org.joda.time.DateTime;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.SAMLObjectBuilder;
import org.opensaml.common.binding.BasicEndpointSelector;
import org.opensaml.common.binding.artifact.SAMLArtifactMap;
import org.opensaml.common.binding.decoding.SAMLMessageDecoder;
import org.opensaml.saml2.binding.SAML2ArtifactMessageContext;
import org.opensaml.saml2.core.ArtifactResolve;
import org.opensaml.saml2.core.ArtifactResponse;
import org.opensaml.saml2.core.NameID;
import org.opensaml.saml2.core.Status;
import org.opensaml.saml2.core.StatusResponseType;
import org.opensaml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml2.metadata.AttributeAuthorityDescriptor;
import org.opensaml.saml2.metadata.Endpoint;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.message.decoder.MessageDecodingException;
import org.opensaml.ws.transport.InTransport;
import org.opensaml.ws.transport.OutTransport;
import org.opensaml.ws.transport.http.HTTPInTransport;
import org.opensaml.ws.transport.http.HTTPOutTransport;
import org.opensaml.xml.security.SecurityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactResolution
extends AbstractSAML2ProfileHandler {
    private final Logger log = LoggerFactory.getLogger(ArtifactResolution.class);
    private SAMLArtifactMap artifactMap;
    private SAMLObjectBuilder<ArtifactResponse> responseBuilder;
    private SAMLObjectBuilder<AssertionConsumerService> acsEndpointBuilder;

    public ArtifactResolution(SAMLArtifactMap map) {
        this.artifactMap = map;
        this.responseBuilder = (SAMLObjectBuilder)this.getBuilderFactory().getBuilder(ArtifactResponse.DEFAULT_ELEMENT_NAME);
        this.acsEndpointBuilder = (SAMLObjectBuilder)this.getBuilderFactory().getBuilder(AssertionConsumerService.DEFAULT_ELEMENT_NAME);
    }

    public String getProfileId() {
        return "urn:mace:shibboleth:2.0:profiles:saml2:query:artifact";
    }

    public void processRequest(HTTPInTransport inTransport, HTTPOutTransport outTransport) throws ProfileException {
        ArtifactResponse samlResponse;
        ArtifactResolutionRequestContext requestContext = new ArtifactResolutionRequestContext();
        try {
            String msg;
            this.decodeRequest(requestContext, inTransport, outTransport);
            if (requestContext.getProfileConfiguration() == null) {
                String msg2 = MessageFormat.format("SAML 2 Artifact Resolve profile is not configured for relying party '{}'", requestContext.getInboundMessageIssuer());
                requestContext.setFailureStatus(this.buildStatus("urn:oasis:names:tc:SAML:2.0:status:Success", "urn:oasis:names:tc:SAML:2.0:status:RequestDenied", msg2));
                this.log.warn(msg2);
                throw new ProfileException(msg2);
            }
            this.checkSamlVersion(requestContext);
            SAMLArtifactMap.SAMLArtifactMapEntry artifactEntry = this.artifactMap.get(requestContext.getArtifact());
            if (artifactEntry == null || artifactEntry.isExpired()) {
                msg = MessageFormat.format("Unknown artifact '{}' from relying party '{}'", requestContext.getArtifact(), requestContext.getInboundMessageIssuer());
                this.log.error(msg);
                requestContext.setFailureStatus(this.buildStatus("urn:oasis:names:tc:SAML:2.0:status:Success", "urn:oasis:names:tc:SAML:2.0:status:RequestDenied", msg));
            }
            if (!artifactEntry.getIssuerId().equals(requestContext.getLocalEntityId())) {
                msg = MessageFormat.format("Artifact issuer mismatch.  Artifact issued by '{}' but IdP has entity ID of '{}'", artifactEntry.getIssuerId(), requestContext.getLocalEntityId());
                this.log.warn(msg);
                requestContext.setFailureStatus(this.buildStatus("urn:oasis:names:tc:SAML:2.0:status:Success", "urn:oasis:names:tc:SAML:2.0:status:RequestDenied", msg));
                return;
            }
            if (!artifactEntry.getRelyingPartyId().equals(requestContext.getInboundMessageIssuer())) {
                msg = MessageFormat.format("Artifact requester mismatch. Artifact was issued to '{}' but the resolve request came from '{}'", artifactEntry.getRelyingPartyId(), requestContext.getInboundMessageIssuer());
                this.log.warn(msg);
                requestContext.setFailureStatus(this.buildStatus("urn:oasis:names:tc:SAML:2.0:status:Success", "urn:oasis:names:tc:SAML:2.0:status:RequestDenied", msg));
                return;
            }
            requestContext.setReferencedMessage(artifactEntry.getSamlMessage());
            samlResponse = this.buildArtifactResponse(requestContext);
        }
        catch (ProfileException e) {
            samlResponse = this.buildArtifactErrorResponse(requestContext);
        }
        requestContext.setOutboundSAMLMessage((SAMLObject)samlResponse);
        requestContext.setOutboundSAMLMessageId(samlResponse.getID());
        requestContext.setOutboundSAMLMessageIssueInstant(samlResponse.getIssueInstant());
        this.encodeResponse(requestContext);
        this.writeAuditLogEntry(requestContext);
    }

    protected void decodeRequest(ArtifactResolutionRequestContext requestContext, HTTPInTransport inTransport, HTTPOutTransport outTransport) throws ProfileException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Decoding message with decoder binding '{}'", (Object)this.getInboundMessageDecoder(requestContext).getBindingURI());
        }
        requestContext.setCommunicationProfileId(this.getProfileId());
        MetadataProvider metadataProvider = this.getMetadataProvider();
        requestContext.setMetadataProvider(metadataProvider);
        requestContext.setInboundMessageTransport((InTransport)inTransport);
        requestContext.setInboundSAMLProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        requestContext.setSecurityPolicyResolver(this.getSecurityPolicyResolver());
        requestContext.setPeerEntityRole(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        requestContext.setOutboundMessageTransport((OutTransport)outTransport);
        requestContext.setOutboundSAMLProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        try {
            try {
                SAMLMessageDecoder decoder = this.getInboundMessageDecoder(requestContext);
                requestContext.setMessageDecoder(decoder);
                decoder.decode((MessageContext)requestContext);
                this.log.debug("Decoded request from relying party '{}'", (Object)requestContext.getInboundMessageIssuer());
            }
            catch (MessageDecodingException e) {
                String msg = "Error decoding artifact resolve message";
                requestContext.setFailureStatus(this.buildStatus("urn:oasis:names:tc:SAML:2.0:status:Responder", null, msg));
                this.log.warn(msg, (Throwable)e);
                throw new ProfileException(msg);
            }
            catch (SecurityException e) {
                String msg = "Message did not meet security requirements";
                requestContext.setFailureStatus(this.buildStatus("urn:oasis:names:tc:SAML:2.0:status:Responder", "urn:oasis:names:tc:SAML:2.0:status:RequestDenied", msg));
                this.log.warn(msg, (Throwable)e);
                throw new ProfileException(msg, (Exception)((Object)e));
            }
        }
        finally {
            this.populateRequestContext(requestContext);
        }
    }

    protected void populateRelyingPartyInformation(BaseSAMLProfileRequestContext requestContext) throws ProfileException {
        super.populateRelyingPartyInformation(requestContext);
        EntityDescriptor relyingPartyMetadata = requestContext.getPeerEntityMetadata();
        if (relyingPartyMetadata != null) {
            requestContext.setPeerEntityRole(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
            requestContext.setPeerEntityRoleMetadata((RoleDescriptor)relyingPartyMetadata.getSPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol"));
        }
    }

    protected void populateAssertingPartyInformation(BaseSAMLProfileRequestContext requestContext) throws ProfileException {
        super.populateAssertingPartyInformation(requestContext);
        EntityDescriptor localEntityDescriptor = requestContext.getLocalEntityMetadata();
        if (localEntityDescriptor != null) {
            requestContext.setLocalEntityRole(AttributeAuthorityDescriptor.DEFAULT_ELEMENT_NAME);
            requestContext.setLocalEntityRoleMetadata((RoleDescriptor)localEntityDescriptor.getAttributeAuthorityDescriptor("urn:oasis:names:tc:SAML:2.0:protocol"));
        }
    }

    protected void populateSAMLMessageInformation(BaseSAMLProfileRequestContext requestContext) throws ProfileException {
        ArtifactResolve samlMessage = (ArtifactResolve)requestContext.getInboundSAMLMessage();
        if (samlMessage != null && samlMessage.getArtifact() != null) {
            ((ArtifactResolutionRequestContext)requestContext).setArtifact(samlMessage.getArtifact().getArtifact());
        }
    }

    protected Endpoint selectEndpoint(BaseSAMLProfileRequestContext requestContext) {
        Endpoint endpoint;
        if (this.getInboundBinding().equals("urn:oasis:names:tc:SAML:2.0:bindings:SOAP")) {
            endpoint = (Endpoint)this.acsEndpointBuilder.buildObject();
            endpoint.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:SOAP");
        } else {
            BasicEndpointSelector endpointSelector = new BasicEndpointSelector();
            endpointSelector.setEndpointType(AssertionConsumerService.DEFAULT_ELEMENT_NAME);
            endpointSelector.setMetadataProvider(this.getMetadataProvider());
            endpointSelector.setEntityMetadata(requestContext.getPeerEntityMetadata());
            endpointSelector.setEntityRoleMetadata(requestContext.getPeerEntityRoleMetadata());
            endpointSelector.setSamlRequest(requestContext.getInboundSAMLMessage());
            endpointSelector.getSupportedIssuerBindings().addAll(this.getSupportedOutboundBindings());
            endpoint = endpointSelector.selectEndpoint();
        }
        return endpoint;
    }

    protected ArtifactResponse buildArtifactResponse(ArtifactResolutionRequestContext requestContext) {
        DateTime issueInstant = new DateTime();
        ArtifactResponse samlResponse = (ArtifactResponse)this.responseBuilder.buildObject();
        samlResponse.setIssueInstant(issueInstant);
        this.populateStatusResponse(requestContext, (StatusResponseType)samlResponse);
        if (requestContext.getFailureStatus() == null) {
            Status status = this.buildStatus("urn:oasis:names:tc:SAML:2.0:status:Success", null, null);
            samlResponse.setStatus(status);
            samlResponse.setMessage(requestContext.getReferencedMessage());
        } else {
            samlResponse.setStatus(requestContext.getFailureStatus());
        }
        return samlResponse;
    }

    protected ArtifactResponse buildArtifactErrorResponse(ArtifactResolutionRequestContext requestContext) {
        ArtifactResponse samlResponse = (ArtifactResponse)this.responseBuilder.buildObject();
        samlResponse.setIssueInstant(new DateTime());
        this.populateStatusResponse(requestContext, (StatusResponseType)samlResponse);
        samlResponse.setStatus(requestContext.getFailureStatus());
        return samlResponse;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ArtifactResolutionRequestContext
    extends BaseSAML2ProfileRequestContext<ArtifactResolve, ArtifactResponse, ArtifactResolutionConfiguration>
    implements SAML2ArtifactMessageContext<ArtifactResolve, ArtifactResponse, NameID> {
        private String artifact;
        private SAMLObject referencedMessage;

        public String getArtifact() {
            return this.artifact;
        }

        public void setArtifact(String saml2Artifact) {
            this.artifact = saml2Artifact;
        }

        public SAMLObject getReferencedMessage() {
            return this.referencedMessage;
        }

        public void setReferencedMessage(SAMLObject message) {
            this.referencedMessage = message;
        }
    }
}

