/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.idp.authn.provider;

import edu.internet2.middleware.shibboleth.idp.authn.AuthenticationEngine;
import edu.internet2.middleware.shibboleth.idp.authn.UsernamePrincipal;
import edu.internet2.middleware.shibboleth.idp.authn.provider.UsernamePasswordCredential;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UsernamePasswordLoginServlet
extends HttpServlet {
    private static final long serialVersionUID = -572799841125956990L;
    private final Logger log = LoggerFactory.getLogger(UsernamePasswordLoginServlet.class);
    private String jaasConfigName = "ShibUserPassAuth";
    private final String jaasInitParam = "jaasConfigName";
    private String loginPage = "login.jsp";
    private final String loginPageInitParam = "loginPage";
    private final String failureParam = "loginFailed";
    private final String usernameAttribute = "j_username";
    private final String passwordAttribute = "j_password";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (this.getInitParameter("jaasConfigName") != null) {
            this.jaasConfigName = this.getInitParameter("jaasConfigName");
        }
        if (this.getInitParameter("loginPage") != null) {
            this.loginPage = this.getInitParameter("loginPage");
        }
        if (!this.loginPage.startsWith("/")) {
            this.loginPage = "/" + this.loginPage;
        }
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String username = request.getParameter("j_username");
        String password = request.getParameter("j_password");
        if (username == null || password == null) {
            this.redirectToLoginPage(request, response, null);
            return;
        }
        if (this.authenticateUser(request, username, password)) {
            AuthenticationEngine.returnToAuthenticationEngine(request, response);
        } else {
            ArrayList<Pair<String, String>> queryParams = new ArrayList<Pair<String, String>>();
            queryParams.add(new Pair((Object)"loginFailed", (Object)"true"));
            this.redirectToLoginPage(request, response, queryParams);
        }
    }

    protected void redirectToLoginPage(HttpServletRequest request, HttpServletResponse response, List<Pair<String, String>> queryParams) {
        String requestContext = DatatypeHelper.safeTrimOrNullString((String)request.getContextPath());
        if (requestContext == null) {
            requestContext = "/";
        }
        request.setAttribute("actionUrl", (Object)(String.valueOf(requestContext) + request.getServletPath()));
        if (queryParams != null) {
            for (Pair<String, String> param : queryParams) {
                request.setAttribute((String)param.getFirst(), param.getSecond());
            }
        }
        try {
            request.getRequestDispatcher(this.loginPage).forward((ServletRequest)request, (ServletResponse)response);
            this.log.debug("Redirecting to login page {}", (Object)this.loginPage);
        }
        catch (IOException ex) {
            this.log.error("Unable to redirect to login page.", (Throwable)ex);
        }
        catch (ServletException ex) {
            this.log.error("Unable to redirect to login page.", (Throwable)ex);
        }
    }

    protected boolean authenticateUser(HttpServletRequest request, String username, String password) {
        try {
            this.log.debug("Attempting to authenticate user {}", (Object)username);
            SimpleCallbackHandler cbh = new SimpleCallbackHandler(username, password);
            LoginContext jaasLoginCtx = new LoginContext(this.jaasConfigName, cbh);
            jaasLoginCtx.login();
            this.log.debug("Successfully authenticated user {}", (Object)username);
            Subject loginSubject = jaasLoginCtx.getSubject();
            Set<Principal> principals = loginSubject.getPrincipals();
            if (principals.isEmpty()) {
                principals.add(new UsernamePrincipal(username));
            }
            Set<Object> publicCredentials = loginSubject.getPublicCredentials();
            Set<Object> privateCredentials = loginSubject.getPrivateCredentials();
            privateCredentials.add(new UsernamePasswordCredential(username, password));
            Subject userSubject = new Subject(false, principals, publicCredentials, privateCredentials);
            request.setAttribute("subject", (Object)userSubject);
            return true;
        }
        catch (Throwable e) {
            this.log.debug("User authentication for " + username + " failed", e);
            return false;
        }
    }

    protected class SimpleCallbackHandler
    implements CallbackHandler {
        private String uname;
        private String pass;

        public SimpleCallbackHandler(String username, String password) {
            this.uname = username;
            this.pass = password;
        }

        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            if (callbacks == null || callbacks.length == 0) {
                return;
            }
            Callback[] callbackArray = callbacks;
            int n = callbacks.length;
            int n2 = 0;
            while (n2 < n) {
                Callback cb = callbackArray[n2];
                if (cb instanceof NameCallback) {
                    NameCallback ncb = (NameCallback)cb;
                    ncb.setName(this.uname);
                } else if (cb instanceof PasswordCallback) {
                    PasswordCallback pcb = (PasswordCallback)cb;
                    pcb.setPassword(this.pass.toCharArray());
                }
                ++n2;
            }
        }
    }
}

