/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.idp.authn.provider;

import edu.internet2.middleware.shibboleth.idp.authn.provider.AbstractLoginHandler;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opensaml.util.URLBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsernamePasswordLoginHandler
extends AbstractLoginHandler {
    private final Logger log = LoggerFactory.getLogger(UsernamePasswordLoginHandler.class);
    private String authenticationServletURL;

    public UsernamePasswordLoginHandler(String servletURL) {
        this.setSupportsPassive(false);
        this.setSupportsForceAuthentication(true);
        this.authenticationServletURL = servletURL;
    }

    public void login(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        try {
            StringBuilder pathBuilder = new StringBuilder();
            pathBuilder.append(httpRequest.getContextPath());
            if (!this.authenticationServletURL.startsWith("/")) {
                pathBuilder.append("/");
            }
            pathBuilder.append(this.authenticationServletURL);
            URLBuilder urlBuilder = new URLBuilder();
            urlBuilder.setScheme(httpRequest.getScheme());
            urlBuilder.setHost(httpRequest.getServerName());
            urlBuilder.setPort(httpRequest.getServerPort());
            urlBuilder.setPath(pathBuilder.toString());
            this.log.debug("Redirecting to {}", (Object)urlBuilder.buildURL());
            httpResponse.sendRedirect(urlBuilder.buildURL());
            return;
        }
        catch (IOException ex) {
            this.log.error("Unable to redirect to authentication servlet.", (Throwable)ex);
            return;
        }
    }
}

