/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.config.attribute.resolver.dataConnector;

import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector.LdapDataConnector;
import edu.internet2.middleware.shibboleth.common.config.SpringConfigurationUtils;
import edu.internet2.middleware.shibboleth.common.config.attribute.resolver.dataConnector.BaseDataConnectorBeanDefinitionParser;
import edu.internet2.middleware.shibboleth.common.config.attribute.resolver.dataConnector.LdapDataConnectorFactoryBean;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapDataConnectorBeanDefinitionParser
extends BaseDataConnectorBeanDefinitionParser {
    public static final QName TYPE_NAME = new QName("urn:mace:shibboleth:2.0:resolver:dc", "LDAPDirectory");
    private final Logger log = LoggerFactory.getLogger(LdapDataConnectorBeanDefinitionParser.class);

    protected Class getBeanClass(Element element) {
        return LdapDataConnectorFactoryBean.class;
    }

    @Override
    protected void doParse(String pluginId, Element pluginConfig, Map<QName, List<Element>> pluginConfigChildren, BeanDefinitionBuilder pluginBuilder, ParserContext parserContext) {
        super.doParse(pluginId, pluginConfig, pluginConfigChildren, pluginBuilder, parserContext);
        String ldapURL = pluginConfig.getAttributeNS(null, "ldapURL");
        this.log.debug("Data connector {} LDAP URL: {}", (Object)pluginId, (Object)ldapURL);
        pluginBuilder.addPropertyValue("ldapUrl", (Object)ldapURL);
        String baseDN = pluginConfig.getAttributeNS(null, "baseDN");
        this.log.debug("Data connector {} base DN: {}", (Object)pluginId, (Object)baseDN);
        pluginBuilder.addPropertyValue("baseDN", (Object)baseDN);
        LdapDataConnector.AUTHENTICATION_TYPE authnType = LdapDataConnector.AUTHENTICATION_TYPE.SIMPLE;
        if (pluginConfig.hasAttributeNS(null, "authenticationType")) {
            authnType = LdapDataConnector.AUTHENTICATION_TYPE.valueOf(pluginConfig.getAttributeNS(null, "authenticationType"));
        }
        this.log.debug("Data connector {} authentication type: {}", (Object)pluginId, (Object)authnType);
        pluginBuilder.addPropertyValue("authenticationType", (Object)authnType);
        String principal = pluginConfig.getAttributeNS(null, "principal");
        this.log.debug("Data connector {} principal: {}", (Object)pluginId, (Object)principal);
        pluginBuilder.addPropertyValue("principal", (Object)principal);
        String credential = pluginConfig.getAttributeNS(null, "principalCredential");
        pluginBuilder.addPropertyValue("principalCredential", (Object)credential);
        String filterTemplate = pluginConfigChildren.get(new QName("urn:mace:shibboleth:2.0:resolver:dc", "FilterTemplate")).get(0).getTextContent();
        filterTemplate = DatatypeHelper.safeTrimOrNullString((String)filterTemplate);
        this.log.debug("Data connector {} LDAP filter template: {}", (Object)pluginId, (Object)filterTemplate);
        pluginBuilder.addPropertyValue("filterTemplate", (Object)filterTemplate);
        LdapDataConnector.SEARCH_SCOPE searchScope = LdapDataConnector.SEARCH_SCOPE.SUBTREE;
        if (pluginConfig.hasAttributeNS(null, "searchScope")) {
            searchScope = LdapDataConnector.SEARCH_SCOPE.valueOf(pluginConfig.getAttributeNS(null, "searchScope"));
        }
        this.log.debug("Data connector {} search scope: {}", (Object)pluginId, (Object)searchScope);
        pluginBuilder.addPropertyValue("searchScope", (Object)searchScope);
        String[] returnAttributes = this.processReturnAttributes(pluginConfigChildren.get(new QName("urn:mace:shibboleth:2.0:resolver:dc", "ReturnAttributes")));
        this.log.debug("Data connector {} return attributes: {}", (Object)pluginId, (Object)returnAttributes);
        pluginBuilder.addPropertyValue("returnAttributes", (Object)returnAttributes);
        Map<String, String> ldapProperties = this.processLDAPProperties(pluginConfigChildren.get(new QName("urn:mace:shibboleth:2.0:resolver:dc", "LDAPProperty")));
        this.log.debug("Data connector {} LDAP properties: {}", (Object)pluginId, ldapProperties);
        pluginBuilder.addPropertyValue("ldapProperties", ldapProperties);
        RuntimeBeanReference trustCredential = this.processCredential(pluginConfigChildren.get(new QName("urn:mace:shibboleth:2.0:resolver:dc", "StartTLSTrustCredential")), parserContext);
        this.log.debug("Data connector {} using provided SSL/TLS trust material", (Object)pluginId);
        pluginBuilder.addPropertyValue("trustCredential", (Object)trustCredential);
        RuntimeBeanReference connectionCredential = this.processCredential(pluginConfigChildren.get(new QName("urn:mace:shibboleth:2.0:resolver:dc", "StartTLSAuthenticationCredential")), parserContext);
        this.log.debug("Data connector {} using provided SSL/TLS client authentication material", (Object)pluginId);
        pluginBuilder.addPropertyValue("connectionCredential", (Object)connectionCredential);
        boolean useStartTLS = false;
        if (pluginConfig.hasAttributeNS(null, "useStartTLS")) {
            useStartTLS = XMLHelper.getAttributeValueAsBoolean((Attr)pluginConfig.getAttributeNodeNS(null, "useStartTLS"));
        }
        this.log.debug("Data connector {} use startTLS: {}", (Object)pluginId, (Object)useStartTLS);
        pluginBuilder.addPropertyValue("useStartTLS", (Object)useStartTLS);
        int poolInitialSize = 0;
        if (pluginConfig.hasAttributeNS(null, "poolInitialSize")) {
            poolInitialSize = Integer.parseInt(pluginConfig.getAttributeNS(null, "poolInitialSize"));
        }
        this.log.debug("Data connector {} initial connection pool size: {}", (Object)pluginId, (Object)poolInitialSize);
        pluginBuilder.addPropertyValue("poolInitialSize", (Object)poolInitialSize);
        int poolMaxIdleSize = 3;
        if (pluginConfig.hasAttributeNS(null, "poolMaxIdleSize")) {
            poolMaxIdleSize = Integer.parseInt(pluginConfig.getAttributeNS(null, "poolMaxIdleSize"));
        }
        this.log.debug("Data connector {} maximum idle connection pool size: {}", (Object)pluginId, (Object)poolMaxIdleSize);
        pluginBuilder.addPropertyValue("poolMaxIdleSize", (Object)poolMaxIdleSize);
        int searchTimeLimit = 3000;
        if (pluginConfig.hasAttributeNS(null, "searchTimeLimit")) {
            searchTimeLimit = Integer.parseInt(pluginConfig.getAttributeNS(null, "searchTimeLimit"));
        }
        this.log.debug("Data connector {} search timeout: {}ms", (Object)pluginId, (Object)searchTimeLimit);
        pluginBuilder.addPropertyValue("searchTimeLimit", (Object)searchTimeLimit);
        int maxResultSize = 1;
        if (pluginConfig.hasAttributeNS(null, "maxResultSize")) {
            maxResultSize = Integer.parseInt(pluginConfig.getAttributeNS(null, "maxResultSize"));
        }
        this.log.debug("Data connector {} max search result size: {}", (Object)pluginId, (Object)maxResultSize);
        pluginBuilder.addPropertyValue("maxResultSize", (Object)maxResultSize);
        boolean cacheResults = false;
        if (pluginConfig.hasAttributeNS(null, "cacheResults")) {
            cacheResults = XMLHelper.getAttributeValueAsBoolean((Attr)pluginConfig.getAttributeNodeNS(null, "cacheResults"));
        }
        this.log.debug("Data connector {} cache results: {}", (Object)pluginId, (Object)cacheResults);
        pluginBuilder.addPropertyValue("cacheResults", (Object)cacheResults);
        boolean mergeResults = false;
        if (pluginConfig.hasAttributeNS(null, "mergeResults")) {
            mergeResults = XMLHelper.getAttributeValueAsBoolean((Attr)pluginConfig.getAttributeNodeNS(null, "mergeResults"));
        }
        this.log.debug("Data connector{} merge results: {}", (Object)pluginId, (Object)mergeResults);
        pluginBuilder.addPropertyValue("mergeResults", (Object)mergeResults);
        boolean noResultsIsError = false;
        if (pluginConfig.hasAttributeNS(null, "noResultIsError")) {
            noResultsIsError = XMLHelper.getAttributeValueAsBoolean((Attr)pluginConfig.getAttributeNodeNS(null, "noResultIsError"));
        }
        this.log.debug("Data connector {} no results is error: {}", (Object)pluginId, (Object)noResultsIsError);
        pluginBuilder.addPropertyValue("noResultsIsError", (Object)noResultsIsError);
        String templateEngineRef = pluginConfig.getAttributeNS(null, "templateEngine");
        pluginBuilder.addPropertyReference("templateEngine", templateEngineRef);
    }

    protected String[] processReturnAttributes(List<Element> returnAttributes) {
        if (returnAttributes == null || returnAttributes.size() == 0) {
            return null;
        }
        StringTokenizer attributeTokens = new StringTokenizer(returnAttributes.get(0).getTextContent(), " ");
        String[] attributes = new String[attributeTokens.countTokens()];
        int i = 0;
        while (attributeTokens.hasMoreTokens()) {
            attributes[i] = DatatypeHelper.safeTrimOrNullString((String)attributeTokens.nextToken());
            ++i;
        }
        return attributes;
    }

    protected Map<String, String> processLDAPProperties(List<Element> propertyElems) {
        HashMap<String, String> properties = new HashMap<String, String>(5);
        if (propertyElems != null) {
            for (Element propertyElem : propertyElems) {
                String propName = DatatypeHelper.safeTrimOrNullString((String)propertyElem.getAttributeNS(null, "name"));
                String propValue = DatatypeHelper.safeTrimOrNullString((String)propertyElem.getAttributeNS(null, "value"));
                properties.put(propName, propValue);
            }
        }
        return properties;
    }

    protected RuntimeBeanReference processCredential(List<Element> credentials, ParserContext parserContext) {
        if (credentials == null) {
            return null;
        }
        Element credentialElem = credentials.get(0);
        return SpringConfigurationUtils.parseCustomElement(credentialElem, parserContext);
    }
}

