/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.attributeDefinition;

import edu.internet2.middleware.shibboleth.common.attribute.BaseAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.encoding.AttributeEncoder;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.AttributeResolutionException;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.AbstractResolutionPlugIn;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.ShibbolethResolutionContext;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.attributeDefinition.AttributeDefinition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.opensaml.xml.util.LazyMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseAttributeDefinition
extends AbstractResolutionPlugIn<BaseAttribute>
implements AttributeDefinition {
    private final Logger log = LoggerFactory.getLogger(BaseAttributeDefinition.class);
    private boolean dependencyOnly = false;
    private ArrayList<AttributeEncoder> encoders = new ArrayList(3);
    private String sourceAttributeID;
    private Map<Locale, String> displayNames = new LazyMap();
    private Map<Locale, String> displayDescriptions = new LazyMap();

    @Override
    public Map<Locale, String> getDisplayDescriptions() {
        return this.displayDescriptions;
    }

    @Override
    public Map<Locale, String> getDisplayNames() {
        return this.displayNames;
    }

    @Override
    public boolean isDependencyOnly() {
        return this.dependencyOnly;
    }

    public void setDependencyOnly(boolean isDependencyOnly) {
        this.dependencyOnly = isDependencyOnly;
    }

    @Override
    public List<AttributeEncoder> getAttributeEncoders() {
        return this.encoders;
    }

    @Override
    public BaseAttribute resolve(ShibbolethResolutionContext resolutionContext) throws AttributeResolutionException {
        BaseAttribute resolvedAttribute = this.doResolve(resolutionContext);
        if (resolvedAttribute == null) {
            this.log.error("{} produced a null attribute, this is not allowed", (Object)this.getId());
            throw new AttributeResolutionException(String.valueOf(this.getId()) + " produced a null attribute");
        }
        if (this.getDisplayNames() != null) {
            resolvedAttribute.getDisplayNames().putAll(this.displayNames);
        }
        if (this.getDisplayDescriptions() != null) {
            resolvedAttribute.getDisplayDescriptions().putAll(this.displayDescriptions);
        }
        if (this.getAttributeEncoders() != null) {
            resolvedAttribute.getEncoders().addAll(this.getAttributeEncoders());
        }
        return resolvedAttribute;
    }

    protected abstract BaseAttribute doResolve(ShibbolethResolutionContext var1) throws AttributeResolutionException;

    protected Collection<Object> getValuesFromAllDependencies(ShibbolethResolutionContext context) {
        return this.getValuesFromAllDependencies(context, this.getSourceAttributeID());
    }

    public String getSourceAttributeID() {
        if (this.sourceAttributeID != null) {
            return this.sourceAttributeID;
        }
        return this.getId();
    }

    public void setSourceAttributeID(String newSourceAttributeID) {
        this.sourceAttributeID = newSourceAttributeID;
    }
}

