/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.attribute.resolver.provider;

import edu.internet2.middleware.shibboleth.common.attribute.BaseAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.AttributeResolutionException;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.ResolutionPlugIn;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.ShibbolethResolutionContext;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.attributeDefinition.AttributeDefinition;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector.DataConnector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResolutionPlugIn<ResolvedType>
implements ResolutionPlugIn<ResolvedType> {
    private String id;
    private List<String> dependencyIds = new ArrayList<String>();

    @Override
    public List<String> getDependencyIds() {
        return this.dependencyIds;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String newId) {
        this.id = newId;
    }

    protected Collection<Object> getValuesFromAllDependencies(ShibbolethResolutionContext context, String sourceAttribute) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (String id : this.getDependencyIds()) {
            if (context.getResolvedAttributeDefinitions().containsKey(id)) {
                values.addAll(this.getValuesFromAttributeDependency(context, id));
                continue;
            }
            if (!context.getResolvedDataConnectors().containsKey(id)) continue;
            values.addAll(this.getValuesFromConnectorDependency(context, id, sourceAttribute));
        }
        return values;
    }

    protected Collection<Object> getValuesFromAttributeDependency(ShibbolethResolutionContext context, String id) {
        ArrayList<Object> values = new ArrayList<Object>();
        AttributeDefinition definition = context.getResolvedAttributeDefinitions().get(id);
        if (definition != null) {
            try {
                BaseAttribute attribute = (BaseAttribute)definition.resolve(context);
                for (Object o : attribute.getValues()) {
                    values.add(o);
                }
            }
            catch (AttributeResolutionException attributeResolutionException) {
                // empty catch block
            }
        }
        return values;
    }

    protected Collection<Object> getValuesFromConnectorDependency(ShibbolethResolutionContext context, String id, String sourceAttribute) {
        ArrayList<Object> values = new ArrayList<Object>();
        DataConnector connector = context.getResolvedDataConnectors().get(id);
        if (connector != null) {
            try {
                Map attributes = (Map)connector.resolve(context);
                for (String attributeId : attributes.keySet()) {
                    if (attributeId == null || !attributeId.equals(sourceAttribute)) continue;
                    for (Object o : ((BaseAttribute)attributes.get(attributeId)).getValues()) {
                        values.add(o);
                    }
                }
            }
            catch (AttributeResolutionException attributeResolutionException) {
                // empty catch block
            }
        }
        return values;
    }
}

