/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.attribute.encoding.provider;

import edu.internet2.middleware.shibboleth.common.attribute.BaseAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.encoding.AttributeEncodingException;
import edu.internet2.middleware.shibboleth.common.attribute.encoding.SAML2AttributeEncoder;
import edu.internet2.middleware.shibboleth.common.attribute.encoding.provider.AbstractScopedAttributeEncoder;
import java.util.List;
import org.opensaml.Configuration;
import org.opensaml.common.SAMLObjectBuilder;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.AttributeValue;
import org.opensaml.saml2.core.impl.AttributeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAML2ScopedStringAttributeEncoder
extends AbstractScopedAttributeEncoder<Attribute>
implements SAML2AttributeEncoder {
    private final Logger log = LoggerFactory.getLogger(SAML2ScopedStringAttributeEncoder.class);
    private final SAMLObjectBuilder<Attribute> attributeBuilder = (AttributeBuilder)Configuration.getBuilderFactory().getBuilder(Attribute.DEFAULT_ELEMENT_NAME);
    private String format;
    private String friendlyName;

    @Override
    public String getNameFormat() {
        return this.format;
    }

    @Override
    public String getFriendlyName() {
        return this.friendlyName;
    }

    @Override
    public void setNameFormat(String newFormat) {
        this.format = newFormat;
    }

    @Override
    public void setFriendlyName(String name) {
        this.friendlyName = name;
    }

    @Override
    public Attribute encode(BaseAttribute attribute) throws AttributeEncodingException {
        Attribute samlAttribute = (Attribute)this.attributeBuilder.buildObject();
        samlAttribute.setName(this.getAttributeName());
        samlAttribute.setNameFormat(this.getNameFormat());
        samlAttribute.setFriendlyName(this.getFriendlyName());
        samlAttribute.getAttributeValues().addAll(this.encodeAttributeValues(AttributeValue.DEFAULT_ELEMENT_NAME, attribute));
        List attributeValues = samlAttribute.getAttributeValues();
        if (attributeValues == null || attributeValues.isEmpty()) {
            this.log.debug("Unable to encode {} attribute.  It does not contain any values", (Object)attribute.getId());
            return null;
        }
        return samlAttribute;
    }
}

