/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.attribute.encoding.provider;

import edu.internet2.middleware.shibboleth.common.attribute.BaseAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.encoding.provider.AbstractAttributeEncoder;
import edu.internet2.middleware.shibboleth.common.attribute.provider.ScopedAttributeValue;
import edu.internet2.middleware.shibboleth.common.xmlobject.ShibbolethScopedValue;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.opensaml.Configuration;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.XMLObjectBuilder;
import org.opensaml.xml.schema.XSString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractScopedAttributeEncoder<EncodedType>
extends AbstractAttributeEncoder<EncodedType> {
    private final XMLObjectBuilder<ShibbolethScopedValue> shibScopeValueBuilder = Configuration.getBuilderFactory().getBuilder(ShibbolethScopedValue.TYPE_NAME);
    private final XMLObjectBuilder<XSString> stringValueBuilder = Configuration.getBuilderFactory().getBuilder(XSString.TYPE_NAME);
    private String scopeType;
    private String scopeDelimiter;
    private String scopeAttribute;

    public String getScopeAttribute() {
        return this.scopeAttribute;
    }

    public String getScopeDelimiter() {
        return this.scopeDelimiter;
    }

    public String getScopeType() {
        return this.scopeType;
    }

    public void setScopeAttribute(String newScopeAttribute) {
        this.scopeAttribute = newScopeAttribute;
    }

    public void setScopeDelimiter(String newScopeDelimiter) {
        this.scopeDelimiter = newScopeDelimiter;
    }

    public void setScopeType(String newScopeType) {
        this.scopeType = newScopeType;
    }

    protected List<XMLObject> encodeAttributeValues(QName objectName, BaseAttribute<ScopedAttributeValue> attribute) {
        ArrayList<XMLObject> encodedValues;
        block3: {
            block2: {
                encodedValues = new ArrayList<XMLObject>();
                if (!"attribute".equals(this.getScopeType())) break block2;
                for (ScopedAttributeValue attributeValue : attribute.getValues()) {
                    if (attributeValue == null) continue;
                    ShibbolethScopedValue scopedValue = (ShibbolethScopedValue)this.shibScopeValueBuilder.buildObject(objectName);
                    scopedValue.setScopeAttributeName(this.getScopeAttribute());
                    scopedValue.setScope(attributeValue.getScope());
                    scopedValue.setValue(attributeValue.getValue());
                    encodedValues.add((XMLObject)scopedValue);
                }
                break block3;
            }
            if (!"inline".equals(this.getScopeType())) break block3;
            for (ScopedAttributeValue attributeValue : attribute.getValues()) {
                if (attributeValue == null) continue;
                XSString scopedValue = (XSString)this.stringValueBuilder.buildObject(objectName, XSString.TYPE_NAME);
                scopedValue.setValue(String.valueOf(attributeValue.getValue()) + this.getScopeDelimiter() + attributeValue.getScope());
                encodedValues.add((XMLObject)scopedValue);
            }
        }
        return encodedValues;
    }
}

