/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.metadata.provider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.xml.namespace.QName;
import org.joda.time.DateTime;
import org.opensaml.saml2.common.Extensions;
import org.opensaml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml2.metadata.provider.BaseMetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataFilter;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.saml2.metadata.provider.ObservableMetadataProvider;
import org.opensaml.xml.Namespace;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.util.IDIndex;
import org.opensaml.xml.util.LazySet;
import org.opensaml.xml.validation.ValidationException;
import org.opensaml.xml.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainingMetadataProvider
extends BaseMetadataProvider
implements ObservableMetadataProvider {
    private final Logger log = LoggerFactory.getLogger(ChainingMetadataProvider.class);
    private ArrayList<ObservableMetadataProvider.Observer> observers = new ArrayList();
    private ArrayList<MetadataProvider> providers = new ArrayList();
    private ReadWriteLock providerLock = new ReentrantReadWriteLock(true);

    public List<MetadataProvider> getProviders() {
        return Collections.unmodifiableList(this.providers);
    }

    public void setProviders(List<MetadataProvider> newProviders) throws MetadataProviderException {
        this.providers.clear();
        for (MetadataProvider provider : newProviders) {
            this.addMetadataProvider(provider);
        }
    }

    public void addMetadataProvider(MetadataProvider newProvider) throws MetadataProviderException {
        if (newProvider != null) {
            newProvider.setRequireValidMetadata(this.requireValidMetadata());
            if (newProvider instanceof ObservableMetadataProvider) {
                ((ObservableMetadataProvider)newProvider).getObservers().add(new ContainedProviderObserver());
            }
            this.providers.add(newProvider);
        }
    }

    public void removeMetadataProvider(MetadataProvider provider) {
        this.providers.remove(provider);
    }

    @Override
    public void setRequireValidMetadata(boolean requireValidMetadata) {
        super.setRequireValidMetadata(requireValidMetadata);
        Lock writeLock = this.providerLock.writeLock();
        writeLock.lock();
        for (MetadataProvider provider : this.providers) {
            provider.setRequireValidMetadata(requireValidMetadata);
        }
        writeLock.unlock();
    }

    @Override
    public MetadataFilter getMetadataFilter() {
        this.log.warn("Attempt to access unsupported MetadataFilter property on ChainingMetadataProvider");
        return null;
    }

    @Override
    public void setMetadataFilter(MetadataFilter newFilter) throws MetadataProviderException {
        throw new UnsupportedOperationException("Metadata filter is not allowed on ChainingMetadataProvider");
    }

    @Override
    public XMLObject getMetadata() throws MetadataProviderException {
        return new ChainingEntitiesDescriptor();
    }

    @Override
    public EntitiesDescriptor getEntitiesDescriptor(String name) throws MetadataProviderException {
        Lock readLock = this.providerLock.readLock();
        readLock.lock();
        EntitiesDescriptor descriptor = null;
        try {
            for (MetadataProvider provider : this.providers) {
                this.log.debug("Checking child metadata provider for entities descriptor with name: {}", (Object)name);
                descriptor = provider.getEntitiesDescriptor(name);
                if (descriptor == null) continue;
                break;
            }
        }
        finally {
            readLock.unlock();
        }
        return descriptor;
    }

    @Override
    public EntityDescriptor getEntityDescriptor(String entityID) throws MetadataProviderException {
        Lock readLock = this.providerLock.readLock();
        readLock.lock();
        EntityDescriptor descriptor = null;
        try {
            for (MetadataProvider provider : this.providers) {
                this.log.debug("Checking child metadata provider for entity descriptor with entity ID: {}", (Object)entityID);
                descriptor = provider.getEntityDescriptor(entityID);
                if (descriptor == null) continue;
                break;
            }
        }
        finally {
            readLock.unlock();
        }
        return descriptor;
    }

    @Override
    public List<RoleDescriptor> getRole(String entityID, QName roleName) throws MetadataProviderException {
        EntityDescriptor entityMetadata = this.getEntityDescriptor(entityID);
        if (entityMetadata == null) {
            return null;
        }
        return entityMetadata.getRoleDescriptors(roleName);
    }

    @Override
    public RoleDescriptor getRole(String entityID, QName roleName, String supportedProtocol) throws MetadataProviderException {
        EntityDescriptor entityMetadata = this.getEntityDescriptor(entityID);
        if (entityMetadata == null) {
            return null;
        }
        List<RoleDescriptor> roles = entityMetadata.getRoleDescriptors(roleName, supportedProtocol);
        if (roles != null && !roles.isEmpty()) {
            return roles.get(0);
        }
        return null;
    }

    @Override
    public List<ObservableMetadataProvider.Observer> getObservers() {
        return this.observers;
    }

    protected void emitChangeEvent() {
        if (this.observers == null || this.observers.size() == 0) {
            return;
        }
        ArrayList<ObservableMetadataProvider.Observer> tempObserverList = new ArrayList<ObservableMetadataProvider.Observer>(this.observers);
        for (ObservableMetadataProvider.Observer observer : tempObserverList) {
            if (observer == null) continue;
            observer.onEvent(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ChainingEntitiesDescriptor
    implements EntitiesDescriptor {
        private ArrayList<XMLObject> childDescriptors = new ArrayList();

        public ChainingEntitiesDescriptor() {
            Lock readLock = ChainingMetadataProvider.this.providerLock.readLock();
            readLock.lock();
            try {
                try {
                    for (MetadataProvider provider : ChainingMetadataProvider.this.providers) {
                        this.childDescriptors.add(provider.getMetadata());
                    }
                }
                catch (MetadataProviderException e) {
                    ChainingMetadataProvider.this.log.error("Unable to get metadata from child metadata provider", (Throwable)e);
                    readLock.unlock();
                }
            }
            finally {
                readLock.unlock();
            }
        }

        @Override
        public List<EntitiesDescriptor> getEntitiesDescriptors() {
            ArrayList<EntitiesDescriptor> descriptors = new ArrayList<EntitiesDescriptor>();
            for (XMLObject descriptor : this.childDescriptors) {
                if (!(descriptor instanceof EntitiesDescriptor)) continue;
                descriptors.add((EntitiesDescriptor)descriptor);
            }
            return descriptors;
        }

        @Override
        public List<EntityDescriptor> getEntityDescriptors() {
            ArrayList<EntityDescriptor> descriptors = new ArrayList<EntityDescriptor>();
            for (XMLObject descriptor : this.childDescriptors) {
                if (!(descriptor instanceof EntityDescriptor)) continue;
                descriptors.add((EntityDescriptor)descriptor);
            }
            return descriptors;
        }

        @Override
        public Extensions getExtensions() {
            return null;
        }

        @Override
        public String getID() {
            return null;
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public void setExtensions(Extensions extensions) {
        }

        @Override
        public void setID(String newID) {
        }

        @Override
        public void setName(String name) {
        }

        @Override
        public String getSignatureReferenceID() {
            return null;
        }

        public Signature getSignature() {
            return null;
        }

        public boolean isSigned() {
            return false;
        }

        public void setSignature(Signature newSignature) {
        }

        public void addNamespace(Namespace namespace) {
        }

        public void detach() {
        }

        public Element getDOM() {
            return null;
        }

        public QName getElementQName() {
            return EntitiesDescriptor.DEFAULT_ELEMENT_NAME;
        }

        public IDIndex getIDIndex() {
            return null;
        }

        public Set<Namespace> getNamespaces() {
            return new LazySet();
        }

        public String getNoNamespaceSchemaLocation() {
            return null;
        }

        public List<XMLObject> getOrderedChildren() {
            ArrayList<XMLObject> descriptors = new ArrayList<XMLObject>();
            try {
                for (MetadataProvider provider : ChainingMetadataProvider.this.providers) {
                    descriptors.add(provider.getMetadata());
                }
            }
            catch (MetadataProviderException e) {
                ChainingMetadataProvider.this.log.error("Unable to generate list of child descriptors", (Throwable)e);
            }
            return descriptors;
        }

        public XMLObject getParent() {
            return null;
        }

        public String getSchemaLocation() {
            return null;
        }

        public QName getSchemaType() {
            return EntitiesDescriptor.TYPE_NAME;
        }

        public boolean hasChildren() {
            return !this.getOrderedChildren().isEmpty();
        }

        public boolean hasParent() {
            return false;
        }

        public void releaseChildrenDOM(boolean propagateRelease) {
        }

        public void releaseDOM() {
        }

        public void releaseParentDOM(boolean propagateRelease) {
        }

        public void removeNamespace(Namespace namespace) {
        }

        public XMLObject resolveID(String id) {
            return null;
        }

        public XMLObject resolveIDFromRoot(String id) {
            return null;
        }

        public void setDOM(Element dom) {
        }

        public void setNoNamespaceSchemaLocation(String location) {
        }

        public void setParent(XMLObject parent) {
        }

        public void setSchemaLocation(String location) {
        }

        public void deregisterValidator(Validator validator) {
        }

        public List<Validator> getValidators() {
            return new ArrayList<Validator>();
        }

        public void registerValidator(Validator validator) {
        }

        public void validate(boolean validateDescendants) throws ValidationException {
        }

        @Override
        public DateTime getValidUntil() {
            return null;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public void setValidUntil(DateTime validUntil) {
        }

        @Override
        public Long getCacheDuration() {
            return null;
        }

        @Override
        public void setCacheDuration(Long duration) {
        }
    }

    private class ContainedProviderObserver
    implements ObservableMetadataProvider.Observer {
        private ContainedProviderObserver() {
        }

        public void onEvent(MetadataProvider provider) {
            ChainingMetadataProvider.this.emitChangeEvent();
        }
    }
}

