/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core;

import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.status.ErrorStatus;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WriterAppender<E>
extends UnsynchronizedAppenderBase<E> {
    private boolean immediateFlush = true;
    private String encoding;
    private Writer writer;

    public void setImmediateFlush(boolean value) {
        this.immediateFlush = value;
    }

    public boolean getImmediateFlush() {
        return this.immediateFlush;
    }

    @Override
    public void start() {
        int errors = 0;
        if (this.layout == null) {
            this.addStatus(new ErrorStatus("No layout set for the appender named \"" + this.name + "\".", this));
            ++errors;
        }
        if (this.writer == null) {
            this.addStatus(new ErrorStatus("No writer set for the appender named \"" + this.name + "\".", this));
            ++errors;
        }
        if (errors == 0) {
            super.start();
        }
    }

    @Override
    protected void append(E eventObject) {
        if (!this.isStarted()) {
            return;
        }
        this.subAppend(eventObject);
    }

    @Override
    public synchronized void stop() {
        this.closeWriter();
        super.stop();
    }

    protected void closeWriter() {
        if (this.writer != null) {
            try {
                this.writeFooter();
                this.writer.close();
                this.writer = null;
            }
            catch (IOException e) {
                this.addStatus(new ErrorStatus("Could not close writer for WriterAppener.", this, e));
            }
        }
    }

    protected OutputStreamWriter createWriter(OutputStream os) {
        OutputStreamWriter retval;
        block2: {
            retval = null;
            String enc = this.getEncoding();
            try {
                retval = enc != null ? new OutputStreamWriter(os, enc) : new OutputStreamWriter(os);
            }
            catch (IOException e) {
                this.addStatus(new ErrorStatus("Error initializing output writer.", this, e));
                if (enc == null) break block2;
                this.addStatus(new ErrorStatus("Unsupported encoding?", this));
            }
        }
        return retval;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String value) {
        this.encoding = value;
    }

    void writeHeader() {
        if (this.layout != null && this.writer != null) {
            try {
                StringBuilder sb = new StringBuilder();
                this.appendIfNotNull(sb, this.layout.getFileHeader());
                this.appendIfNotNull(sb, this.layout.getPresentationHeader());
                if (sb.length() > 0) {
                    sb.append(CoreConstants.LINE_SEPARATOR);
                    this.writerWrite(sb.toString(), true);
                }
            }
            catch (IOException ioe) {
                this.started = false;
                this.addStatus(new ErrorStatus("Failed to write header for appender named [" + this.name + "].", this, ioe));
            }
        }
    }

    private void appendIfNotNull(StringBuilder sb, String s) {
        if (s != null) {
            sb.append(s);
        }
    }

    void writeFooter() {
        if (this.layout != null && this.writer != null) {
            try {
                StringBuilder sb = new StringBuilder();
                this.appendIfNotNull(sb, this.layout.getPresentationFooter());
                this.appendIfNotNull(sb, this.layout.getFileFooter());
                if (sb.length() > 0) {
                    this.writerWrite(sb.toString(), true);
                }
            }
            catch (IOException ioe) {
                this.started = false;
                this.addStatus(new ErrorStatus("Failed to write footer for appender named [" + this.name + "].", this, ioe));
            }
        }
    }

    public synchronized void setWriter(Writer writer) {
        this.closeWriter();
        this.writer = writer;
        this.writeHeader();
    }

    protected void writerWrite(String s, boolean flush) throws IOException {
        this.writer.write(s);
        if (flush) {
            this.writer.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void subAppend(E event) {
        if (!this.isStarted()) {
            return;
        }
        try {
            String output = this.layout.doLayout(event);
            WriterAppender writerAppender = this;
            synchronized (writerAppender) {
                this.writerWrite(output, this.immediateFlush);
            }
        }
        catch (IOException ioe) {
            this.started = false;
            this.addStatus(new ErrorStatus("IO failure in appender", this, ioe));
        }
    }
}

