/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.ldif.servlets;

import edu.vt.middleware.ldap.ldif.util.LdifSearch;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class SearchServlet
extends HttpServlet {
    private static final Log LOG = LogFactory.getLog(SearchServlet.class);
    private LdifSearch search;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String propertiesFile = this.getInitParameter("edu.vt.middleware.ldap.ldif.servlets.propertiesFile");
        if (propertiesFile != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("edu.vt.middleware.ldap.ldif.servlets.propertiesFile = " + propertiesFile));
            }
            this.search = new LdifSearch(propertiesFile);
        } else {
            this.search = new LdifSearch();
        }
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/plain");
        try {
            this.search.search(request.getParameter("query"), request.getParameterValues("attrs"), (OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"Error performing search", (Throwable)e);
            }
            throw new ServletException(e.getMessage());
        }
    }

    public void destroy() {
        super.destroy();
    }
}

