/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.dsml.util;

import edu.vt.middleware.ldap.dsml.util.AbstractDsml;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public final class Dsmlv1
extends AbstractDsml {
    private static final Log LOG = LogFactory.getLog(Dsmlv1.class);

    public Document createDsml(Iterator results) {
        Document doc;
        block6: {
            Namespace ns = new Namespace("dsml", "http://www.dsml.org/DSML");
            doc = DocumentHelper.createDocument();
            Element dsmlElement = doc.addElement(new QName("dsml", ns));
            Element entriesElement = dsmlElement.addElement(new QName("directory-entries", ns));
            if (results != null) {
                try {
                    while (results.hasNext()) {
                        try {
                            SearchResult sr = (SearchResult)results.next();
                            Element entryElement = this.createDsmlEntry(new QName("entry", ns), sr, ns);
                            entriesElement.add(entryElement);
                        }
                        catch (ClassCastException e) {
                            if (!LOG.isDebugEnabled()) continue;
                            LOG.debug((Object)"Could not cast item in Iterator as a SearchResult");
                        }
                    }
                }
                catch (NamingException e) {
                    if (!LOG.isErrorEnabled()) break block6;
                    LOG.error((Object)"Error creating Element from SearchResult", (Throwable)e);
                }
            }
        }
        return doc;
    }

    protected Element createDsmlAttribute(String attrName, List attrValues, Namespace ns) {
        Element attrElement = DocumentHelper.createElement((String)"");
        if (attrName != null) {
            if (attrName.equalsIgnoreCase("objectclass")) {
                attrElement.setQName(new QName("objectclass", ns));
                if (attrValues != null) {
                    for (String value : attrValues) {
                        if (value == null) continue;
                        Element ocValueElement = attrElement.addElement(new QName("oc-value", ns));
                        ocValueElement.addText(value);
                    }
                }
            } else {
                attrElement = super.createDsmlAttribute(attrName, attrValues, ns);
            }
        }
        return attrElement;
    }

    public Iterator createSearchResults(Document doc) {
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        if (doc != null && doc.hasContent()) {
            Iterator entryIterator = doc.selectNodes("/dsml:dsml/dsml:directory-entries/dsml:entry").iterator();
            while (entryIterator.hasNext()) {
                SearchResult result = this.createSearchResult((Element)entryIterator.next());
                if (result == null) continue;
                results.add(result);
            }
        }
        return results.iterator();
    }

    protected SearchResult createSearchResult(Element entryElement) {
        BasicAttributes entryAttributes;
        String name;
        block9: {
            NamingEnumeration<? extends Attribute> ae;
            Attributes attrs;
            name = "";
            entryAttributes = new BasicAttributes(true);
            SearchResult attrResults = null;
            if (entryElement != null) {
                name = entryElement.attributeValue("dn");
                if (name == null) {
                    name = "";
                }
                if (entryElement.hasContent()) {
                    Iterator ocIterator = entryElement.elementIterator("objectclass");
                    while (ocIterator.hasNext()) {
                        Element ocElement = (Element)ocIterator.next();
                        if (ocElement == null || !ocElement.hasContent()) continue;
                        String ocName = "objectClass";
                        BasicAttribute entryAttribute = new BasicAttribute("objectClass");
                        Iterator valueIterator = ocElement.elementIterator("oc-value");
                        while (valueIterator.hasNext()) {
                            String value;
                            Element valueElement = (Element)valueIterator.next();
                            if (valueElement == null || (value = valueElement.getText()) == null) continue;
                            entryAttribute.add(value);
                        }
                        entryAttributes.put(entryAttribute);
                    }
                    attrResults = super.createSearchResult(entryElement);
                }
            }
            if (attrResults != null && (attrs = attrResults.getAttributes()) != null && (ae = attrs.getAll()) != null) {
                try {
                    while (ae.hasMore()) {
                        entryAttributes.put(ae.next());
                    }
                }
                catch (NamingException e) {
                    if (!LOG.isDebugEnabled()) break block9;
                    LOG.debug((Object)"Could not read attribute in SearchResult from parent");
                }
            }
        }
        return new SearchResult(name, (Object)null, entryAttributes);
    }

    public static void main(String[] args) throws Exception {
        Dsmlv1 dsml = new Dsmlv1();
        dsml.doMain(args);
    }
}

