/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.dsml.util;

import edu.vt.middleware.ldap.LdapUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public abstract class AbstractDsml
implements Serializable {
    private static final long serialVersionUID = 4592623327086591849L;
    private static final Log LOG = LogFactory.getLog(AbstractDsml.class);

    public Document createDsml(NamingEnumeration results) throws NamingException {
        return this.createDsml(LdapUtil.parseNamingEnumeration(results).iterator());
    }

    public abstract Document createDsml(Iterator var1);

    protected Element createDsmlEntry(QName entryName, SearchResult result, Namespace ns) throws NamingException {
        Element entryElement = DocumentHelper.createElement((QName)entryName);
        if (result != null) {
            String dn = result.getName();
            if (dn != null) {
                entryElement.addAttribute("dn", dn);
            }
            Map attrs = LdapUtil.parseAttributes(result.getAttributes(), true);
            for (String attrName : attrs.keySet()) {
                List attrValues;
                Element attrElement = this.createDsmlAttribute(attrName, attrValues = (List)attrs.get(attrName), ns);
                if (!attrElement.hasContent()) continue;
                entryElement.add(attrElement);
            }
        }
        return entryElement;
    }

    protected Element createDsmlAttribute(String attrName, List attrValues, Namespace ns) {
        Element attrElement = DocumentHelper.createElement((String)"");
        if (attrName != null) {
            attrElement.setQName(new QName("attr", ns));
            attrElement.addAttribute("name", attrName);
            if (attrValues != null) {
                for (String value : attrValues) {
                    if (value == null) continue;
                    Element valueElement = attrElement.addElement(new QName("value", ns));
                    valueElement.addText(value);
                }
            }
        }
        return attrElement;
    }

    public void outputDsml(Iterator results, OutputStream out) throws IOException {
        this.output(this.createDsml(results), out);
    }

    public void outputDsml(NamingEnumeration results, OutputStream out) throws IOException, NamingException {
        this.output(this.createDsml(results), out);
    }

    public void output(Document doc, OutputStream out) throws IOException {
        if (doc != null && out != null) {
            XMLWriter writer = new XMLWriter(out, OutputFormat.createPrettyPrint());
            writer.write(doc);
        }
    }

    public String outputDsmlToString(Iterator results) {
        return this.outputToString(this.createDsml(results));
    }

    public String outputDsmlToString(NamingEnumeration results) throws NamingException {
        return this.outputToString(this.createDsml(results));
    }

    public String outputToString(Document doc) {
        StringWriter out;
        block3: {
            out = new StringWriter();
            if (doc != null) {
                XMLWriter writer = new XMLWriter((Writer)out, OutputFormat.createPrettyPrint());
                try {
                    writer.write(doc);
                }
                catch (IOException e) {
                    if (!LOG.isErrorEnabled()) break block3;
                    LOG.error((Object)"Could not write XML to StringWriter", (Throwable)e);
                }
            }
        }
        return out.toString();
    }

    public Iterator createSearchResults(URL url) throws DocumentException, IOException {
        Document dsml = new SAXReader().read(url);
        return this.createSearchResults(dsml);
    }

    public Iterator createSearchResults(File file) throws DocumentException, IOException {
        Document dsml = new SAXReader().read(file);
        return this.createSearchResults(dsml);
    }

    public Iterator createSearchResults(InputStream is) throws DocumentException, IOException {
        Document dsml = new SAXReader().read(is);
        return this.createSearchResults(dsml);
    }

    public Iterator createSearchResults(Reader reader) throws DocumentException, IOException {
        Document dsml = new SAXReader().read(reader);
        return this.createSearchResults(dsml);
    }

    public abstract Iterator createSearchResults(Document var1);

    protected SearchResult createSearchResult(Element entryElement) {
        String name = "";
        BasicAttributes entryAttributes = new BasicAttributes(true);
        if (entryElement != null) {
            name = entryElement.attributeValue("dn");
            if (name == null) {
                name = "";
            }
            if (entryElement.hasContent()) {
                Iterator attrIterator = entryElement.elementIterator("attr");
                while (attrIterator.hasNext()) {
                    String attrName;
                    Element attrElement = (Element)attrIterator.next();
                    if (attrElement == null || (attrName = attrElement.attributeValue("name")) == null || !attrElement.hasContent()) continue;
                    BasicAttribute entryAttribute = new BasicAttribute(attrName);
                    Iterator valueIterator = attrElement.elementIterator("value");
                    while (valueIterator.hasNext()) {
                        String value;
                        Element valueElement = (Element)valueIterator.next();
                        if (valueElement == null || (value = valueElement.getText()) == null) continue;
                        entryAttribute.add(value);
                    }
                    entryAttributes.put(entryAttribute);
                }
            }
        }
        return new SearchResult(name, (Object)null, entryAttributes);
    }

    protected void doMain(String[] args) throws Exception {
        this.outputDsml(LdapUtil.runCommandline(args), (OutputStream)System.out);
    }
}

