/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap;

import edu.vt.middleware.ldap.Ldap;
import edu.vt.middleware.ldap.LdapConfig;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.PoolableObjectFactory;

public class PoolableLdapFactory
implements PoolableObjectFactory {
    private static final Log LOG = LogFactory.getLog(PoolableLdapFactory.class);
    private LdapConfig config;
    private String propertiesFile;

    public PoolableLdapFactory() {
    }

    public PoolableLdapFactory(LdapConfig ldapConfig) {
        this.config = ldapConfig;
    }

    public PoolableLdapFactory(String propertiesFile) {
        this.propertiesFile = propertiesFile;
    }

    public void activateObject(Object obj) {
        block2: {
            try {
                ((Ldap)obj).connect();
            }
            catch (NamingException e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error((Object)"Error connecting to the LDAP", (Throwable)e);
            }
        }
    }

    public void destroyObject(Object obj) {
        ((Ldap)obj).close();
    }

    public Object makeObject() {
        Ldap ldap = null;
        if (this.config != null) {
            ldap = new Ldap(this.config);
        } else {
            ldap = new Ldap();
            if (this.propertiesFile != null) {
                ldap.loadFromProperties(this.propertiesFile);
            } else {
                ldap.loadFromProperties();
            }
        }
        return ldap;
    }

    public void passivateObject(Object obj) {
    }

    public boolean validateObject(Object obj) {
        return true;
    }
}

