/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap;

import edu.vt.middleware.ldap.LdapAttribute;
import edu.vt.middleware.ldap.LdapEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LdapResult {
    private static final Log LOG = LogFactory.getLog(LdapResult.class);
    private Map entries = new HashMap();

    public LdapResult() {
    }

    public LdapResult(LdapResult r) {
        this.addEntries(r.getEntries());
    }

    public LdapResult(LdapEntry e) {
        this.addEntry(e);
    }

    public List getEntries() {
        return new ArrayList(this.entries.values());
    }

    public LdapEntry getEntry(String dn) {
        return (LdapEntry)this.entries.get(dn);
    }

    public void addEntry(LdapEntry e) {
        this.entries.put(e.getDn(), e);
    }

    public void addEntries(List l) {
        for (LdapEntry e : l) {
            this.entries.put(e.getDn(), e);
        }
    }

    public void clear() {
        this.entries.clear();
    }

    public List toSearchResults() {
        ArrayList<SearchResult> results = new ArrayList<SearchResult>(this.entries.size());
        for (LdapEntry entry : this.entries.values()) {
            BasicAttributes entryAttributes = new BasicAttributes(true);
            for (LdapAttribute attr : entry.getAttributes()) {
                BasicAttribute entryAttribute = new BasicAttribute(attr.getName());
                Iterator k = attr.getValues().iterator();
                while (k.hasNext()) {
                    entryAttribute.add(k.next());
                }
                entryAttributes.put(entryAttribute);
            }
            results.add(new SearchResult(entry.getDn(), (Object)null, entryAttributes));
        }
        return results;
    }
}

